local LD = require("design.LevelDesignLibrary")
uiCalls = require("ui.uicalls")
local thisLevel, player, riv975, ChiselElevator, ElevatorManager, pad
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  SoundInit()
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
end
function OnStart(level)
  SoundOnStart()
end
function ClearSlowWalk()
  player:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function ElevatorUp()
  GameObjects.EntZn_ElevatorUp:ShowEntityVolume()
  GameObjects.EntZn_ElevatorDown:HideEntityVolume()
end
function ElevatorDown()
  GameObjects.EntZn_ElevatorDown:ShowEntityVolume()
  GameObjects.EntZn_ElevatorUp:HideEntityVolume()
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if game.Level.GetVariable("CompletedCineNumber") >= 320 and game.Level.GetVariable("CompletedCineNumber") < 331 then
    return "AI_Visit_02"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 360 and game.Level.GetVariable("CompletedCineNumber") < 371 then
    return "FreyaTendsSon"
  elseif game.Level.GetVariable("CompletedCineNumber") > 370 and game.Level.GetVariable("CompletedCineNumber") < 391 then
    return "SonHealed_DemiGodReveal"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 390 then
    return "Only_AI_Visit_03"
  else
    return "NoCineNoAIVisit"
  end
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Riverpass Chisel Dungeon")
  ChiselLabor()
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_Riv")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_Riv")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
function LoadCheck_Riv925()
  game.UI.LoadCheck("Riv925_FreyaCave")
end
function LoadCheck_Riv975()
  game.UI.LoadCheck("Riv975_ChiselArena")
end
function Riv975_LTW_Enable()
  local riv975 = game.FindLevel("Riv975_ChiselArena")
  if riv975 ~= nil then
    riv975:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
function Riv975_LTW_Disable()
  local riv975 = game.FindLevel("Riv975_ChiselArena")
  if riv975 ~= nil then
    riv975:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
end
