local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, Enc_Valkyrie_Fight
function OnScriptLoaded(level, obj)
  thisLevel = level
  Fnc_Arena_Valkyrie_Fight()
end
function Fnc_Arena_Valkyrie_Fight()
  Enc_Valkyrie_Fight = EC.NewEncounter(thisLevel, "[Riv975 - Chisel Arena]EC: Valkyrie00", {
    CheckpointOnComplete = false,
    spawnWad = "Riv975_AI01",
    LeashZone = "LshZn_Riv975_Valk"
  })
  Enc_Valkyrie_Fight:AddWave({
    {
      spawners = "Valkyrie_Summoner_SSD",
      markerID = "Valkyrie_Riv975",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Enc_Valkyrie_Fight:OnEnemyDeath(function()
    Enc_Valkyrie_Fight:DespawnEnemies()
    Enc_Valkyrie_Fight:SetComplete()
    _G.SetEncounterComplete()
    _G.CA_Arena_Enable()
    _G.LTW_Lobby_Enable()
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
  end, {
    markerID = "Valkyrie_Riv975"
  })
  Enc_Valkyrie_Fight:SetStartZone(GameObjects.EntZn_Valkyrie_Spawn)
  Enc_Valkyrie_Fight:SetAlertZone(GameObjects.EntZn_Valkyrie_Alert)
end
