local LD = require("design.LevelDesignLibrary")
player = nil
local soundGustHammer, finalBoss, thisLevel
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  game.Audio.StartMusicMaster("SND_MX_STN_start_master")
end
function OnStart()
  if game.Level.GetVariable("CompletedCineNumber") >= 355 then
    AfterHammerZonesOn()
  else
    AfterHammerZonesOff()
  end
end
function AfterHammerZonesOff()
  GameObjects.SNDGrpPreHammer:Show()
  GameObjects.SNDGrpPostHammer:Hide()
  GameObjects.SNDZnGrpPostHammer:Hide()
  HideShortcutZone()
  ShowPreHammerMPS()
  HidePostHammerMPS()
end
function AfterHammerZonesOn()
  GameObjects.SNDGrpPreHammer:Hide()
  GameObjects.SNDGrpPostHammer:Show()
  GameObjects.SNDZnGrpPostHammer:Show()
  HidePreHammerMPS()
  ShowPostHammerMPS()
  if game.Level.GetVariable("CompletedCineNumber") < 360 then
    HideShortcutZone()
  else
    ShowShortcutZone()
  end
end
function OnHammerStateHookFall(level)
  print("////////////////// HammerStateHookFallen ///////////////////////")
end
function HidePreHammerMPS()
  print("turning off pre-hammer multi position sounds")
  local mpse = thisLevel:FindGameObjects("SNDa*")
  for i = 1, #mpse do
    mpse[i]:Hide()
  end
end
function ShowPreHammerMPS()
  print("turning on pre-hammer multi position sounds")
  local mpse = thisLevel:FindGameObjects("SNDa*")
  for i = 1, #mpse do
    mpse[i]:Show()
  end
end
function HidePostHammerMPS()
  print("turning off post-hammer multi position sounds")
  local mpse = thisLevel:FindGameObjects("SNDb*")
  for i = 1, #mpse do
    mpse[i]:Hide()
  end
end
function ShowPostHammerMPS()
  print("turning on post-hammer multi position sounds")
  local mpse = thisLevel:FindGameObjects("SNDb*")
  for i = 1, #mpse do
    mpse[i]:Show()
  end
end
function ShowShortcutZone()
  print("ShowShortcutZone")
  GameObjects.SNDZnGrpShortcut:Show()
end
function HideShortcutZone()
  print("HideShortcutZone")
  GameObjects.SNDZnGrpShortcut:Hide()
end
function UnderHandEnterMusic()
  game.Audio.StartMusic("SND_MX_STN_hand_under_explore_in")
end
function UnderHandExitMusic()
  game.Audio.StartMusic("SND_MX_STN_hand_under_explore_out")
end
function musicLakeHeadEnter()
  game.Audio.StartMusic("SND_MX_STN_lake_explore_out")
end
function ElevatorExitMusic()
  print("music used to be here")
end
function BanquetEnterMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_banquet_hall_enter")
end
function stnRevisitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 365 then
    game.Audio.StartCheckpointedMusic("SND_MX_STN_revisit_explore_in")
  end
end
function stnRevisitIdle()
  if game.Level.GetVariable("CompletedCineNumber") >= 365 then
    game.Audio.StartCheckpointedMusic("SND_MX_TRANS_TO_IDLE")
  end
end
