local LD = require("design.LevelDesignLibrary")
local btrPlayed = {
  beachCrystalDelayShot = false,
  beachCrystal1HintBool = false,
  beachCrystalSolvedBool = false
}
local ringStartAnimFrame = 45
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  ringStartAnimFrame = GameObjects.RingRotateAnim.AnimFrame
end
function OnSaveCheckpoint(level, obj)
  return {played = btrPlayed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  btrPlayed = savedInfo.played
end
function RingCrystalCallout()
  if not btrPlayed.beachCrystal1HintBool then
    game.Audio.PlayBanter("stn_BeachCrystal_C1_Delay")
    btrPlayed.beachCrystal1HintBool = true
  end
end
function IciclesBroken()
  if not btrPlayed.beachCrystalSolvedBool then
    game.Audio.PlayBanter("stn_BeachCrystal")
    btrPlayed.beachCrystalSolvedBool = true
  end
end
function CrankNotTouched()
  game.Audio.PlayBanter("stn_BeachCrystal_C2_DelayShot")
end
function RingShot1()
  btrPlayed.beachCrystal1HintBool = true
  LD.CallFunctionAfterDelay(BeachCrystalDelay2, 15)
end
function BeachCrystalDelay2()
  if GameObjects.RingRotateAnim.AnimFrame == ringStartAnimFrame and not btrPlayed.beachCrystalSolvedBool and not btrPlayed.beachCrystalC3Bool then
    game.Audio.PlayBanter("stn_BeachCrystal_C2_Delay")
  end
end
