local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, son, kratosActor
local boolThamurAheadBanter = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if boolThamurAheadBanter == true then
    thisObj:Hide()
    return
  end
  local completedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  local cineBool = 340 <= completedCineNumber and completedCineNumber < 350
  if cineBool and boolThamurAheadBanter == false then
    CreateActors()
    CreateThamurAheadSeq()
  end
end
function OnSaveCheckpoint(level)
  return {boolThamurAheadBanter = boolThamurAheadBanter}
end
function OnRestoreCheckpoint(level, savedInfo)
  boolThamurAheadBanter = savedInfo.boolThamurAheadBanter
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
end
function CreateThamurAheadSeq()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "ThamurAhead")
  seq:WaitForActorInZone(kratosActor, thisObj)
  seq:Do(SetThamurAheadReadyBtrFact)
  seq:WaitForFunctionTrue(CanPlayThamurAhead)
  seq:Do(PlayThamurAheadPOI)
  seq:StartSequence()
end
function SetThamurAheadReadyBtrFact()
  game.Audio.SetBanterFact("ThamurAheadReady", true, 30)
end
function CanPlayThamurAhead()
  return game.Audio.CanBanterConversationPlay("stn_ThamurAhead") and boolThamurAheadBanter == false
end
function PlayThamurAheadPOI()
  if game.Player.FindPlayer():IsInsideEntityZone(thisObj) == true and game.Boat.GetPlayerBoat() ~= nil and not son:IsPlayingMove("MOV_BoatEnterR") and not son:IsPlayingMove("MOV_BoatEnterL") and not son:IsPlayingMove("MOV_BoatEnterPushOffLMimir") and not son:IsPlayingMove("MOV_BoatEnterPushOffRMimir") and not son:IsPlayingMove("MOV_BoatExitL") and not son:IsPlayingMove("MOV_BoatExitR") and not son:IsPlayingMove("MOV_BoatExitRMimir") and not son:IsPlayingMove("MOV_BoatExitLMimir") then
    local sonPupp = game.Puppeteer.NewForce(thisObj, "POI_ThamurAhead", son)
    sonPupp:StartMove("MOV_ThamurAhead")
    sonPupp:OnComplete(function()
      sonPupp = nil
    end)
  end
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("stn_ThamurAhead")
  end, 4)
  boolThamurAheadBanter = true
  thisObj:Hide()
end
