local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timers, monitors, thisLevel, player, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3
local timers_LoadLibrary = function()
  if timers == nil then
    timers = require("level.timer")
  end
end
local monitors_LoadLibrary = function()
  if monitors == nil then
    monitors = require("level.MonitorLibrary")
  end
end
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  Area_1_Fight_1()
  Area_1_Fight_2()
  Golem_Bonus()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  GameObjects.Helwalkers_Fog_entrance:Hide()
  if LD.GetEntityVariable("STN_IceGolemAlive") == true and (game.Level.GetVariable("CompletedCineNumber") > 365 and game.Level.GetVariable("CompletedCineNumber") <= 520 or game.Level.GetVariable("CompletedCineNumber") > 571) then
    Area_1_Encounter_2:Stop()
    Area_1_Encounter_2:DespawnEnemies()
    Area_1_Encounter_2:SetComplete()
    Area_1_Encounter_3:Start()
    LD.SetMarkerState("STN_200_AncientFight", 1)
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Stn100", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneStn100",
    AutoResetOnReload = true,
    StartMusic = "SND_MX_STN_hand_ext_fight_in",
    StopMusic = "SND_MX_STN_hand_ext_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    timeBetweenWaves = 1.5,
    {
      spawners = "Wulver_S_EATING",
      spawnLocators = "A1_Start_Loc_2",
      markerID = "Wulver_Intro",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Wulver_S_SFA",
      spawnLocators = "A1_W_Loc_3",
      useSpawnLocatorsOnly = true,
      markerID = "WallBreakOut_R",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.31,
      powerLevel = 3
    }
  })
  Area_1_Encounter_1:OnEnemySpawn(Health_Encounter, {
    markerID = "Wulver_Intro"
  })
  Area_1_Encounter_1:OnEnemySpawn(function(enemy)
    timers_LoadLibrary()
    timers.StartLevelTimer(1.263, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
    timers.StartLevelTimer(1.42, function()
      GameObjects.IceWall_R:PlayAnimToEnd()
      LD.PlaySound(GameObjects.IceWall_R.SoundEmitters[1], "SND_EVNT_Waterfront_Stone_Wall_Explo")
      game.Blender.Trigger({
        Name = "FSE_SHAKE_GENERIC_MEDIUM",
        Duration = 1.5,
        TweenIn = {Time = 0},
        TweenOut = {Time = 0.5},
        Priority = 2
      })
      game.Blender.Trigger({
        Name = "FFB_GENERIC_RUMBLE_STRONG",
        Duration = 0.5,
        TweenIn = {Time = 0},
        TweenOut = {Time = 0.5},
        Priority = 2
      })
    end)
    GameObjects.EnvironmentEventEmitter_Stn100_Ambush.LuaObjectScript.Trigger()
  end, {
    markerID = "WallBreakOut_R"
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"))
  Area_1_Encounter_1:OnComplete(OnArea1EncounterDone)
  monitors_LoadLibrary()
  local ZM_A1_E1_Attack = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Attack"))
  ZM_A1_E1_Attack:OnEnter(function()
    local dragurIntro1 = LD.FindSingleAIByMarker("Wulver_Intro")
    if dragurIntro1 ~= nil then
      dragurIntro1:TriggerMoveEvent("LE_WulverSpawnEatingAggro")
    end
    Area_1_Encounter_1:AlertEnemies()
    ZM_A1_E1_Attack:Stop()
    ZM_A1_E1_Attack = nil
  end)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Stn100 Encounter Repopulation", {
    AutoResetOnReload = true,
    LeashZone = "LeashZoneStn100",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:1 Stn100"
    }
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Bandit_SFG",
      spawnLocators = "A1_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.51,
      powerLevel = 6
    }
  })
  Area_1_Encounter_2:AddWave({
    powerLevel = 7,
    {
      spawners = "Bandit_SFG",
      spawnLocators = "A1_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15.11
    },
    {
      spawners = "Wulver_S_SFA",
      spawnLocators = "A1_U_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    },
    {
      spawners = "Wulver_S_SFA",
      spawnLocators = "A1_U_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_2:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Return"), {
    cineRequirement = {375, 9999}
  })
end
function Golem_Bonus()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Stn100 Golem Repopulation", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneStn100",
    AutoResetOnReload = true
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Golem_I_SFG",
      spawnLocators = "A1_Loc_17",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.51
    }
  })
  Area_1_Encounter_3:OnComplete(function()
    LD.SetEntityVariable("STN_IceGolemAlive", false)
    LD.SetMarkerState("STN_200_AncientFight", 0)
  end)
end
function Health_Encounter(Enemy)
  if Enemy ~= nil then
    monitors_LoadLibrary()
    local enemyHealth = Enemy:MeterGetValue("Health")
    local Phase_1 = enemyHealth * 0.65
    local Phase_2 = enemyHealth * 0.1
    monitors.CreateHealthMonitor(Enemy):OnHealthLessThan(Phase_1, function()
      Area_1_Encounter_1:StartWave(2)
    end)
  end
end
function OnArea1EncounterDone()
  timers_LoadLibrary()
  timers.StartLevelTimer(2, function()
    game.Audio.PlayBanter("stn_ChiselGoal")
  end)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Speed")
  local stn100 = game.FindLevel("Stn100_Entrance")
  if stn100 ~= nil then
    stn100:CallScript("EnableCARingShot")
  end
  GameObjects.ca_observe_on_alert_Stn100_Start.LuaObjectScript.Disable()
end
