local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local LM = require("level.loadmonitor")
local player, bVibrateActivated, RightHandRing, bInteractedCrank
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
local IciclesGroup00, IciclesGroup01, IciclesGroup02, tempPlayed
local returnSetupCompleted = false
local son, bReturnChiselNavDone
local IciclesDown = 0
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  RightHandRing = level:GetGameObject("RingFallAnim")
  SoundOnInit()
  IciclesGroup00 = GameObjects.stn100_icicle_ring_000:FindSingleGOByName("IciclesGroup01")
  IciclesGroup01 = GameObjects.stn100_icicle_ring_001:FindSingleGOByName("IciclesGroup01")
  IciclesGroup02 = GameObjects.stn100_icicle_ring_002:FindSingleGOByName("IciclesGroup02")
  IciclesGroup00:HideParticles()
  IciclesGroup01:HideParticles()
  IciclesGroup02:HideParticles()
end
function OnFirstStart(level)
  GameObjects.PlaytestEnd_TextUI:Hide()
  GameObjects.Stn100_Dock1.LuaObjectScript.HasDiscoveredDock()
end
function OnStart(level)
  GameObjects.LoadZone_BeforeDoor_Scripted:HideEntityVolume()
  GameObjects.LoadZone_AfterDoor_Scripted:HideEntityVolume()
  if LD.GetEntityVariable("STN_ReturnToWad150") == true and not returnSetupCompleted then
    GameObjects.PatrolSpawnZone:HideEntityVolume()
    returnSetupCompleted = true
  end
  if game.Level.GetVariable("CompletedCineNumber") == 360 then
    son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
    if not bReturnChiselNavDone then
      NavSetupReturn()
    end
  end
  SoundOnStart()
  GameObjects.CA_Observe_Forward_FaceRing_Stn100.LuaObjectScript.Disable()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    returnSetupCompleted = returnSetupCompleted,
    bReturnChiselNavDone = bReturnChiselNavDone,
    IciclesDown = IciclesDown
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  returnSetupCompleted = savedInfo.returnSetupCompleted
  bReturnChiselNavDone = savedInfo.bReturnChiselNavDone
  IciclesDown = savedInfo.IciclesDown or 0
end
function Stn100_Bookmark_GotoStateAfterPuzzle()
  RightHandRing:JumpAnimToPercent(1)
  GameObjects.IciclesGroup01:JumpAnimToPercent(1)
  GameObjects.IciclesGroup02:JumpAnimToPercent(1)
  GameObjects.IceWall_R:JumpAnimToPercent(1)
  GameObjects.IC_exit:HideCollision()
  GameObjects.IC_Loot:HideCollision()
  GameObjects.coffin_parent_0.Child.LuaObjectScript:Enable()
end
function Stn100_Bookmark_Return2Caldera()
  GameObjects.Quest_Logic:HideEntityVolume()
end
function Stn100_Bookmark_ArriveAtDock()
end
function OnUpdate(level)
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_Ring_RightSide") then
    if player:HasMarker("CrankAtEnd") then
      game.Camera.SubmitCameraByName("PLYR_SidewaysCrank_CrankAtEndRight")
    end
  elseif game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_Ring_LeftSide") and player:HasMarker("CrankAtStart") then
    game.Camera.SubmitCameraByName("PLYR_SidewaysCrank_CrankAtStartLeft")
  end
end
function DockSyncExit()
  GameObjects.LTW_Stn100_MainPath_Lead.LuaObjectScript.Enable()
  GameObjects.CA_syncexithelper_Dock.LuaObjectScript.Enable()
end
function AreaAnnounce_Stn100_Enter()
  uiCalls.UI_Event_DiscoverLocation("Nj\195\182rdholm Dock")
  LD.SetRegionDiscovered("Stonemason")
  local Cal275Monitor = LM.CreateLoadMonitor()
  Cal275Monitor:AddCallback({
    Wads = {
      "Cal275_StonemasonLH"
    },
    Functions = {
      ToggleBoatZones_inCal275
    }
  })
end
function ToggleBoatZones_inCal275(wads)
  LD.CallFunctionAfterDelay(function()
    wads.Cal275_StonemasonLH:CallScript("ToggleBoatZones")
  end, 0.05)
end
function CA_RingCrystalCallout()
  timer.StartLevelTimer(5, function()
    if not bVibrateActivated then
      GameObjects.Btr_BeachCrystal.LuaObjectScript.RingCrystalCallout()
    end
  end)
end
function RingCrystalTurretCA_Enable()
  if IciclesDown < 2 then
    GameObjects.CA_Observe_Forward_FaceRing_Stn100.LuaObjectScript.Enable()
  end
end
function RingCrystalTurretCA_Disable()
  GameObjects.CA_Observe_Forward_FaceRing_Stn100.LuaObjectScript.Interrupt()
  GameObjects.CA_Observe_Forward_FaceRing_Stn100.LuaObjectScript.Disable()
  if 2 <= IciclesDown then
    GameObjects.EZ_ToggleRingTurret:HideEntityVolume()
  end
end
function NavSetupReturn()
  GameObjects.CA_Observe_Forward_Stn100_ChiselDoor.LuaObjectScript.Enable()
  GameObjects.CA_ObserveFar_Forward_Stn100_Docks.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Stn100_ChiselDoor.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_FaceRing_Stn100.LuaObjectScript.Disable()
  GameObjects.CA_Point_Forward_Stn100_IcicleChest.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_Stn100_VibrateRing.LuaObjectScript.Disable()
  GameObjects.CA_WarmHands_Stn100_Torch.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Stn100_MonsterCloset.LuaObjectScript.Disable()
  GameObjects.LTW_Stn100_EnterUnderHand.LuaObjectScript.Disable()
  GameObjects.LTW_Stn100_MainPath_Lead.LuaObjectScript.Disable()
  GameObjects.EZ_ToggleRingTurret:HideEntityVolume()
  if not bReturnChiselNavDone then
    GameObjects.LTW_Stn100_ReturnToChisel.LuaObjectScript.Enable()
    GameObjects.CA_Point_Forward_Stn100_ReturnChisel.LuaObjectScript.Enable()
  end
end
function ChiselDoorNavReEnable()
  if game.Level.GetVariable("CompletedCineNumber") == 360 and not bReturnChiselNavDone then
    GameObjects.CA_Point_Forward_Stn100_ReturnChisel.LuaObjectScript.Enable()
    GameObjects.LTW_Stn100_ReturnToChisel.LuaObjectScript.Enable()
  end
end
function ChiselDoorNavDone()
  GameObjects.CA_Point_Forward_Stn100_ReturnChisel.LuaObjectScript.Disable()
  GameObjects.LTW_Stn100_ReturnToChisel.LuaObjectScript.Disable()
end
function DisableStartNav()
  bReturnChiselNavDone = true
  GameObjects.CA_ObserveFar_Forward_Stn100_Docks.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Stn100_ChiselDoor.LuaObjectScript.Disable()
  GameObjects.CA_Point_Forward_Stn100_IcicleChest.LuaObjectScript.Disable()
  GameObjects.CA_WarmHands_Stn100_Torch.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Stn100_MonsterCloset.LuaObjectScript.Disable()
  GameObjects.LTW_Stn100_EnterUnderHand.LuaObjectScript.Disable()
  GameObjects.LTW_Stn100_MainPath_Lead.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_Stn100_VibrateRing.LuaObjectScript.Disable()
end
function ReEnableStartNav()
  GameObjects.CA_Point_Forward_Stn100_IcicleChest.LuaObjectScript.Enable()
  GameObjects.CA_WarmHands_Stn100_Torch.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Up_Stn100_MonsterCloset.LuaObjectScript.Enable()
  GameObjects.LTW_Stn100_EnterUnderHand.LuaObjectScript.Enable()
  GameObjects.LTW_Stn100_MainPath_Lead.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_Stn100_VibrateRing.LuaObjectScript.Enable()
  GameObjects.EZ_ToggleRingTurret:ShowEntityVolume()
end
function EnterChiselSite()
  GameObjects.LoadZone_AfterDoor_Scripted:ShowEntityVolume()
  GameObjects.LoadZone_BeforeDoor_Scripted:HideEntityVolume()
end
function ExitChiselSite()
  GameObjects.LoadZone_BeforeDoor_Scripted:ShowEntityVolume()
  GameObjects.LoadZone_AfterDoor_Scripted:HideEntityVolume()
end
function LoadCheck_Stn100_Stn105()
  game.UI.LoadCheck("Stn105_ChiselSite")
end
function LoadCheck_Stn105_Stn100()
  game.UI.LoadCheck("Stn100_Entrance", "Stn090_LakeVista")
end
function EnableChiselMarker()
  LD.SetMarkerState("SM_100_ChiselEntrance", 1)
  LD.UpdateMap("SM_100_ChiselEntrance", 0)
  ChiselQuest()
end
function DisableChiselMarker()
  LD.SetMarkerState("SM_100_ChiselEntrance", 0)
end
function ChiselQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Find_SM")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Find_SM")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Find", 1)
  end
end
local SNDRingFall, SNDRingRotate, SNDWallLeft, SNDWallRight
local ringSoundEvents = {
  OnHit = "SND_EVNT_Stone_Mason_Ring_Dislodge_Hit_By_Arrow",
  OnFall = "SND_EVNT_Stone_Mason_Ring_Dislodge_Hit_Ground",
  OnWallBreak = "SND_EVNT_Stone_Mason_Ring_Wall_Explo",
  OnFallFrame = 11
}
local ringCrankOverrides = {
  OnForward = "SND_EVNT_Stone_Mason_Ring_Rotate_LP",
  OnBackward = "SND_EVNT_Stone_Mason_Ring_Rotate_LP"
}
function SoundOnInit()
  SNDRingFall = GameObjects.RingFallAnim:FindSingleSoundEmitterByName("SNDRingFall")
  SNDWallLeft = GameObjects.SNDWallEmitters:FindSingleSoundEmitterByName("SNDIceWallLeftStn100")
  SNDWallRight = GameObjects.SNDWallEmitters:FindSingleSoundEmitterByName("SNDIceWallRightStn100")
end
function SoundOnStart()
  GameObjects.StraightCrankHandleSidewaysOfficial.LuaObjectScript.DrivenObjectSoundSetup(ringCrankOverrides)
end
function PlayRingFallSound()
  LD.PlaySound(SNDRingFall, ringSoundEvents.OnHit)
  LD.PlaySoundOnFrame(SNDRingFall, RightHandRing, ringSoundEvents.OnFall, ringSoundEvents.OnFallFrame, "forward")
end
function PlayWallLeftSound()
  LD.PlaySound(SNDWallLeft, ringSoundEvents.OnWallBreak)
end
function PlayWallRightSound()
  LD.PlaySound(SNDWallRight, ringSoundEvents.OnWallBreak)
end
function EnableCARingShot()
  GameObjects.CA_Observe_Forward_FaceRing_Stn100.LuaObjectScript.Enable()
end
function ShakeRumble()
  game.FX.SubmitEffect(camShakeLarge)
end
function BreakIceWall_R()
  GameObjects.IceWall_R:PlayAnimToEnd()
  local fseImpactShake = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 0.15
  }
  game.FX.SubmitEffect(fseImpactShake)
end
function InteractedCrank()
  bInteractedCrank = true
end
function Ring_0_VibrateIsOn()
  bVibrateActivated = true
  game.FX.SubmitEffect(camShakeLarge)
  if RightHandRing.AnimFrame == 0 then
    GameObjects.EEE_RingVibrateCrystal.LuaObjectScript.Trigger()
    IciclesGroup00:ShowParticles()
    IciclesGroup00:PlayAnimToEnd()
    GameObjects.RingFallAnim:PlayAnimToEnd()
    GameObjects.StraightCrankHandleSidewaysOfficial.LuaObjectScript.Enable()
    PlayRingFallSound()
    timer.StartLevelTimer(5, function()
      if not bInteractedCrank then
        GameObjects.Btr_BeachCrystal.LuaObjectScript.CrankNotTouched()
      end
    end)
    timer.StartLevelTimer(0.5, ShakeRumble)
    GameObjects.Btr_BeachCrystal.LuaObjectScript.RingShot1()
  end
  if GameObjects.RingRotateAnim.AnimFrame <= 30 then
    IciclesDown = IciclesDown + 1
    IciclesGroup02:ShowParticles()
    IciclesGroup02:PlayAnimToEnd()
    GameObjects.IC_exit:HideCollision()
    GameObjects.LTW_Stn100_EnterUnderHand.LuaObjectScript:Enable()
    GameObjects.LTW_Stn100_MainPath_Lead.LuaObjectScript:Disable()
    GameObjects.Btr_BeachCrystal.LuaObjectScript.IciclesBroken()
    PlayWallLeftSound()
  elseif GameObjects.RingRotateAnim.AnimFrame >= 70 then
    IciclesDown = IciclesDown + 1
    IciclesGroup01:ShowParticles()
    IciclesGroup01:PlayAnimToEnd()
    GameObjects.coffin_parent_0.LuaObjectScript:Enable()
    GameObjects.IC_Loot:HideCollision()
    GameObjects.Btr_BeachCrystal.LuaObjectScript.IciclesBroken()
    PlayWallRightSound()
  end
end
function RotateRing()
  GameObjects.RingRotateAnim:PlayAnimToEnd()
  GameObjects.NavObstacle_DeadZone4VibrateArrow:PlayAnimToEnd()
end
function StartQuest_LocateChisel()
  LD.CompleteQuest("Quest_PeaksPass_Objective743")
end
function Quest_StoneMason_Objective700_Complete()
  LD.CompleteQuest("Quest_StoneMason_Objective700")
end
