local LD = require("design.LevelDesignLibrary")
uiCalls = require("ui.uicalls")
local thisLevel, player, stn110, ChiselElevator, ElevatorManager, pad
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  SoundInit()
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
end
function OnStart(level)
  SoundOnStart()
end
function LoadCheck_StnOutsideWads()
  game.UI.LoadCheck("Stn100_Entrance")
end
function LoadCheck_Stn110()
  game.UI.LoadCheck("Stn110_ChiselArena")
end
function ClearSlowWalk()
  player:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Stonemason Chisel Dungeon")
  ChiselLabor()
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_SM")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_SM")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
function LTW_Stn105_Enable()
  GameObjects.LTW_Stn105.LuaObjectScript.Enable()
end
function LTW_Stn105_Disable()
  GameObjects.LTW_Stn105.LuaObjectScript.Disable()
end
function Stn110_LTW_Enable()
  local Stn110 = game.FindLevel("Stn110_ChiselArena")
  if Stn110 ~= nil then
    Stn110:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
function Stn110_LTW_Disable()
  local Stn110 = game.FindLevel("Stn110_ChiselArena")
  if Stn110 ~= nil then
    Stn110:CallScript("LTW_Lobby_Disable", "CA_Lobby_Disable")
  end
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
end
