local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local DungeonEncounters = require("boss.statemachine")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local thisLevel, player
local DE_Phase_1 = DungeonEncounters:AddStage("Intro_Phase_1", true)
local DE_Phase_2 = DungeonEncounters:AddStage("Reinforcements_Phase_2", true)
local DE_Phase_3 = DungeonEncounters:AddStage("Laststand_Phase_3", true)
Encounter_1 = nil
local Enc_DraugrChallenge_Fight
local KillCount = 100
local DraugrChallenge_KillCount = KillCount
local enc_Valkyrie_Fight_01
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  Fnc_Valkyrie_Fight()
end
function OnFirstStart(level, obj)
end
function OnStart(level, obj)
  GameObjects.StartEncounterZone:Hide()
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function Fnc_Valkyrie_Fight()
  enc_Valkyrie_Fight_01 = EC.NewEncounter(thisLevel, "[Chisel Arena]EC: Valkyrie Fight", {
    CheckpointOnComplete = false,
    spawnWad = "Stn110_ChiselArena",
    LeashZone = "LshZn_Stn110_Valk"
  })
  enc_Valkyrie_Fight_01:AddWave({
    {
      spawners = "Valkyrie00_Slugger_SFA",
      markerID = "Valkyrie_Stn110",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  enc_Valkyrie_Fight_01:OnComplete(function()
    _G.SetEncounterComplete()
    _G.CA_Arena_Enable()
    _G.LTW_Lobby_Enable()
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
  end)
  enc_Valkyrie_Fight_01:SetStartZone(GameObjects.EntZn_Start_ValkyrieFight)
  enc_Valkyrie_Fight_01:SetAlertZone(GameObjects.EntZn_Alert_ValkyrieFight)
end
