local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
checkpoint = require("level.checkpoint")
local thisLevel, player, son
local encounterComplete = false
local sonWarpTriggered = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Alert_ValkyrieFight:Hide()
end
function OnStart(level)
  GameObjects.primarydoor_animated_inner.Child:JumpAnimationToFrame(60)
  GameObjects.primarydoor_animated_inner.Child:HideCollision()
  GameObjects.primarydoor_animated_outer.Child:JumpAnimationToFrame(60)
  GameObjects.primarydoor_animated_outer.Child:HideCollision()
  GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelInteract()
  player:ClearMaxSpeedOverride()
end
function LoadCheck_StnLHWads()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 570 then
    game.UI.LoadCheck("Stn105_ChiselSite")
  elseif 570 <= cineNum then
    game.UI.LoadCheck("Stn905_ChiselSite")
  end
end
function OnEvaluateLoadGroup_StnWads()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 570 <= cineNum then
    return "PostFinalBoss"
  else
    return "PreFinalBoss"
  end
end
function FT_JumpElevator()
  local Stn105 = game.FindLevel("Stn105_ChiselSite")
  local Stn905 = game.FindLevel("Stn905_ChiselSite")
  if Stn105 ~= nil then
    Stn105:CallScript("JumpElevator")
  elseif Stn905 ~= nil then
    Stn905:CallScript("JumpElevator")
  end
end
function SetEncounterComplete()
  encounterComplete = true
end
function LTW_Lobby_Enable()
  if encounterComplete == false then
    GameObjects.LTW_Lobby_In.LuaObjectScript.Enable()
  elseif encounterComplete == true then
    GameObjects.LTW_Lobby_Out.LuaObjectScript.Enable()
    GameObjects.LTW_Lobby_In.LuaObjectScript.Disable()
    GameObjects.LTW_Balcony_R_Down.LuaObjectScript.Enable()
    GameObjects.LTW_Balcony_L_Down.LuaObjectScript.Enable()
  end
end
function LTW_Lobby_Disable()
  if encounterComplete == true then
    GameObjects.LTW_Lobby_In.LuaObjectScript.Disable()
  end
  GameObjects.LTW_Balcony_R_Down.LuaObjectScript.Disable()
  GameObjects.LTW_Balcony_L_Down.LuaObjectScript.Disable()
  GameObjects.LTW_Lobby_Out.LuaObjectScript.Disable()
end
function CA_Lobby_Enable()
  if encounterComplete == false then
    GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Enable()
  elseif encounterComplete == true then
    GameObjects.CA_IdleBehavior_Lobby.LuaObjectScript.Enable()
    GameObjects.CA_Puzzled_Lobby.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Lobby.LuaObjectScript.Enable()
  end
end
function CA_Lobby_Disable()
  GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Lobby.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_Lobby.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Lobby.LuaObjectScript.Disable()
  GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Disable()
end
function CA_Balcony_Enable()
  if encounterComplete == true then
    GameObjects.CA_Observe_Forward_Up_Balcony.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_Balcony.LuaObjectScript.Enable()
  end
end
function CA_Balcony_Disable()
  if encounterComplete == true then
    GameObjects.CA_Observe_Forward_Up_Balcony.LuaObjectScript.Disable()
    GameObjects.CA_IdleBehavior_Balcony.LuaObjectScript.Disable()
  end
end
function CA_SonHoldPosition_Enable()
  if encounterComplete == false then
    GameObjects.CA_ObserveFar_Forward_Lobby.LuaObjectScript.Enable()
    GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Interrupt()
    GameObjects.CA_Observe_On_Alert_ArenaEntrance.LuaObjectScript.Disable()
  end
end
function CA_SonHoldPosition_Disable()
  GameObjects.CA_ObserveFar_Forward_Lobby.LuaObjectScript.Interrupt()
  GameObjects.CA_ObserveFar_Forward_Lobby.LuaObjectScript.Disable()
end
function CA_ArenaOnAlert_Enable()
  if encounterComplete == false then
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Enable()
  end
end
function CA_ArenaOnAlert_Disable()
  GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
end
function CA_Arena_Enable()
  if encounterComplete == true then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_PlayWithKnife_Arena.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_Arena.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Arena_01.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Arena_02.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Arena_03.LuaObjectScript.Enable()
  end
end
function CA_Arena_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.CA_PlayWithKnife_Arena.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Arena.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Arena_01.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Arena_02.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Arena_03.LuaObjectScript.Disable()
end
function CloseArenaDoors()
  if sonWarpTriggered == false then
    sonWarpTriggered = true
    GameObjects.SonWarpSafe.LuaObjectScript.WarpSon()
  end
  GameObjects.primarydoor_animated_inner.Child:PlayAnimToEnd(-1)
  GameObjects.primarydoor_animated_inner.Child:ShowCollision()
  GameObjects.primarydoor_animated_outer.Child:PlayAnimToEnd(-1)
  GameObjects.primarydoor_animated_outer.Child:ShowCollision()
end
function UnlockArena()
  timers.StartLevelTimer(1.5, function()
    GameObjects.primarydoor_animated_inner.Child:PlayAnimToEnd()
    GameObjects.primarydoor_animated_inner.Child:OnAnimDone(thisLevel, "HideInnerDoorCollision")
    GameObjects.primarydoor_animated_outer.Child:PlayAnimToEnd()
    GameObjects.primarydoor_animated_outer.Child:OnAnimDone(thisLevel, "HideOuterDoorCollision")
  end)
end
function HideInnerDoorCollision()
  GameObjects.primarydoor_animated_inner.Child:HideCollision()
end
function HideOuterDoorCollision()
  GameObjects.primarydoor_animated_outer.Child:HideCollision()
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save(),
    encounterComplete = encounterComplete,
    sonWarpTriggered = sonWarpTriggered
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  encounterComplete = savedInfo.encounterComplete
  sonWarpTriggered = savedInfo.sonWarpTriggered
end
