local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, player
ZM_A1_E1_Attack = nil
ZM_A1_E2_Attack = nil
ZM_A2_E1_Attack = nil
local Area_1_Encounter_1, Area_2_Encounter_1
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
end
function OnStart(level, obj)
  GameObjects.Stn150Combat_ContinueZone:HideEntityVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 150", {
    CheckpointOnComplete = true,
    spawnWad = "Stn100_Entrance"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_PT_SUSL",
      spawnLocators = "A1_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    },
    {
      spawners = "Draugr_PT_SUSL",
      spawnLocators = "A2_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DW_Draugr_N_SSA",
      spawnLocators = "A1_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"))
  Area_1_Encounter_1:OnStart(function()
    Area_1_Encounter_1:StartWave(2)
  end)
  ZM_A1_E1_Attack = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Attack"))
  ZM_A1_E1_Attack:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies(1)
  end)
  ZM_A1_E2_Attack = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_1_Attack_2"))
  ZM_A1_E2_Attack:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies(2)
  end)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 150", {
    CheckpointOnComplete = true,
    spawnWad = "Stn100_Entrance"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A2_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Spawn"))
  ZM_A2_E1_Attack = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_2_Attack"))
  ZM_A2_E1_Attack:OnEnter(function()
    Area_2_Encounter_1:AlertEnemies()
  end)
end
