local LD = require("design.LevelDesignLibrary")
monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local uiCalls = require("ui.uicalls")
player = nil
thisLevel = nil
CollapseZoneMonitor = nil
local returnedTo150, draugrInvestigate, firstVistDone
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  thisLevel = level
end
function OnStart(level)
  CollapseZoneMonitor = monitors.CreateEntityZoneMonitor(player, GameObjects.platform_collapse_zone)
  CollapseZoneMonitor:SetTriggerCountLimit(1)
  CollapseZoneMonitor:OnEnter(collapse)
  CheckLoadingZones()
  SoundInit()
  if game.Wallets.HasResource("HERO", "ChiselUnlock") then
    game.Compass.SetGatewayMarkerIsOpen("SM_150_Helper", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("SM_150_Helper", false)
  end
end
function CheckLoadingZones()
  if LD.GetEntityVariable("STN_ReturnToWad150") == true then
    GameObjects.dummy_1:HideEntityVolume()
    GameObjects.dummy_2:ShowEntityVolume()
    GameObjects.Chain_7M_Exit2Lake:PlayAnimToEnd()
  end
  if LD.GetEntityVariable("STN_ReturnToWad150") == false then
    GameObjects.dummy_2:HideEntityVolume()
    GameObjects.dummy_1:ShowEntityVolume()
  end
end
function EZ_Stn150_LoadCheck_Stn100()
  game.UI.LoadCheck("Stn100_Entrance")
end
function collapse()
  GameObjects.platform_slight_break.Child:PlayAnimToEnd()
  PlaySoundOnPlatform("SND_BRK_Wood_Boulder_Deck_Collapse_Stone_Mason")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    firstVistDone = firstVistDone
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstVistDone = savedInfo.firstVistDone
end
function AreaAnnounce_Stn100_Return()
  if not returnedTo150 and LD.GetEntityVariable("STN_ReturnToWad150") == true then
    uiCalls.UI_Event_DiscoverLocation("Nj\195\182rdholm Dock")
    returnedTo150 = true
  end
end
function CA_Stn100_ChiselDoorNavReEnable()
  local stn100 = game.FindLevel("Stn100_Entrance")
  stn100:CallScript("ChiselDoorNavReEnable")
end
function DisableChiselDoorCA()
  GameObjects.CA_Observe_Forward_Stn150_ChiselDoor.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Stn150_Tapestry.LuaObjectScript.Disable()
end
function DisableLowerCA_Stn150()
  GameObjects.CA_Observe_Forward_Stn150_ChiselDoor.LuaObjectScript.Disable()
  GameObjects.CA_WarmHands_Stn150_Torch.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Stn150_Tapestry.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_Stn150_HandCeiling.LuaObjectScript.Disable()
  GameObjects.EZ_Stn150_EnableLowerCAs:ShowEntityVolume()
  GameObjects.EZ_Stn150_DisableLowerCAs:HideEntityVolume()
end
function EnableLowerCA_Stn150()
  GameObjects.CA_Observe_Forward_Stn150_ChiselDoor.LuaObjectScript.Enable()
  GameObjects.CA_WarmHands_Stn150_Torch.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Stn150_Tapestry.LuaObjectScript.Enable()
  GameObjects.CA_Point_Up_Stn150_HandCeiling.LuaObjectScript.Enable()
  GameObjects.EZ_Stn150_EnableLowerCAs:HideEntityVolume()
  GameObjects.EZ_Stn150_DisableLowerCAs:ShowEntityVolume()
end
function Set_DraugrInvestigate_true()
  draugrInvestigate = true
end
function Set_DraugrInvestigate_false()
  draugrInvestigate = false
  GameObjects.CA_Riv_Snap_At_Draugr_Stn150.LuaObjectScript.Disable()
end
function StoneDraugrBroken()
  if draugrInvestigate then
    GameObjects.Reaction_Threat_Low_Stn150_Draugr.LuaObjectScript.Trigger()
  end
  GameObjects.CA_Riv_Snap_At_Draugr_Stn150.LuaObjectScript.Disable()
  draugrInvestigate = false
end
function SyncExitRopeTop()
  GameObjects.CA_Observe_Forward_Up_RopeUp_Stn150_R.LuaObjectScript.Disable()
  GameObjects.CA_Riv_Snap_At_Draugr_Stn150.LuaObjectScript.Disable()
  if not firstVistDone then
    GameObjects.CA_NewEnvironment_Stn150_IceLake.LuaObjectScript.Enable()
    GameObjects.CA_Post_Up_UnsheathedApproach_Stn150_NewEnv.LuaObjectScript.Enable()
    firstVistDone = true
  else
    GameObjects.CA_idlebehavior_Stn150_RopeSyncExit.LuaObjectScript.Enable()
  end
end
function SyncExitRopeBottom()
  GameObjects.CA_NewEnvironment_Stn150_IceLake.LuaObjectScript.Disable()
  GameObjects.CA_Post_Up_UnsheathedApproach_Stn150_NewEnv.LuaObjectScript.Disable()
  GameObjects.CA_idlebehavior_Stn150_RopeSyncExit.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_RopeUp_Stn150_R.LuaObjectScript.Enable()
end
function LoadCheck_Stn100_Stn150()
  if game.Level.GetVariable("CompletedCineNumber") < 360 then
    game.UI.LoadCheck("Stn200_LakeExt")
  end
end
function LoadCheck_Stn150_Stn100()
  game.UI.LoadCheck("Stn090_LakeVista", "Stn100_Entrance")
end
local soundEmitter
function SoundInit()
  soundEmitter = GameObjects.platform_slight_break.Child:FindSingleSoundEmitterByName("SNDPlatformBreak")
end
function PlaySoundOnPlatform(sound)
  if soundEmitter ~= nil and sound ~= nil and sound ~= "" then
    soundEmitter:Start(sound)
  end
end
