local foundBase = false
local foundCrystal = false
local freedCrystal = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    foundBase = foundBase,
    foundCrystal = foundCrystal,
    freedCrystal = freedCrystal
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  foundBase = savedInfo.foundBase
  foundCrystal = savedInfo.foundCrystal
  freedCrystal = savedInfo.freedCrystal
end
function CanPlayBase()
  return not foundCrystal and not foundBase
end
function CanPlayBaseSeen()
  return foundCrystal and not freedCrystal and not foundBase
end
function FoundBase()
  foundBase = true
end
function CanPlayCrystal()
  return not foundBase and not foundCrystal
end
function CanPlayCrystalSeen()
  return foundBase and not foundCrystal
end
function FoundCrystal()
  foundCrystal = true
end
function CrystalFreed()
  freedCrystal = true
  game.Audio.PlayBanter("stn_SMCrystalAcquired")
end
