local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local player, thisLevel, Area_1_Encounter_1, Area_1_Encounter_2, Area_2_Encounter_1, Area_2_Encounter_2, Area_2_Encounter_3, Area_3_Encounter_1, Area_3_Encounter_2, Area_4_Encounter_1, ZM_A1E1_Attack, ZM_A2E1_Spawn, ZM_A2E1_Attack, ZM_A2E2_Spawn, ZM_A2E2_Attack, ZM_A3E2_Attack, Jotunn_HealthMonitor, Enemy_HealthMonitor
CrystalBanterActivate = false
function OnScriptLoaded(level, obj)
  player = game.Player:FindPlayer()
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  Area_1_Fight_1()
  Area_1_Fight_2()
  Area_2_Fight_1()
  Back_Area_3_Fight_2()
  Area_4_Fight_1()
end
function OnUpdate(level)
  if LD.GetEntityVariable("STN_AlfLightAcquired") == true then
    GameObjects.EntZn_Area_1_Attack:ShowEntityVolume()
  end
end
function BurstOpenWall()
  GameObjects.BurstSpawnGroup:PlayAnimToEnd()
end
function Enable_CrystalBanterActivate()
  CrystalBanterActivate = true
end
function Disable_CrystalBanterActivate()
  CrystalBanterActivate = false
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Golem Front of lake Stn200", {
    CheckpointOnComplete = true,
    AutoResetOnReload = true,
    LeashZone = "LshZn_Stn200_A2"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Golem_I_SFG",
      spawnLocators = "A2_O_Loc_2",
      markerID = "Golem",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = 4
    }
  })
  Area_1_Encounter_1:OnStart(function()
    LD.SetEntityVariable("STN_IceGolemAlive", true)
    GameObjects.EntZn_Area_3_Spawn:Hide()
  end)
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn)
  Area_1_Encounter_1:OnEnemySpawn(function(Enemy)
    Golem_Health_Monitor(Enemy)
  end, {markerID = "Golem"})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:SetComplete()
  end, {markerID = "Golem"})
  Area_1_Encounter_1:OnComplete(function()
    GameObjects.EntZn_Area_3_Spawn:Show()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_Ice")
    LD.SetEntityVariable("STN_IceGolemAlive", false)
  end)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Flyers Front of lake Stn200", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Stn200_A2"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A2_O_Loc_",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = 3
    }
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A2_O_Loc_",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = 3
    },
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A2_O_Loc_",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = 3
    }
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A2_O_Loc_",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = 3
    },
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A2_O_Loc_",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.5,
      powerLevel = 3
    }
  })
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Wulvers mid lake Stn200", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Stn200_A2"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Wulver_N_SFG",
      spawnLocators = "A1_Loc_2",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1,
      powerLevel = 3
    }
  })
  Area_2_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Wulver_S_SFA",
      spawnLocators = "A2_U_Loc_02",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.83,
      powerLevel = 3
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn)
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Speed")
  end)
  ZM_A2E1_Spawn = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_1_Attack)
  ZM_A2E1_Spawn:SetTriggerCountLimit(1)
  ZM_A2E1_Spawn:OnEnter(function()
    Area_2_Encounter_1:StartWave(2)
    Area_2_Encounter_1:AlertEnemies()
  end)
end
function Mid_Area_2_Fight_2()
  ZM_A2E2_Spawn = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_2_Spawn)
  ZM_A2E2_Spawn:SetTriggerCountLimit(1)
  ZM_A2E2_Spawn:OnEnter(function()
    Area_2_Encounter_2:Start()
    GameObjects.EntZn_Area_2_Attack:ShowEntityVolume()
  end)
  ZM_A2E2_Attack = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_2_Attack)
  ZM_A2E2_Attack:SetTriggerCountLimit(1)
  ZM_A2E2_Attack:OnEnter(function()
    Area_2_Encounter_2:AlertEnemies()
    Area_2_Encounter_2:StartWave()
  end)
  GameObjects.EntZn_Area_2_Attack:HideEntityVolume()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:2 Chest Ambush Stn200", {
    CheckpointOnComplete = false,
    spawnWad = "Stn250_c_AI"
  })
  Area_2_Encounter_2:AddWave({
    requireOnScreenSpawners = true,
    requireSpawnersInRange = {0, 10},
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A2_O_Loc_3",
      markerID = "WitchEnemy",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Area_2_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Draugr_E_SFG",
      spawnLocators = "A2_O_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.3
    }
  })
end
function Mid_Area_2_Fight_3()
  Area_2_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 2]EC:3 Crystal drop Stn200", {CheckpointOnComplete = false})
  Area_2_Encounter_3:AddWave({
    {
      spawners = "Flyer_I_SABU",
      spawnLocators = "A2_O_Loc_5",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyer_I_SABU",
      spawnLocators = "A2_O_Loc_8",
      spawnWad = "Stn220_LakeCombat",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.5
    }
  })
end
function Back_Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:1 Back end of lake Stn220", {
    CheckpointOnComplete = false,
    spawnWad = "Stn220_LakeCombat"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A3_O_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.8
    },
    {
      spawners = "Flyer_B_SABU",
      spawnLocators = "A3_O_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  Area_3_Encounter_1:OnEnemySpawn(function(enemy)
    enemy:ForceMove("BRA_SetDropHealthFlag_On")
  end)
end
function Back_Area_3_Fight_2()
  GameObjects.EntZn_Area_3_Attack:HideEntityVolume()
  ZM_A3E2_Attack = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_3_Attack)
  ZM_A3E2_Attack:SetTriggerCountLimit(1)
  ZM_A3E2_Attack:OnEnter(function()
    Area_3_Encounter_2:Start()
    if Area_3_Encounter_1:IsComplete() then
      Area_3_Encounter_2:StartWave(2)
    end
  end)
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 3]EC:2 End of lake Stn220", {
    CheckpointOnComplete = false,
    spawnWad = "Stn220_LakeCombat"
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Flyer_I_SABU",
      spawnLocators = "A3_O_Loc_9",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1
    },
    {
      spawners = "Flyer_I_SABU",
      spawnLocators = "A3_O_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1
    }
  })
end
function Start_Area_4_Fight_1()
  Area_4_Encounter_1:Start()
end
function Area_4_Fight_1()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 4]EC:1 Break Pillar Stn220", {
    CheckpointOnComplete = false,
    spawnWad = "Stn220_LakeCombat"
  })
  Area_4_Encounter_1:AddWave({
    powerLevel = 2,
    {
      spawners = "Flyer_I_SABF",
      spawnLocators = "A4_U_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.65
    },
    {
      spawners = "Flyer_I_SABF",
      spawnLocators = "A4_U_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.1
    },
    {
      spawners = "Flyer_I_SABF",
      spawnLocators = "A4_U_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.35
    }
  })
end
local Jotunn_A1EC_Next = function()
  Area_2_Encounter_1:StartWave()
end
function Jotunn_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Jotunn_Health = Enemy:GetHitPoints()
    Jotunn_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Golem_Phase_1 = Jotunn_Health * 0.553
    Jotunn_HealthMonitor:OnHealthLessThan(Golem_Phase_1, Jotunn_A1EC_Next)
  end
end
function Golem_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:MeterGetValue("Health")
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.75
    local Health_Phase_2 = EnemyHealth * 0.45
    local Health_Phase_3 = EnemyHealth * 0.15
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_1_Encounter_2:Start()
    end)
  end
end
function Check_Lake_Combat()
  local fight_Complete = true
  if Area_1_Encounter_1:IsRunning() or Area_2_Encounter_1:IsRunning() then
    fight_Complete = false
  end
  return fight_Complete
end
