local ND = require("design.NarrativeDesignLibrary")
local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, cineSeq
local sawSindri = false
local kraActor, sonActor, sindActor, sindAppleObj, sonAppleObj, hammerObj, cineLightsObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  InitProps()
  if game.Level.GetVariable("CompletedCineNumber") < 350 then
    CreateActors()
    SpawnSindri()
  end
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    LevelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function InitProps()
  sindAppleObj = GameObjects.SindriApple.Child
  sonAppleObj = GameObjects.SonApple.Child
  hammerObj = GameObjects.hammerProp.Child
  cineLightsObj = GameObjects.Cine_Start_350
  HideProps()
end
function CreateActors()
  kraActor = actor.Actor.New("SINDRI STONE MASON: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SINDRI STONE MASON: Son Actor", game.AI.FindSon)
  sindActor = actor.Actor.New("SINDRI STONE MASON: Sindri Actor")
end
function SpawnSindri()
  sindActor:SetSpawnFunction(function()
    local sindriCreature = ND.FindSindri()
    if sindriCreature == nil then
      sindriCreature = ND.SpawnAIAtJoint(thisLevel, "Cine_SindriStoneMason", "Sind_StartJoint", "CRT_Sindri00", "BRA_SindriSpottedIdle_Spawn", "sindri")
    end
    return sindriCreature
  end)
end
function HideProps()
  sindAppleObj:Hide()
  sonAppleObj:Hide()
  hammerObj:Hide()
  cineLightsObj:Hide()
end
function HideProps2()
  sindAppleObj:Hide()
  sonAppleObj:Hide()
  cineLightsObj:Hide()
end
function EnableSindriZone()
  GameObjects.PoiStart_SeeSindri:ShowEntityVolume()
end
function SindriSpotedPOISequence()
  local poiSeq = LD.CreateCineSequence(thisLevel, thisObj, "Sindri Spotted Sequnece")
  poiSeq:SpawnActorAndWait(sindActor)
  poiSeq:WaitSeconds(0.2)
  poiSeq:ActorSync(sindActor, {
    Branch = "BRA_SindriSpottedEnter",
    ReferenceJoint = "SindriSpotted_SynchJoint"
  })
  poiSeq:Do(EnableSindriZone)
  poiSeq:WaitForActorPlayingMove(sindActor, "MOV_SindriSpottedIdle")
  poiSeq:WaitForFunctionTrue(function()
    return sawSindri == true
  end)
  poiSeq:Do(function()
    sindActor:GetCreature():TriggerMoveEvent("LE_SindriSpottedExit")
  end)
  poiSeq:WaitForActorPlayingMove(sindActor, "MOV_SindriSpottedExit")
  poiSeq:WaitUntilActorAnimPastPercentage(sindActor, 0.4936719)
  poiSeq:Do(function()
    GameObjects.ChainDrop_Sindri_8M.LuaObjectScript.Enable()
  end)
  poiSeq:StopPuppetingActor(sindActor)
  poiSeq:Do(function()
    GameObjects.PoiStart_SeeSindri:HideEntityVolume()
  end)
  poiSeq:Do(Quest_StoneMason_Objective250)
  poiSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  poiSeq:StartSequence()
end
function Quest_StoneMason_Objective250()
  LD.CompleteQuest("Quest_StoneMason_Objective250")
  game.Compass.SetDesignerForcedHide(false)
end
function SindriSeen()
  sawSindri = true
  local stn250 = game.FindLevel("Stn250_BanditCamp")
  if stn250 ~= nil then
    stn250:CallScript("SindriSequenceStarted")
  end
end
function SindriStoneMasonCineSequence()
  if cineSeq == nil and game.Level.GetVariable("CompletedCineNumber") < 350 then
    cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Sindri Stone Mason Sequence")
    local sindriStoneMason_ActorTable = {
      {Actor = sonActor},
      {Actor = sindActor},
      {
        Obj = sindAppleObj,
        Anim = "narStnSindriStoneMason010Cine"
      },
      {
        Obj = sonAppleObj,
        Anim = "narStnSindriStoneMason010Cine"
      },
      {
        Obj = hammerObj,
        Anim = "narStnSindriStoneMason010Cine"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_STN_start_master")
    cineSeq:WaitForLoadCheck("stn290_SindriShop")
    cineSeq:SpawnActorAndWait(sindActor)
    cineSeq:WaitForActorPlayingMove(kraActor, "MOV_Rope_Vertical_Up_Exit")
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(function()
      cineSeq:MarkAbleToSkip()
    end)
    cineSeq:Do(HideZone)
    cineSeq:ActorSync(kraActor, {
      Slaves = sindriStoneMason_ActorTable,
      Branch = "BRA_SindriStoneMason",
      ReferenceJoint = "SindriStoneMason_SynchJoint"
    })
    cineSeq:Do(PlayBreakable)
    cineSeq:Do(ShowApples)
    cineSeq:Do(PlayCineLighting)
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:StopPuppetingActor(sindActor)
    cineSeq:Do(BranchSindriToTableIdle)
    cineSeq:Do(HideProps2)
    cineSeq:SetCompletedCineNumber(350)
    cineSeq:WaitForLoadCheck("Stn300_HuldraCamp")
    cineSeq:Do(CompleteStoneMason260)
    cineSeq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "14_Stonemason_030_SindriStoneMason"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    cineSeq:StartSequence()
  end
end
function CompleteStoneMason260()
  game.QuestManager.ProposeQuestState("Quest_StoneMason_Objective260", "Complete")
end
function HideZone()
  GameObjects.Cine_SindriStoneMason:HideEntityVolume()
end
function PlayBreakable()
  local breakableObj = GameObjects.sindri_axe_break.Child
  breakableObj:PlayAnimToEnd()
end
function PlayCineLighting()
  cineLightsObj:Show()
  cineLightsObj:JumpAnimToFrame(0)
  cineLightsObj:PlayAnimToEnd()
end
function ShowApples()
  sindAppleObj:Show()
  sonAppleObj:Show()
  hammerObj:Show()
end
function BranchSindriToTableIdle()
  GameObjects.SmallShop.LuaObjectScript.StartCounterRequest(sindActor:GetCreature())
end
