local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local timers = require("level.timer")
local thisObj, thisLevel, son, camOneShot_LakeVista_010, camOneShot_LakeVista_015, camOneShot_LakeVista_020, kraActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if camOneShot_LakeVista_010 ~= nil then
    camOneShot_LakeVista_010:Update()
  end
  if camOneShot_LakeVista_015 ~= nil then
    camOneShot_LakeVista_015:Update()
  end
  if camOneShot_LakeVista_020 ~= nil then
    camOneShot_LakeVista_020:Update()
  end
end
function MakeSonUnavailable()
  local availabilityState = {AvailableForSync = false, AvailableForCombat = false}
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function MakeSonAvailable()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
end
function BuildArenaIntroductionSeq()
  CreateActors()
  MakeSonUnavailable()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "Thalmur Head Intro - POI")
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:WaitForActorPlayingMove(kraActor, "MOV_Rope_Vertical_Up_Exit")
  seq:Do(CameraLakeVistaIntro)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_ThalmurHeadIntro",
    ReferenceJoint = "ThalmurHeadIntro_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare_on_back"
  })
  seq:ActorSync(kraActor, {
    Branch = "BRA_ThalmurHeadIntro",
    ReferenceJoint = "ThalmurHeadIntro_SynchJoint"
  })
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:Do(function()
    game.Audio.StartCheckpointedMusic("SND_MX_STN_lake_explore_in")
  end)
  seq:Do(MakeSonAvailable)
  seq:Do(Quest_StoneMason_Objective090_Complete)
  seq:StartSequence()
end
function CameraLakeVistaIntro()
  game.SubObject.Wake(thisObj)
  camOneShot_LakeVista_010 = CCOS.OneShotCamera.New("PLYR_NAR_Vista_MasonLake_010", 10)
  camOneShot_LakeVista_010:Start()
  timers.StartLevelTimer(3, function()
    camOneShot_LakeVista_015 = CCOS.OneShotCamera.New("PLYR_NAR_Vista_MasonLake_015", 10)
    camOneShot_LakeVista_015:Start()
  end)
  timers.StartLevelTimer(8, function()
    camOneShot_LakeVista_020 = CCOS.OneShotCamera.New("PLYR_NAR_Vista_MasonLake_020", 6)
    camOneShot_LakeVista_020:Start()
    camOneShot_LakeVista_020:SetCallback(DestroyOneShot_LakeVista)
  end)
end
function DestroyOneShot_LakeVista()
  camOneShot_LakeVista_010 = nil
  camOneShot_LakeVista_015 = nil
  camOneShot_LakeVista_020 = nil
  game.SubObject.Sleep(thisObj)
end
function Quest_StoneMason_Objective090_Complete()
  LD.CompleteQuest("Quest_StoneMason_Objective090")
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.CheckpointOverride_POISeeChiselEnd
  })
end
