local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local timers = require("level.timer")
local CCEC = require("camera.camera_cineentercamera")
local CSL = require("camera.shakelibrary")
local thisObj, thisLevel, player, sonActor, kraActor, pad
local boolSeenChisel = false
local cineEnterCamera_ChiselAppraoch000, cineEnterCamera_ChiselAppraoch005, cineEnterCamera_ChiselAppraoch010, cineEnterCamera_ChiselAppraoch020, seeChiselApproachSeqSetup
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player:FindPlayer()
  pad = player.Pad
end
function OnStart(level, obj)
end
function OnUpdate(level, obj)
  if cineEnterCamera_ChiselAppraoch000 ~= nil then
    cineEnterCamera_ChiselAppraoch000:Update()
  end
  if cineEnterCamera_ChiselAppraoch005 ~= nil then
    cineEnterCamera_ChiselAppraoch005:Update()
  end
  if cineEnterCamera_ChiselAppraoch020 ~= nil then
    cineEnterCamera_ChiselAppraoch020:Update()
  end
  if cineEnterCamera_ChiselAppraoch010 ~= nil then
    cineEnterCamera_ChiselAppraoch010:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.boolSeenChisel = boolSeenChisel
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolSeenChisel = savedInfo.boolSeenChisel
end
function SetupActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function SeeChiselApproachSeq()
  if boolSeenChisel == false then
    SetupActors()
    seeChiselApproachSeqSetup = LD.CreateCineSequence(thisLevel, thisObj, "SeeChiselApproachPOI")
    seeChiselApproachSeqSetup:WaitForActorPlayingMove(kraActor, "MOV_DebrisLift_Left")
    DisableKratosInput()
    seeChiselApproachSeqSetup:WaitUntilActorAnimPastPercentage(kraActor, 0.6)
    seeChiselApproachSeqSetup:Do(StartCineEnter_ChiselAppraoch000)
    seeChiselApproachSeqSetup:Do(function()
      LD.CallFunctionAfterDelay(StartCineEnter_ChiselAppraoch005, 1)
    end)
    seeChiselApproachSeqSetup:Do(function()
      LD.CallFunctionAfterDelay(StartCineEnter_ChiselAppraoch010, 3.4)
    end)
    seeChiselApproachSeqSetup:WaitUntilActorAnimPastPercentage(kraActor, 0.85)
    seeChiselApproachSeqSetup:Do(function()
      LD.CallFunctionAfterDelay(StartCineEnter_ChiselAppraoch020, 5)
    end)
    seeChiselApproachSeqSetup:WaitForLoadCheck("Stn200_LakeExt")
    seeChiselApproachSeqSetup:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_SeeChiselCine",
      ReferenceJoint = "SeeChisel_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.ArrivalRadius,
      strafe_distance = 1
    })
    seeChiselApproachSeqSetup:RequestCineModeAndWait(kraActor, thisObj)
    seeChiselApproachSeqSetup:ActorSync(kraActor, {
      Branch = "BRA_SeeChiselCine",
      ReferenceJoint = "SeeChisel_SynchJoint"
    })
    seeChiselApproachSeqSetup:WaitUntilActorAnimPastFrame(kraActor, 550)
    seeChiselApproachSeqSetup:WaitUntilActorAnimPastFrame(kraActor, 632)
    seeChiselApproachSeqSetup:WaitForLoadCheck("Stn250_BanditCamp")
    seeChiselApproachSeqSetup:Do(function()
      boolSeenChisel = true
    end)
    seeChiselApproachSeqSetup:Do(StartSurpriseFight)
    seeChiselApproachSeqSetup:Do(StartQuest_BreakIce)
    seeChiselApproachSeqSetup:WaitForAndCompleteCineMode(kraActor, thisObj)
    seeChiselApproachSeqSetup:StopPuppetingActor(kraActor)
    seeChiselApproachSeqSetup:StopPuppetingActor(sonActor)
    seeChiselApproachSeqSetup:StartSequence()
  end
end
function StartQuest_BreakIce()
  LD.CompleteQuest("Quest_StoneMason_Objective100")
end
function SonIdleSeeChisel()
  local seeChiselSonIdleSeq = LD.CreateCineSequence(thisLevel, thisObj, "SeeChisel_SonIdle")
  seeChiselSonIdleSeq:WaitForActorNotPlayingMove(sonActor, "MOV_DebrisLift_Left")
  seeChiselSonIdleSeq:ActorSync(sonActor, {
    Branch = "BRA_SeeChiselEnter",
    ReferenceJoint = "SeeChisel_SynchJoint"
  })
  seeChiselSonIdleSeq:StartSequence()
end
function StartSurpriseFight()
  local stn250 = game.FindLevel("Stn250_BanditCamp")
  timers.StartLevelTimer(0, function()
    CSL.PlayShake("FSE_SHAKE_GENERIC_GIANT", 2.5, 0, 0)
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 2},
      Priority = 2
    })
  end)
  if stn250 ~= nil then
    timers.StartLevelTimer(0, function()
      stn250:CallScript("StartSurpriseFight")
    end)
    timers.StartLevelTimer(2, function()
      EnableKratosInput()
    end)
  end
end
function DisableKratosInput()
  pad:DisableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickX)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickY)
end
function EnableKratosInput()
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
  pad:EnableGameButton(tweaks.ePad.kPadSquare)
  pad:EnableGameButton(tweaks.ePad.kPadTriangle)
  pad:EnableGameButton(tweaks.ePad.kPadCross)
  pad:EnableGameButton(tweaks.ePad.kPadL1)
  pad:EnableGameButton(tweaks.ePad.kPadL2)
  pad:EnableGameButton(tweaks.ePad.kPadL3)
  pad:EnableGameButton(tweaks.ePad.kPadR1)
  pad:EnableGameButton(tweaks.ePad.kPadR2)
  pad:EnableGameButton(tweaks.ePad.kPadR3)
  pad:EnableGameButton(tweaks.ePad.kPadRight)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickX)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickY)
end
function StartCineEnter_ChiselAppraoch000()
  cineEnterCamera_ChiselAppraoch000 = CCEC.CineEnterCamera.New("PLYR_Nar_ChiselApproach_000", 7)
  cineEnterCamera_ChiselAppraoch000:Start()
end
function StartCineEnter_ChiselAppraoch005()
  cineEnterCamera_ChiselAppraoch005 = CCEC.CineEnterCamera.New("PLYR_Nar_ChiselApproach_005", 6)
  cineEnterCamera_ChiselAppraoch005:Start()
end
function StartCineEnter_ChiselAppraoch010()
  cineEnterCamera_ChiselAppraoch010 = CCEC.CineEnterCamera.New("PLYR_Nar_ChiselApproach_010", 7)
  cineEnterCamera_ChiselAppraoch010:Start()
end
function StartCineEnter_ChiselAppraoch020()
  cineEnterCamera_ChiselAppraoch020 = CCEC.CineEnterCamera.New("PLYR_Nar_ChiselApproach_020", 12)
  cineEnterCamera_ChiselAppraoch020:SetCallback(DestroyCineEnter_ChiselAppraoch020)
  cineEnterCamera_ChiselAppraoch020:Start()
end
function DestroyCineEnter_ChiselAppraoch020()
  cineEnterCamera_ChiselAppraoch000 = nil
  cineEnterCamera_ChiselAppraoch005 = nil
  cineEnterCamera_ChiselAppraoch010 = nil
  cineEnterCamera_ChiselAppraoch020 = nil
  game.SubObject.Sleep(thisObj)
end
