local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisObj
local keyRunes = {}
local keys = {}
local runeSymbolNumbers = {
  25,
  22,
  34
}
local challengeComplete = false
local keysUsed = 0
local RuneCaveViewTrigger
local bInsideProxTrig = false
local bRuneCaveSolved, bRuneCaveCompleted
local bViewingRuneGate = false
local RuneCaveViewMonitor
function OnScriptLoaded(level, obj)
  thisObj = obj
  for i = 1, 3 do
    keys[i] = GameObjects["Spin_Base_0" .. tostring(i)]
    keyRunes[i] = obj:FindSingleGOByName("triplePuzzle_keyRune0" .. tostring(i))
  end
  game.SubObject.Sleep(thisObj)
  SoundInit()
end
function OnPreStart(level, obj)
  for i = 1, 3 do
    keyRunes[i].LuaObjectScript.SelectRune(runeSymbolNumbers[i])
  end
  if challengeComplete == false then
    for i = 1, 3 do
      keys[i].LuaObjectScript.RegisterOnRotateCallback(OnRotateCallback)
    end
    OnRotateCallback()
  end
end
function OnStart()
  if bRuneCaveSolved then
    RuneCaveViewMonitor = CreateLookAtMonitor(GameObjects.RuneCaveViewTrigger, ViewingRuneGate, NotViewingRuneGate)
    RuneCaveViewMonitor:Start()
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    challengeComplete = challengeComplete,
    keysUsed = keysUsed,
    bRuneCaveSolved = bRuneCaveSolved
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  challengeComplete = savedInfo.challengeComplete
  keysUsed = savedInfo.keysUsed
  bRuneCaveSolved = savedInfo.bRuneCaveSolved
end
function OnRotateCallback()
  local newKeysUsed = 0
  local baseSuccess = {}
  keysUsed = 0
  if challengeComplete == true then
    return
  end
  for i = 1, 3 do
    baseSuccess[1] = runeSymbolNumbers[i] == keys[1].LuaObjectScript.GetCurrentRune()
    baseSuccess[2] = runeSymbolNumbers[i] == keys[2].LuaObjectScript.GetCurrentRune()
    baseSuccess[3] = runeSymbolNumbers[i] == keys[3].LuaObjectScript.GetCurrentRune()
    if baseSuccess[1] or baseSuccess[2] or baseSuccess[3] then
      keyRunes[i].LuaObjectScript.Disable()
      newKeysUsed = newKeysUsed + 1
    else
      keyRunes[i].LuaObjectScript.Enable()
    end
  end
  if keysUsed ~= newKeysUsed then
    keysUsed = newKeysUsed
  end
  if keysUsed == 3 and challengeComplete == false then
    challengeComplete = true
    RuneGateSolved()
  end
end
function CreateLookAtMonitor(object, LookAt, LookAway)
  local lookAtMonitor = monitors.CreateLookAtMonitor(object:GetWorldPosition())
  lookAtMonitor:SetMinPercentFromScreenEdge(10)
  lookAtMonitor:OnLookAt(LookAt)
  lookAtMonitor:OnLookAway(LookAway)
  return lookAtMonitor
end
function RuneGateSolved()
  bRuneCaveSolved = true
  if RuneCaveViewMonitor == nil then
    RuneCaveViewMonitor = CreateLookAtMonitor(GameObjects.RuneCaveViewTrigger, ViewingRuneGate, NotViewingRuneGate)
    RuneCaveViewMonitor:Start()
    if RuneCaveViewMonitor:IsLookingAt() == true then
      ViewingRuneGate()
    end
  end
end
function RunCheck()
  if bRuneCaveSolved and bInsideProxTrig and bViewingRuneGate then
    bRuneCaveSolved = false
    OpenTripleCrawlGate()
  end
end
function ViewingRuneGate()
  bViewingRuneGate = true
  RunCheck()
end
function NotViewingRuneGate()
  bViewingRuneGate = false
end
function RuneCaveProxCheck_In()
  bInsideProxTrig = true
  RunCheck()
end
function RuneCaveProxCheck_Out()
  bInsideProxTrig = false
end
function OpenTripleCrawlGate()
  thisObj:PlayAnimToEnd()
  PlaySoundGateOpen()
  GameObjects.TraversePath_Crawl_01:ShowTraversePath()
  RuneCaveViewMonitor:Stop()
  RuneCaveViewMonitor:Terminate()
  RuneCaveViewMonitor = nil
  GameObjects.RuneCaveViewTrigger:HideEntityVolume()
end
local runicGateEmitter
local runicGateStartOpen = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up"
local runicGateOpenLP = "SND_DOOR_Metal_Lift_Gate_Forest_LP"
local runicGateHitEnd = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling"
function SoundInit()
  runicGateEmitter = thisObj.SoundEmitters[1]
end
function PlaySoundGateOpen()
  LD.PlaySound(runicGateEmitter, runicGateStartOpen)
  LD.PlaySound(runicGateEmitter, runicGateOpenLP)
  thisObj:OnAnimDone(thisObj, "PlaySoundGateFinishedOpening")
end
function PlaySoundGateFinishedOpening()
  LD.PlaySound(runicGateEmitter, runicGateHitEnd)
  LD.StopSound(runicGateEmitter, runicGateOpenLP)
end
local musicEvents = {isLooping = false, OnBroken = ""}
function MusicSetup(music)
  if music ~= nil then
    for key, value in pairs(musicEvents) do
      for newKey, newValue in pairs(music) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          musicEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(value))
    end
  end
end
function PlayMusicOnBroken()
  game.Audio.StartMusic(musicEvents.OnBroken)
end
