local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local thisLevel, player, son
local camEnteredVistaZone = false
local bPocketRiftStarted, BifrostCrystalSap
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player:FindPlayer()
  son = game.AI.FindSon()
  BifrostCrystalSap = GameObjects.CrystalAnim_1:FindSingleGOByName("CarryBifrostLight_Start").Child
end
function OnFirstStart(level)
  GameObjects.TraversePath_Crawl_01:HideTraversePath()
  GameObjects.braids_end_pose:Hide()
  GameObjects.DebrisLift_StoneMason:Hide()
  GameObjects.Spin_Spinner_03.LuaObjectScript.Disable()
  GameObjects.SpinBlocked_Col.LuaObjectScript.RegisterOnWeaponEmbed(FlipperBlocked)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    bPocketRiftStarted = bPocketRiftStarted
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bPocketRiftStarted = savedInfo.bPocketRiftStarted
end
function LoadCheck_Stn200_Stn150()
  game.UI.LoadCheck("Stn150_HandUnder")
end
function LoadCheck_Stn200_Stn250()
  game.UI.LoadCheck("Stn250_BanditCamp", "Stn290_SindriShop")
end
function LTW_Enable_ThamursFace()
  if not LD.GetEntityVariable("BanditCampCombatComplete") then
    GameObjects.LTW_Stn200_ToChiselUnderIce.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Stn200_POIsetup.LuaObjectScript.Enable()
    GameObjects.CA_SyncExitHelper_Stn200_ToChiselUnderIce.LuaObjectScript.Enable()
  end
end
function MakeSonUnavailable()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = true,
    AvailableInLevel = true,
    AvailableForCombat = true
  }
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function MakeSonAvailable()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function CheckDreadlocksStatus()
  GameObjects.braids_1:Hide()
  if LD.GetEntityVariable("STN_DreadlockSolved") == true then
    GameObjects.braids_end_pose:Show()
    local LM = require("level.loadmonitor")
    LM.CreateLoadMonitor():AddCallback({
      Wads = {
        "Stn300_HuldraCamp"
      },
      Functions = {
        function(wads)
          wads.Stn300_HuldraCamp:CallScript("HideRealDreadlocks")
        end
      }
    })
  end
end
function ShakeRumble()
  game.FX.SubmitEffect(camShakeLarge)
  game.FX.SubmitEffect(ForceFeedbackRumble)
end
function EnablePocketRiftStart()
  if not bPocketRiftStarted then
    bPocketRiftStarted = true
    GameObjects.LootPocketRift_1_A.LuaObjectScript.Enable()
    GameObjects.CA_KickBody_Stn200.LuaObjectScript.Enable()
  end
end
function PlayRootsAnim()
  GameObjects.SpinBlocked_Col:Hide()
  GameObjects.Roots_200_arch2.Child:PlayAnimToEnd()
  GameObjects.Spin_Spinner_03.LuaObjectScript.Enable()
end
function FlipperBlocked()
  GameObjects.SpinBlocked_Anim:JumpAnimToFrame(0)
  GameObjects.SpinBlocked_Anim:PlayAnimToEnd(0.5)
end
function BreakPlatform()
  GameObjects.CrystalAnim_1:PlayAnimToEnd(0.75)
  GameObjects.CrystalAnim_1:OnAnimDone(thisLevel, "CrystalDone")
  GameObjects.Btr_Stn200.LuaObjectScript.CrystalFreed()
end
function CrystalDone()
  BifrostCrystalSap.LuaObjectScript.EnableInteract()
end
function CrystalPickedUp()
  LD.SetEntityVariable("STN_AlfLightAcquired", true)
  GameObjects.CA_Observe_Forward_Up_Stn200_Bifrost1.LuaObjectScript.Interrupt()
  GameObjects.CA_Observe_Forward_Up_Stn200_Bifrost1.LuaObjectScript.Disable()
  GameObjects.CA_KickBody_Stn200.LuaObjectScript.Interrupt()
  GameObjects.CA_KickBody_Stn200.LuaObjectScript.Disable()
  GameObjects.CA_Stone_IceSlide_Stn200.LuaObjectScript.Enable()
  GameObjects.EntZn_Area_1_Attack:ShowEntityVolume()
  GameObjects.EntZn_Area_3_Attack:ShowEntityVolume()
end
function WarpSonBehindPlayer()
  son:Warp(player.WorldPosition - player:GetWorldForward() * 4, player:GetWorldForward())
end
function HideBifrostRune_CarryCrystal()
  GameObjects.Bifrost_RuneRead:Hide()
end
function ShowBifrostRune_CarryCrystal()
  GameObjects.Bifrost_RuneRead:Show()
end
function SpawnPillarLift()
  GameObjects.DebrisLift_StoneMason:Show()
  GameObjects.DebrisLift_StoneMason:ShowCollision()
  GameObjects.DebrisLift_StoneMason.LuaObjectScript.Enable()
end
function SetupChiselPOI()
  GameObjects.POI_SeeChisel_Group.LuaObjectScript.SeeChiselApproachSeq()
  game.SubmitActivityFeedStory("07_StonemasonArrival")
end
