local checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local son, firstVisit
local musFirstTime = false
function OnScriptLoaded()
  son = game.AI.FindSon()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    firstVisit = firstVisit,
    musFirstTime = musFirstTime
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstVisit = savedInfo.firstVisit
  musFirstTime = savedInfo.musFirstTime
end
function LoadCheck_Stn150_Stn800()
  game.UI.LoadCheck("Stn800_Shortcut")
end
function LoadCheck_Stn800_Stn150()
  game.UI.LoadCheck("Stn150_HandUnder")
end
function LockDoor_Stn430()
  GameObjects.SpreadDoor_Stn430.LuaObjectScript.Lock()
end
function LockDoor_ChiselDoor()
  GameObjects.ChiselDoor_Stn150_Stn800.LuaObjectScript.LockDoor()
end
function UnlockDoor_ChiselDoor()
  GameObjects.ChiselDoor_Stn150_Stn800.LuaObjectScript.UnlockDoor()
end
function StartTravelerFight350()
  if firstVisit then
    firstVisit = false
    GameObjects.CA_Alert_Stn350.LuaObjectScript.Enable()
  else
    GameObjects.CA_SyncExit_Notraveler_Stn350.LuaObjectScript.Enable()
  end
  local stn350 = game.FindLevel("Stn350_RelicRoom")
  if stn350 ~= nil then
    stn350:CallScript("StartTravelerEncounter")
  end
end
function CA_Stn400_ElevatorEntrance_Enable()
  local stn400 = game.FindLevel("Stn400_HammerBase")
  if stn400 ~= nil then
    stn400:CallScript("Enable_CA_Squat_Stn400_ElevatorEntry")
  end
end
function CA_Stn400_ElevatorEntrance_Disable()
  local stn400 = game.FindLevel("Stn400_HammerBase")
  if stn400 ~= nil then
    stn400:CallScript("Disable_CA_Squat_Stn400_ElevatorEntry")
  end
end
function Stn430_EntryNav_Enable()
  GameObjects.LTW_Stn430_ToPit.LuaObjectScript.Enable()
end
function Stn430_EntryNav_Disable()
  GameObjects.LTW_Stn430_ToPit.LuaObjectScript.Disable()
end
function CA_Stn100_ChiselDoorNavDone()
  local stn100 = game.FindLevel("Stn100_Entrance")
  stn100:CallScript("ChiselDoorNavDone")
end
function CA_Stn150_DisableChiselDoorCA()
  local stn150 = game.FindLevel("Stn150_HandUnder")
  stn150:CallScript("DisableChiselDoorCA")
end
function ToBracerBase()
  local LM = require("level.loadmonitor")
  local loadMonitor = LM.CreateLoadMonitor()
  loadMonitor:AddCallback({
    Wads = {
      "Stn700_c360_ChiselSick"
    },
    Functions = {
      DisableMagniCol
    }
  })
end
function DisableMagniCol()
  game.FindLevel("Stn700_c360_ChiselSick"):CallScript("HideMagniCollision")
end
function MakeSonUnavailable()
  local availabilityState = {
    AvailableForSync = false,
    AvailableForBanter = true,
    AvailableInLevel = true,
    AvailableForCombat = true
  }
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function MakeSonAvailable()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function chiselDoorTo150Music()
  if musFirstTime == false then
    game.Audio.StartMusic("SND_MX_STN_chasm_retraversal_out")
    musFirstTime = true
  end
end
