local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
function DropPillar()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LIGHT",
    Duration = 2,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1},
    Weight = 1
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 0.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 2},
    Weight = 1
  })
  timer.StartLevelTimer(1, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_MEDIUM",
      Duration = 2,
      TweenIn = {Time = 0},
      TweenOut = {Time = 1},
      Weight = 0.5
    })
  end)
  timer.StartLevelTimer(1, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.2},
      Weight = 1
    })
  end)
  local l_level = game.FindLevel("Stn200_LakeExt")
  local l_obj = l_level:GetGameObject("Cbt_Stn200")
  if l_obj ~= nil then
    l_obj:CallScript("Start_Area_4_Fight_1")
  end
  GameObjects.BurstSpawnGroup:PlayAnimToFrame(45)
  timer.StartLevelTimer(3, function()
    local stn200 = game.FindLevel("Stn200_LakeExt")
    stn200:CallScript("SpawnPillarLift")
    GameObjects.BurstSpawnGroup:PlayAnimToFrame(51)
  end)
  LD.PlaySound(GameObjects.BurstSpawnGroup:FindSingleSoundEmitterByName("SNDStn220BurstSpawnSecondGroup"), "SND_BRK_Stone_Modular_Explo_Large")
  LD.PlaySoundOnFrame(GameObjects.BurstSpawnGroup:FindSingleSoundEmitterByName("SNDStn220BurstSpawnThirdGroup"), GameObjects.BurstSpawnGroup, "SND_EVNT_Stone_Mason_Buckle_Fall_Impact", 31)
end
function BurstOpenWall()
  local SND_BurstSpawnGroup
  SND_BurstSpawnGroup = GameObjects.BurstSpawnGroup:FindSingleSoundEmitterByName("SNDStn220BurstSpawnGroup")
  GameObjects.BurstSpawnGroup:JumpAnimToFrame(80)
  GameObjects.BurstSpawnGroup:PlayAnimToEnd()
  LD.PlaySound(SND_BurstSpawnGroup, "SND_BRK_Stone_Balcony_Stn200")
end
