local uiCalls = require("ui.uicalls")
local collisionCheck = require("camera.collisioncheck")
local ValidZone = "entityZone_ChiselInspection"
local LookAtFrameCount = 0
local fmEnded = false
local penDepth, HudToggle, verticalP, horizontalP, objectToTrigger
local cameraMarker = "ChiselMarker"
local triggerFrustum
function OnScriptLoaded(level, obj)
  HudToggle = false
  penDepth = 0.2
  verticalP = 0.5
  horizontalP = 0
  triggerFrustum = level:FindSingleGameObject(cameraMarker)
end
function OnUpdate(level, obj)
  if game.Player.FindPlayer():IsInsideEntityZone(ValidZone) and fmEnded == false then
    if triggerFrustum == nil then
      triggerFrustum = level:GetGameObject(cameraMarker)
    end
    local safe00 = collisionCheck.isTargetInFrustumUnobstructed(triggerFrustum:GetWorldPosition(), horizontalP, verticalP, penDepth, HudToggle)
    if safe00 == true then
      LookAtFrameCount = LookAtFrameCount + 1
      if LookAtFrameCount == 45 then
        ChiselBanter()
      end
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {deactivated = fmEnded}
end
function OnRestoreCheckpoint(level, obj, tab)
  fmEnded = tab.deactivated
end
function ChiselBanter()
end
