local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local son, thisLevel, Encounter20, Encounter21, Encounter22
local started = false
local SonBanterDone_01 = false
local SonBanterDone_02 = false
local bSindrSpotted, bRopeClimbDone, sonPup, syncPos, syncDir, switchParams, marker9, marker1, marker2, marker3, HealthMonitor, ChiselProximityMonitor, Stn200, Area_1_Encounter_1
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  thisLevel = level
  Area_1_Fight_1()
  marker9 = GameObjects.SonGotoChisel_Marker
end
function OnFirstStart(level)
  GameObjects.BanditCampStartZone:HideEntityVolume()
  GameObjects.EZ_CA_RopeDropSindri_Stn250.Child.LuaObjectScript.Disable()
end
function OnWadLoaded(level, newLevel)
  if Stn200 == nil and newLevel.Name == "WAD_Stn200_LakeExt" then
    Stn200 = newLevel
  end
end
function OnStart(level)
  if Stn200 == nil then
    Stn200 = game.FindLevel("Stn200_LakeExt")
  end
  if Area_1_Encounter_1:WasRunning() then
    Area_1_Encounter_1:Start()
  end
end
function Stn250_Bookmark_GotoStateAfterPuzzle()
  GameObjects.entityZone_ChiselInspection:HideEntityVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    bSindrSpotted = bSindrSpotted
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bSindrSpotted = savedInfo.bSindrSpotted
end
function AreaAnnounce_Stn250_Enter()
  uiCalls.UI_Event_DiscoverLocation("Head of Thamur")
end
function PlayerSawChisel()
  FreeSon()
  SonGotoChisel()
end
function Quest_StoneMason_Objective250()
  LD.CompleteQuest("Quest_StoneMason_Objective250")
  game.Compass.SetDesignerForcedHide(false)
end
function SonGotoChisel()
  syncPos = marker9:GetWorldPosition()
  syncDir = marker9:GetWorldForward()
  switchParams = {
    pos = syncPos,
    dir = syncDir,
    speed = 5,
    stop = true,
    complete_radius = 1
  }
  sonPup = game.Puppeteer.NewForce(thisLevel, "Go to Chisel", son)
  sonPup:Approach(switchParams)
  sonPup:OnArrival(SonReadyForButton, {pos = syncPos, radius = 1})
end
function SonReadyForButton()
  if SonBanterDone_02 == false then
    uiCalls.UI_Event_SendDesignerMessage("Son Banter: Is that the chisel we need?", 3)
    sonPup:StartBranch("BRA_ForceStand")
  end
  FreeSon()
  GameObjects.GenericSonInteract.LuaObjectScript.Enable()
end
function SonLookAtChisel()
  uiCalls.UI_Event_SendDesignerMessage("Son Banter: Damn! The chisel is too deep inside the ice.", 6)
  StartSurpriseFight()
end
function StartSurpriseFight()
  Area_1_Encounter_1:Start()
end
function FreeSon()
  if sonPup ~= nil then
    sonPup:Clear()
    sonPup:DetachPuppet()
    sonPup = nil
  end
end
function RopeClimbDone()
  bRopeClimbDone = true
end
function BTR_PlayIsThatSindri()
  if not bSindrSpotted then
    bSindrSpotted = true
    game.Audio.PlayBanter("stn_SindriSpotted")
  end
end
function SindriSequenceStarted()
  bSindrSpotted = true
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Wave Fights Stn250", {
    CheckpointOnComplete = true,
    spawnWad = "Stn250_c_AI",
    StartMusic = "SND_MX_STN_head_camp_fight_1a_in",
    StopMusic = "SND_MX_STN_head_camp_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "CR4_H_Draugr_N_SBQG1*",
      spawnLocators = "A1_B_Loc_1",
      markerID = "BurstOut",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.11
    },
    {
      spawners = "Draugr_PL_SFA",
      spawnLocators = "A1_U_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2.03
    },
    {
      spawners = "CR3_SH_Draugr_L_SFG",
      spawnLocators = "A1_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.23
    },
    {
      spawners = "CR3_SH_Draugr_L_SFG",
      spawnLocators = "A1_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 20.37
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "CR2_Jotunn_N_SFA",
      spawnLocators = "A1_E_Loc_2",
      markerID = "Jotunn",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "CR2_W_Draugr_N_SFA",
      spawnLocators = "A1_E_Loc_1*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 1.5,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2.5
    },
    {
      spawners = "CR2_W_Draugr_N_SFA",
      spawnLocators = "A1_E_Loc_3*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 10.5,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "CR2_W_Draugr_N_SFA",
      spawnLocators = "A1_U_Loc_2",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = 23.5,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "CR1_Jotunn_N_SFA",
      spawnLocators = "A1_E_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "CR3_W_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "CR3_W_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "CR3_W_Draugr_N_SFG",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8.5
    }
  })
  Area_1_Encounter_1:OnStart(function()
    game.World.StoreCheckpoint()
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave()
  end, {count = 6})
  Area_1_Encounter_1:OnEnemySpawn(function()
    Health_Encounter()
    JotJoinsTheFight()
  end, {markerID = "Jotunn"})
  Area_1_Encounter_1:OnEnemySpawn(function()
    local stn220 = game.FindLevel("Stn220_LakeCombat")
    if stn220 ~= nil then
      timer.StartLevelTimer(0.3, function()
        stn220:CallScript("BurstOpenWall")
      end)
    end
  end, {markerID = "BurstOut"})
  Area_1_Encounter_1:OnComplete(function()
    game.Level.SetVariable("BanditCampCombatComplete", true)
    timer.StartLevelTimer(3.7, function()
      GameObjects.Reaction_OutOfBreath_250.LuaObjectScript.Trigger()
    end)
    timer.StartLevelTimer(10, function()
      if game.Level.GetVariable("CompletedCineNumber") < 349 then
        GameObjects.EZ_CA_RopeDropSindri_Stn250.Child.LuaObjectScript.Enable()
        if not bRopeClimbDone then
          GameObjects.CA_Observe_Forward_Up_RopeDrop_Stn250.LuaObjectScript.Enable()
        end
      end
    end)
    game.FindLevel("Stn290_SindriShop"):GetGameObject("Cine_SindriStoneMason"):CallScript("SindriSpotedPOISequence")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ogre_Basher")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Shield")
  end)
end
function Health_Encounter(Enemy)
  if Enemy ~= nil then
    HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local enemyHealth = Enemy:GetHitPoints()
    local Phase_1 = enemyHealth * 0.48
    HealthMonitor:OnHealthLessThan(Phase_1, function()
      Area_1_Encounter_1:StartWave()
    end)
  end
end
function JotJoinsTheFight()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_head_camp_fight_1b_in")
end
