local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local thisObj, player
local bKratos_In = false
local bSon_In = false
local bBeardBTRStart, bCrystalShot, bFancyBeardPlayed
local bSonTurret_On = false
local bTurretBanterDone = false
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level)
  return {bBeardBTRStart = bBeardBTRStart, bTurretBanterDone = bTurretBanterDone}
end
function OnRestoreCheckpoint(level, savedInfo)
  bBeardBTRStart = savedInfo.bBeardBTRStart
  bTurretBanterDone = savedInfo.bTurretBanterDone
end
function OnUpdate(level)
  if bSonTurret_On == true and bKratos_In == true and bTurretBanterDone == false and bBeardBTRStart == true then
    bTurretBanterDone = true
    BTR_FancyBeards()
    game.SubObject.Sleep(thisObj)
  end
end
function Kratos_In()
  bKratos_In = true
  BeardBTRStart()
end
function Kratos_Out()
  bKratos_In = false
end
function Son_In()
  bSon_In = true
  BeardBTRStart()
end
function Son_Out()
  bSon_In = false
end
function BeardBTRStart()
  if player:PickupIsAcquired("QuestDisableEvades") == true then
    return
  end
  local timeSinceBanterPlayed = game.Audio.GetTimeSinceBanterPlayed()
  if timeSinceBanterPlayed < 1 then
    return
  end
  if not bBeardBTRStart and bKratos_In == true and bSon_In == true then
    game.SubObject.Wake(thisObj)
    game.Audio.PlayBanterNonCritical("stn_FancyBeard1", BeardBTRStartDone)
  end
end
function BeardBTRStartDone()
  bBeardBTRStart = true
end
function SonPerch_On()
  bSonTurret_On = true
end
function SonPerch_Off()
  bSonTurret_On = false
end
function BTR_FancyBeards()
  if not bFancyBeardPlayed then
    timer.StartLevelTimer(2, function()
      if player:PickupIsAcquired("QuestDisableEvades") == true then
        return
      end
      local timeSinceBanterPlayed = game.Audio.GetTimeSinceBanterPlayed()
      if timeSinceBanterPlayed < 0.5 then
        return
      end
      bFancyBeardPlayed = true
      game.Audio.PlayBanter("stn_FancyBeard", BTR_PlayWaitShatter)
    end)
  end
end
function CrystalShotCheck()
  bCrystalShot = true
end
function BTR_PlayWaitShatter()
  timer.StartLevelTimer(6, function()
    if player:PickupIsAcquired("QuestDisableEvades") == true then
      return
    end
    local timeSinceBanterPlayed = game.Audio.GetTimeSinceBanterPlayed()
    if timeSinceBanterPlayed < 1 then
      return
    end
    if not bCrystalShot then
      print("!!! play shatter started")
      game.Audio.PlayBanter("stn_FancyBeard3")
    end
  end)
end
function PlayCareful()
  game.Audio.PlayBanter("stn_FancyBeard4")
end
