local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local animMonitor02, dreadlock02
local varVibrateStage = 0
local BanterScript_Stn300
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
local bShortBraidHitFirst, masonBraidShort, masonBraidLong, bFancyBeardPlayed, braidShortCrystal, braidShortLight, braidLongCrystal, braidLongLight, braidBaitCrystal, braidBaitLight
SNDhairStrand = nil
function OnScriptLoaded(level)
  if game.Level.GetVariable("CompletedCineNumber") >= 350 then
    GameObjects.CamZone_CineEnter_HuldraCamp:HideCameraVolume()
  end
  masonBraidShort = GameObjects.masonBraidShort.Child
  masonBraidLong = GameObjects.masonBraidLong.Child
  braidShortCrystal = masonBraidShort:FindSingleGOByName("BifrostVibrate_Intact_sm_0")
  braidLongCrystal = masonBraidLong:FindSingleGOByName("BifrostVibrate_Intact_sm0")
  braidBaitCrystal = masonBraidLong:FindSingleGOByName("BifrostVibrate_Intact_sm1")
  braidShortLight = masonBraidShort:FindSingleGOByName("Stn_RedJewel_Cust3_sm_0")
  braidLongLight = masonBraidLong:FindSingleGOByName("Stn_RedJewelA_Long_Cust3_sm0")
  braidBaitLight = masonBraidLong:FindSingleGOByName("Stn_RedJewelB_Long_Cust3_sm1")
  BanterScript_Stn300 = GameObjects.Btr_FancyBeard_Group
  SNDhairStrand = GameObjects.SND_DreadLock:FindSingleSoundEmitterByName("SNDhairStrand")
  SoundInit()
  GameObjects.Huldra_Breakables:HideParticles()
end
function OnFirstStart(level)
  masonBraidShort:StartAnim("envReactToExplosion")
  masonBraidShort:JumpAnimToFrame(0)
  masonBraidShort:PauseAnim()
  masonBraidLong:StartAnim("envFallFromWallCrumble")
  masonBraidLong:JumpAnimToFrame(0)
  masonBraidLong:PauseAnim()
  GameObjects.TraverseLink_Jump_01:HideTraverseLink()
end
function OnSaveCheckpoint(level)
  return {varVibrateStage = varVibrateStage}
end
function OnRestoreCheckpoint(level, savedInfo)
  varVibrateStage = savedInfo.varVibrateStage
  local appVersion, masterVersion = level:GetAppMasterVersion()
  if appVersion == 256 then
    local player = game.Player.FindPlayer()
    local son = game.AI.FindSon()
    local savedAvailState = son:GetAvailabilityStateRequestByName("LevelDesignScript")
    if savedAvailState ~= nil and savedAvailState.Unoccupied == false then
      local vendorCheckpointPos = engine.Vector.New(556.141, 0.001, 300.646)
      if player:GetWorldPosition():Distance(vendorCheckpointPos) < 2 then
        son:RemoveAvailabilityRequest("LevelDesignScript")
        if savedAvailState.AvailableForSync == false or savedAvailState.AvailableForBanter == false or savedAvailState.AvailableInLevel == false or savedAvailState.AvailableForCombat == false then
          savedAvailState.Unoccupied = true
          son:SetNewAvailabilityRequest("LevelDesignScript", savedAvailState)
        end
      end
    end
    QuestStoneFixup()
  end
end
function QuestStoneFixup()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_02")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneForestDungeon")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneForestDungeon", 1)
  end
  local questState2 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_01")
  local entryStone2 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneVolundr")
  if (entryStone2 == 0 or entryStone2 == -1) and questState2 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneVolundr", 1)
  end
  local questState3 = game.QuestManager.GetQuestState("Quest_Sindri_Epic_02_Objective_01")
  local entryStone3 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra3")
  if (entryStone3 == 0 or entryStone3 == -1) and questState3 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra3", 1)
  end
  local questState4 = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  local entryStone4 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra2")
  if (entryStone4 == 0 or entryStone4 == -1) and questState4 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra2", 1)
  end
end
function LoadCheck_Stn300_Stn350()
  game.UI.LoadCheck("Stn350_RelicRoom")
end
function Debug_TestBraidAnim()
  if masonBraidLong.AnimFrame > 0 then
    masonBraidLong:JumpAnimToFrame(0)
    masonBraidLong:PauseAnim()
  else
    masonBraidLong:StartAnim("envFallFromWallCrumble")
  end
  if masonBraidShort.AnimFrame > 0 then
    masonBraidShort:JumpAnimToFrame(0)
    masonBraidShort:PauseAnim()
  else
    masonBraidShort:StartAnim("envReactToExplosion")
  end
end
function VibrateCrystalLit()
  if varVibrateStage == 0 then
    varVibrateStage = 1
  end
  if varVibrateStage == 1 then
    VibrateStage01()
    varVibrateStage = 2
  end
  if varVibrateStage == 2 then
    VibrateStage02()
  end
end
function HideRealDreadlocks()
  GameObjects.masonBraidShort:Hide()
  GameObjects.masonBraidLong:Hide()
end
function BaitCrystalHit()
  braidBaitCrystal.LuaObjectScript.Deactivate()
  braidBaitLight:Hide()
  if varVibrateStage == 0 then
    BTR_CrystalShot()
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envThirdGemReact_State0",
      Rate = 1
    })
  elseif varVibrateStage == 1 and bShortBraidHitFirst then
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envThirdGemReact_State0",
      Rate = 1
    })
  elseif varVibrateStage == 1 and not bShortBraidHitFirst then
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envThirdGemReact_State1",
      Rate = 1
    })
  elseif varVibrateStage == 2 then
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envThirdGemReact_State2",
      Rate = 1
    })
  end
end
function VibrateStage01()
  GenericShakeAndRumbleLarge()
  if varVibrateStage == 0 then
    varVibrateStage = 1
    BTR_CrystalShot()
    braidShortCrystal.LuaObjectScript.Deactivate()
    braidShortLight:Hide()
    bShortBraidHitFirst = true
    GameObjects.Huldra_Breakables:ShowParticles()
    GameObjects.Huldra_Breakables:PlayAnimToFrame(90)
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envReactToExplosion",
      Rate = 1
    })
    masonBraidShort:StartAnim("envReactToExplosion")
    AudioHairStrand1()
  else
    varVibrateStage = 2
    braidShortCrystal.LuaObjectScript.Deactivate()
    braidShortLight:Hide()
    LD.CallFunctionAfterDelay(function()
      GameObjects.EEE_BraidDrop.LuaObjectScript.Trigger()
    end, 0.55)
    LD.SetEntityVariable("STN_DreadlockSolved", true)
    ShowJumpTraversal()
    GameObjects.Huldra_Breakables:ShowParticles()
    GameObjects.Huldra_Breakables:PlayAnimToEnd()
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envFallFromWallCrumble_Part2",
      Rate = 1
    })
    masonBraidShort:StartAnim("envReactToExplosion")
    AudioHairStrand2()
    GameObjects.CA_Son_ObserveForward_Turret.LuaObjectScript.Disable()
    GameObjects.CA_Point_Forward_Stn300_ToRelicPath.LuaObjectScript.Enable()
  end
end
function VibrateStage02()
  GenericShakeAndRumbleTitan()
  if varVibrateStage == 0 then
    varVibrateStage = 1
    BTR_CrystalShot()
    braidLongCrystal.LuaObjectScript.Deactivate()
    braidLongLight:Hide()
    GameObjects.Huldra_Breakables:ShowParticles()
    GameObjects.Huldra_Breakables:PlayAnimToFrame(90)
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envFallFromWallCrumble_Part1",
      Rate = 1
    })
    AudioHairStrand1()
    GameObjects.masonBraidLong:FindSingleGOByName("Flipper1"):FindSingleGOByName("FlippableComponent1").LuaObjectScript.DisableRotation()
    GameObjects.masonBraidLong:FindSingleGOByName("Flipper2"):FindSingleGOByName("FlippableComponent2").LuaObjectScript.DisableRotation()
  else
    varVibrateStage = 2
    braidLongCrystal.LuaObjectScript.Deactivate()
    braidLongLight:Hide()
    GameObjects.EEE_BraidDrop.LuaObjectScript.Trigger()
    LD.SetEntityVariable("STN_DreadlockSolved", true)
    GameObjects.Huldra_Breakables:ShowParticles()
    GameObjects.Huldra_Breakables:PlayAnimToEnd()
    masonBraidLong:PlayAnimationToEnd({
      Animation = "envFallFromWallCrumble_Part3",
      Rate = 1
    })
    AudioHairStrand2()
    ShowJumpTraversal()
    GameObjects.masonBraidLong:FindSingleGOByName("Flipper1"):FindSingleGOByName("FlippableComponent1").LuaObjectScript.DisableRotation()
    GameObjects.masonBraidLong:FindSingleGOByName("Flipper2"):FindSingleGOByName("FlippableComponent2").LuaObjectScript.DisableRotation()
    GameObjects.CA_Son_ObserveForward_Turret.LuaObjectScript.Disable()
    GameObjects.CA_Point_Forward_Stn300_ToRelicPath.LuaObjectScript.Enable()
  end
end
function GenericShakeAndRumbleLarge()
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 2},
    Priority = 2
  })
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.5},
    Priority = 2
  })
end
function GenericShakeAndRumbleTitan()
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 2},
    Priority = 5
  })
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.5},
    Priority = 5
  })
end
function ShowJumpTraversal()
  timer.StartLevelTimer(3, function()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
    GameObjects.TraverseLink_Jump_01:ShowTraverseLink()
    BanterScript_Stn300.LuaObjectScript.PlayCareful()
  end)
end
function BTR_CrystalShot()
  GameObjects.Btr_FancyBeard_Group.LuaObjectScript.CrystalShotCheck()
end
function BTR_PlayCareful()
  BanterScript_Stn300.LuaObjectScript.PlayFoundRope()
end
function ShakeRumble()
  game.FX.SubmitEffect(camShakeLarge)
  game.FX.SubmitEffect(ForceFeedbackRumble)
end
local spinnerEmitters = {}
local Strand1Broken = false
local Strand2Broken = false
function SoundInit()
  GameObjects.masonBraidShort:FindSingleGOByName("FlippableComponent1").LuaObjectScript.RegisterOnRotateCallback(function()
    PlayOnRotateSoundSmall(1)
  end)
  GameObjects.masonBraidLong:FindSingleGOByName("Flipper1"):FindSingleGOByName("FlippableComponent1").LuaObjectScript.RegisterOnRotateCallback(function()
    PlayOnRotateSoundLarge(2)
  end)
  GameObjects.masonBraidLong:FindSingleGOByName("Flipper2"):FindSingleGOByName("FlippableComponent2").LuaObjectScript.RegisterOnRotateCallback(function()
    PlayOnRotateSoundLarge(3)
  end)
  spinnerEmitters[1] = GameObjects.SNDSpinners:FindSingleSoundEmitterByName("SNDBeardSpinner1")
  spinnerEmitters[2] = GameObjects.SNDSpinners:FindSingleSoundEmitterByName("SNDBeardSpinner2")
  spinnerEmitters[3] = GameObjects.SNDSpinners:FindSingleSoundEmitterByName("SNDBeardSpinner3")
end
function PlayOnRotateSoundSmall(targetSpinnerIndex)
  LD.PlaySound(spinnerEmitters[targetSpinnerIndex], "SND_MECH_Amulet_Small_Rotate")
end
function PlayOnRotateSoundLarge(targetSpinnerIndex)
  LD.PlaySound(spinnerEmitters[targetSpinnerIndex], "SND_MECH_Amulet_Large_Rotate")
end
function AudioHairStrand1()
  LD.PlaySound(SNDhairStrand, "SND_EVNT_Stone_Mason_Dreadlock_Break")
  print("AudioHairStrand1")
  Strand1Broken = true
  if Strand1Broken == true and Strand2Broken == true then
    game.Audio.StartMusic("SND_MX_STN_beard_path_clear")
  end
end
function AudioHairStrand2()
  LD.PlaySound(SNDhairStrand, "SND_EVNT_Stone_Mason_Dreadlock_Collapse")
  print("AudioHairStrand2")
  Strand2Broken = true
  if Strand1Broken == true and Strand2Broken == true then
    game.Audio.StartMusic("SND_MX_STN_beard_path_clear")
  end
end
function ShowDebugTable()
  local debugTable = {}
  debugTable.Title = "Stn300 Info"
  debugTable.X = 120
  debugTable.Y = 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  debugTable[#debugTable + 1] = {
    "masonBraidLong AnimFrame: ",
    masonBraidLong.AnimFrame
  }
  debugTable[#debugTable + 1] = {
    "masonBraidShort AnimFrame: ",
    masonBraidShort.AnimFrame
  }
  engine.DrawDebugTable(debugTable)
end
