local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
local vibrateCount = 0
local thisLevel, Target_Traveler
local bEnableAxeThrowCheck = false
local player, pad, Area_1_Encounter_1, ZM_A1E1_Attack, ZM_A1E1_CP
function OnScriptLoaded(level)
  player = game.Player:FindPlayer()
  pad = player.Pad
  thisLevel = level
  Traveler_Area_1_Fight_1()
end
function OnStart(level)
  GameObjects.push_block_KP:FindSingleGOByName("HandleAttachPoint_F").LuaObjectScript.OverrideCameraInteractApproach("ENV_Crank_Approach_Stn350")
  GameObjects.push_block_KP:FindSingleGOByName("HandleAttachPoint_F").LuaObjectScript.OverrideDefaultCameraPitch(true, 10)
  GameObjects.push_block_KP:FindSingleGOByName("HandleAttachPoint_F").LuaObjectScript.OverrideDefaultCameraYaw(true, 28)
  SoundOnStart()
end
function OnFirstStart(level)
  GameObjects.TraversePath_medallion:HideTraversePath()
  GameObjects.TraversePath_medallion:HideTraversePath()
end
function OnUpdate(level)
  if Area_1_Encounter_1:IsRunning() == true and Target_Traveler ~= nil and Target_Traveler:PickupGetStage("TravelerArmor") == 2 and Area_1_Encounter_1:IsRunning(2) == false then
    Area_1_Encounter_1:StartWave(2)
  end
  if bEnableAxeThrowCheck == true then
    if player.Axe.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSInFlightOut then
      pad:DisableGameButton(tweaks.ePad.kPadCircle)
    else
      pad:EnableGameButton(tweaks.ePad.kPadCircle)
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Loadcheck_Stn350_Stn300()
  game.UI.LoadCheck("Stn300_HuldraCamp", "Stn290_SindriShop")
end
function DisableThrowCheck()
  bEnableAxeThrowCheck = false
end
function IsOnGround()
  GameObjects.medalion_grp.Child.LuaObjectScript.SetVarKratosOnA_False()
  GameObjects.medalion_grp.Child.LuaObjectScript.SetVarKratosOnB_False()
  GameObjects.medalion_grp.Child.LuaObjectScript.SetVarGround_On()
end
function IsOffGround()
  GameObjects.medalion_grp.Child.LuaObjectScript.SetVarGround_Off()
end
function MedallionTraversalOff()
  GameObjects.medalion_grp.Child.LuaObjectScript.HideTraversalPaths()
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
end
function MedallionTraversalActivate_A()
  bEnableAxeThrowCheck = true
  GameObjects.medalion_grp.Child.LuaObjectScript.SetVarKratosOnA_True()
  GameObjects.medalion_grp.Child.LuaObjectScript.ShowActivePath()
end
function EZ_FarBonusChestCheck_DisableDelay()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_Observe_Forward_Up_Stn350_FarBonus.LuaObjectScript.Disable()
  end, 5)
end
function EZ_MedallionBonusCheck_DisableDelay()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_Observe_Forward_Up_Stn350_MedallionBonus.LuaObjectScript.Disable()
  end, 3)
end
function MedallionTraversalActivate_B()
  bEnableAxeThrowCheck = true
  GameObjects.medalion_grp.Child.LuaObjectScript.SetVarKratosOnB_True()
  GameObjects.medalion_grp.Child.LuaObjectScript.ShowActivePath()
end
function MedallionWin()
  GameObjects.IdleContext_Puzzled.LuaObjectScript.Disable()
  GameObjects.EZE_MedallionWin_Stn350:HideEntityVolume()
  GameObjects.AwarenessZone_Medallion.LuaObjectScript.DisableEventEmitter()
end
function ShakeRumble()
  game.FX.SubmitEffect(camShakeLarge)
end
function BlockerAtSecret()
  ShakeRumble()
end
function BlockerAtExit()
  ShakeRumble()
end
function StartTravelerEncounter()
  Area_1_Encounter_1:Start()
end
function Traveler_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Turtle Traveler Stn350", {
    CheckpointOnComplete = true,
    AutoResetOnReload = false,
    StartMusic = "SND_MX_STN_temple_guard_fight_in",
    StopMusic = "SND_MX_STN_temple_guard_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Traveler_SFG",
      markerID = "STN350_Traveler",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = 4
    }
  })
  Area_1_Encounter_1:AddWave({
    timeBetweenWaves = 13,
    {
      spawners = "Fanatic_T_SFG",
      spawnLocators = "A1_U_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3,
      powerLevel = 1
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Fanatic_S_SFG",
      spawnLocators = "A1_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 5,
      powerLevel = 2
    },
    {
      spawners = "Fanatic_S_SFG",
      spawnLocators = "A1_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 8.3,
      powerLevel = 2
    }
  })
  Area_1_Encounter_1:SetAlertZone(GameObjects.EntZn_Area_1_Attack)
  Area_1_Encounter_1:OnEnemySpawn(function(enemy)
    Target_Traveler = enemy
  end, {
    markerID = "STN350_Traveler"
  })
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:SetComplete()
  end, {
    markerID = "STN350_Traveler"
  })
  Area_1_Encounter_1:OnStart(function()
    if Area_1_Encounter_1:WasRunning() then
      LD.CallFunctionAfterDelay(function()
        Area_1_Encounter_1:AlertEnemies()
      end, 5)
    end
  end)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Traveler_Champion")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Fanatic")
    GameObjects.CA_PushDoorStruggle_Stn350_Block.LuaObjectScript.Enable()
    GameObjects.IdleContext_Puzzled.LuaObjectScript.Enable()
  end)
end
local PushBlockSoundOverrides = {
  OnForward = "SND_PUSH_Stone_Slab_Block_LP",
  OnBackward = "SND_PUSH_Stone_Slab_Block_LP"
}
function SoundOnStart()
  GameObjects.push_block_KP:FindSingleGOByName("HandleAttachPoint_F").LuaObjectScript.CrankSoundSetup(PushBlockSoundOverrides)
end
