local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local mpicon = require("ui.mpicon")
local thisObj, thisLevel, kraActor, sonActor, iceSlideObj, hammerObj, tnfPromptObject
local hammerWarped = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  hammerObj = GameObjects.masonHammer00.Child
  tnfPromptObject = GameObjects.hammerTNFPromptLocation
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 355 then
    SetupActors()
    SetupProps()
  end
  if hammerWarped then
    WarpHammer()
  end
end
function OnSaveCheckpoint(level, obj)
  return {hammerWarped = hammerWarped}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  hammerWarped = savedInfo.hammerWarped or false
end
function SetupActors()
  kraActor = actor.Actor.New("HAMMER FALL: KRATOS ACTOR", game.Player.FindPlayer)
  sonActor = actor.Actor.New("HAMMER FALL: SON ACTOR", game.AI.FindSon)
end
function HammerFallSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Hammer Fall Sequence")
  local slaveTable = {
    {
      Actor = sonActor,
      Branch = "BRA_HammerFall"
    },
    {
      Obj = hammerObj,
      Anim = "narStnHammerFall000CineEnter"
    }
  }
  cineSeq:Do(function()
    if not hammerWarped then
      SetupHammerForPush()
    end
  end)
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:SetPostSkipMusic("SND_MX_STN_start_master")
  cineSeq:WaitForLoadCheck("Stn400_HammerBase")
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_HammerFall",
    ReferenceJoint = "HammerFall_SynchJoint",
    speed = 0.9,
    stop = false,
    radius = 0.1,
    weapon_state = "bare"
  })
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTable,
    Branch = "BRA_HammerFall",
    ReferenceJoint = "HammerFall_SynchJoint"
  })
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_HammerFallIdle")
  end)
  cineSeq:Do(CreateMashPrompt)
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_HammerFallCine")
  end)
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(PlayProps)
  cineSeq:Do(CompassOff)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.53)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(1)
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.56)
  cineSeq:WaitForLoadCheck("Stn500_ImpactSite")
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.567)
  cineSeq:Do(function()
    game.FindLevel("Stn500_ImpactSite"):CallScript("DisableEntryNode")
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.65)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(nil)
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:WaitForLoadCheck("Stn550_ChasmClimb")
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:SetCompletedCineNumber(355)
  cineSeq:StartSequence()
end
function SetupProps()
  iceSlideObj = GameObjects.IceSlide_Anim
  iceSlideObj:Hide()
end
function PlayProps()
  Stn460_HideHammerBirds()
  iceSlideObj:Show()
  iceSlideObj:JumpAnimToFrame(718)
  iceSlideObj:PlayAnimToEnd()
  RemoveMashPrompt()
  _G.HammerFalls()
end
function SetupHammerForPush()
  hammerObj:StartAnim("narStnHammerFall000CineEnter")
  hammerObj:JumpAnimToFrame(0)
  hammerObj:PauseAnim()
  hammerObj:HideCollision()
  GameObjects.HammerIC:HideCollision()
  GameObjects.Hammer_block2:HideCollision()
  GameObjects.Hammer_block3:HideCollision()
  GameObjects.Hammer_block4:HideCollision()
  GameObjects.Hammer_block5:HideCollision()
  GameObjects.Hammer_block7:HideCollision()
  GameObjects.Hammer_block8:HideCollision()
  GameObjects.Hammer_block9:HideCollision()
  GameObjects.Hammer_block10:HideCollision()
  WarpHammer()
end
function WarpHammer()
  hammerWarped = true
  local pos = LD.GetWorldJointPosition("Cine_HammerFall_Group", "HammerFall_SynchJoint")
  local dir = LD.GetWorldJointForward("Cine_HammerFall_Group", "HammerFall_SynchJoint")
  hammerObj:SetWorldPosition(pos)
  hammerObj:SetWorldFacing(dir)
end
function CheckHammer()
  local pos = LD.GetWorldJointPosition("Cine_HammerFall_Group", "HammerFall_SynchJoint")
  local dir = LD.GetWorldJointForward("Cine_HammerFall_Group", "HammerFall_SynchJoint")
  return hammerObj:GetWorldPosition() == pos and hammerObj:GetWorldForward() == pos
end
function CreateMashPrompt()
  mpicon.level.Create(tnfPromptObject, "WORLD_INTERACT_MASHBUTTON")
end
function RemoveMashPrompt()
  mpicon.level.Off(tnfPromptObject, "WORLD_INTERACT_MASHBUTTON")
end
function Stn460_HideHammerBirds()
  local stn460 = game.FindLevel("Stn460_HammerHead")
  stn460:CallScript("HideHammerBirds")
end
function CompassOff()
  game.Compass.SetDesignerForcedHide(true)
end
