local thisObj, thisLevel, player, son, kraPuppeteer
local gotoJointStr = "Kra_GotoJoint"
local playedGotoBool = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  InitializeVariables()
end
function OnUpdate(level, obj)
  if _G.varPendulumSolved and not playedGotoBool then
    playedGotoBool = true
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {playedBool = playedGotoBool}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedGotoBool = savedInfo.playedBool
end
function InitializeVariables()
end
function PlayGoto()
  local jointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex(gotoJointStr))
  local jointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex(gotoJointStr))
  kraPuppeteer = game.Puppeteer.NewForce(thisObj, "POST PENDULUM: Kratos Puppet", player)
  kraPuppeteer:Approach({
    pos = jointPos,
    dir = jointFace,
    speed = 2,
    stop = false
  })
  kraPuppeteer:OnArrival(function()
    kraPuppeteer = nil
  end, {pos = jointPos, radius = 1.5})
end
