LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
local TUT = require("game.GlobalTutorials")
local Done = false
local kratos = game.Player.FindPlayer()
local player, son, KratosWarpLocator, AtreusWarpLocator, HammerCrawlPath
function OnScriptLoaded(level)
  HammerCrawlPath = level:FindTraversePath("TraversePath1_crawl_under_hammerV4")
  SoundInit()
end
function OnUpdate(level)
  if kratos:InsideZone(GameObjects.Stn500_Crater_ExitZone) then
    GameObjects.Hammer:Show()
  elseif kratos:InsideZone(GameObjects.Zone_HideStaticHammer) then
    GameObjects.Hammer:Hide()
  else
    GameObjects.Hammer:Show()
  end
end
function DisableEntryNode()
  HammerCrawlPath:Disable("crawl_enter")
  LoadCheck_Stn500_Stn550()
end
function DisableNode_1()
  HammerCrawlPath:Disable("crawl_1")
end
function DisableNode_2()
  HammerCrawlPath:Disable("crawl_2")
end
function DisableNode_3()
  HammerCrawlPath:Disable("crawl_3")
end
function DisableNode_4()
  HammerCrawlPath:Disable("crawl_4")
end
function DisableNode_5()
  HammerCrawlPath:Disable("crawl_5")
end
function Rumble01()
  GameObjects.Rumble01:HideEntityVolume()
  PlaySoundAvalancheJolt()
end
function Rumble02()
  GameObjects.Rumble02:HideEntityVolume()
  PlaySoundAvalancheJolt()
end
function Rumble03()
  GameObjects.Rumble03:HideEntityVolume()
end
function Rumble04()
  GameObjects.Rumble04:HideEntityVolume()
end
function LoadCheck_Stn500_Stn550()
  timer.StartLevelTimer(17, function()
    game.UI.LoadCheck("Stn550_ChasmClimb")
  end)
end
local Stn050Ref, SNDAvalanche2D, SNDAvalanche3D
function SoundInit()
  SNDAvalanche2D = GameObjects.SNDAvalancheGrp:FindSingleSoundEmitterByName("SNDAvalanche2D")
  SNDAvalanche3D = GameObjects.SNDAvalancheGrp:FindSingleSoundEmitterByName("SNDAvalanche3D")
end
function PlaySoundAvalancheLoop(level)
  GameObjects.AvalancheZone:HideEntityVolume()
  LD.PlaySound(SNDAvalanche2D, "SND_AMB_EMIT_Ice_Avalanche_Inside_LP")
  LD.PlaySound(SNDAvalanche3D, "SND_AMB_EMIT_Ice_Avalanche_Outside_LP")
end
function PlaySoundAvalancheJolt(level)
  LD.PlaySound(SNDAvalanche3D, "SND_AMB_EMIT_Ice_Avalanche_Jolt")
end
function StopSoundAvalancheLoop(level)
  LD.StopSound(SNDAvalanche2D, "SND_AMB_EMIT_Ice_Avalanche_Inside_LP")
  LD.StopSound(SNDAvalanche3D, "SND_AMB_EMIT_Ice_Avalanche_Outside_LP")
  LD.PlaySound(SNDAvalanche2D, "SND_AMB_EMIT_Ice_Avalanche_End")
end
