local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local thisLevel, player, Area_1_Encounter_1, Area_2_Encounter_1
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  GameObjects.ChasmCombat_StartZone:HideEntityVolume()
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Stn550", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_Stn550,
    AutoResetOnReload = true,
    StartMusic = "SND_MX_STN_chasm_climb_fight_in",
    StopMusic = "SND_MX_STN_chasm_climb_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_E_SFA",
      spawnLocators = "A1_I_Loc_1",
      markerID = "DraugrBreak_L",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "Draugr_E_SFA",
      spawnLocators = "A1_I_Loc_4",
      markerID = "DraugrBreak_R",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 4.1
    }
  })
  Area_1_Encounter_1:OnEnemySpawn(function()
    LD.BreakObject(GameObjects.Ice_Spawn_01)
  end, {
    markerID = "DraugrBreak_L"
  })
  Area_1_Encounter_1:OnEnemySpawn(function()
    LD.BreakObject(GameObjects.Ice_Spawn_02)
  end, {
    markerID = "DraugrBreak_R"
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"))
  Area_1_Encounter_1:OnStart(function()
    GameObjects.TraversePath_ClimbToCrawl:HideTraversePath()
    game.World.StoreCheckpoint()
  end)
  Area_1_Encounter_1:OnComplete(function()
    GameObjects.TraversePath_ClimbToCrawl:ShowTraversePath()
  end)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Stn550", {CheckpointOnComplete = true})
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Flyer_N_SABF",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyer_N_SABF",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.9
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Spawn"))
end
