local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local CWU = require("camera.camera_wakeup")
local CCOS = require("camera.camera_oneshot")
local checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local CSL = require("camera.shakelibrary")
local player, camWakeUpLevel, bChasmCollapseDone
local bCamCollapseZone = false
local bSurpriseCliffCollapse = false
local IceFall_ref, BridgeBreak_trigger, bridgeToBreak, bCrawlEntryCavedIn, oneShotCliffBreakStart, oneShotCliffBreakEnd, zoneMonitorBridge
local bridgeBroken = false
local pad, collapse_1, collapse_2, collapse_3, collapse_4, collapse_5, oneshotCamRavineCollapse
function OnScriptLoaded(level)
  player = game.Player:FindPlayer()
  pad = player.Pad
  camWakeUpLevel = level
  IceFall_ref = level:GetGameObject("stn550_ice_top_break")
  BridgeBreak_trigger = level:GetGameObject("TriggerZone_BridgeBreak")
  bridgeToBreak = level:GetGameObject("platform_fall_02")
  zoneMonitorBridge = monitors.CreateEntityZoneMonitor(player, "TriggerZone_BridgeBreak")
  zoneMonitorBridge:OnEnter(PlaySoundBridgeBreak)
  GameObjects.CaveInCrawlExit:Hide()
  collapse_1 = GameObjects.Stn550_ice_tower_01_break.Child
  collapse_2 = GameObjects.Stn550_ice_tower_02_break.Child
  collapse_3 = GameObjects.Stn550_ice_tower_03_break.Child
  collapse_4 = GameObjects.Stn550_ice_tower_04_break.Child
  collapse_5 = GameObjects.Stn550_ice_tower_05_break.Child
  SoundInit()
  LD.HideFX(IceFall_ref)
end
function OnStart()
  if bChasmCollapseDone == true then
    collapse_1:Hide()
    collapse_2:Hide()
    collapse_3:Hide()
    collapse_4:Hide()
    collapse_5:Hide()
  end
  if bCrawlEntryCavedIn then
    ShowCaveInCrawlExit()
  end
  if game.Wallets.HasResource("HERO", "ChiselUnlock") then
    game.Compass.SetGatewayMarkerIsOpen("SM_550_Helper", false)
  else
    game.Compass.SetGatewayMarkerIsOpen("SM_550_Helper", true)
  end
end
function OnUpdate(level)
  if player:InsideZone(BridgeBreak_trigger) == true then
    bridgeToBreak:PlayAnimToEnd()
  end
  if oneshotCamRavineCollapse ~= nil then
    oneshotCamRavineCollapse:Update()
  end
  if oneShotCliffBreakStart ~= nil then
    oneShotCliffBreakStart:Update()
  end
  if oneShotCliffBreakEnd ~= nil then
    oneShotCliffBreakEnd:Update()
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_AboveFight_Stn550_LimitedCam") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_LimitedYaw_AboveFirstFight")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_Avalanche_Stn550_LimitedCam") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_Limited_65")
  end
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save(),
    bCrawlEntryCavedIn = bCrawlEntryCavedIn,
    bChasmCollapseDone = bChasmCollapseDone
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  bCrawlEntryCavedIn = savedInfo.bCrawlEntryCavedIn
  bChasmCollapseDone = savedInfo.bChasmCollapseDone
end
function BtrStn550WorstGodsDone()
  local LM = require("level.loadmonitor")
  LM.CreateLoadMonitor():AddCallback({
    Wads = {
      "Stn610_POIIntroCombat"
    },
    Functions = {
      function(wads)
        wads.Stn610_POIIntroCombat:CallScript("BtrWorstGodsDone")
      end
    }
  })
end
function Stn550_LoadCheck_ChiselJumpDown()
  game.UI.LoadCheck("Stn700_c360_ChiselSick")
end
function PlayShake(nameofeffect, duration, tweenin, tweenout)
  local effect = {
    EffectName = nameofeffect,
    Duration = duration,
    TweenInTime = tweenin,
    TweenOutTime = tweenout
  }
  game.FX.SubmitEffect(effect)
end
function PlayShake_FallingApart(delay, length)
  timers.StartLevelTimer(delay, function()
    PlayShake("FSE_SHAKE_TREMORS_LEVEL_3", length, 0.1, 2.3)
  end)
end
function ChasmCollapse()
  if not bChasmCollapseDone then
    bChasmCollapseDone = true
    DisableKratosInput()
    GameObjects.ChasmCollapse:HideEntityVolume()
    GameObjects.Stn550_ice_tower_01_break.Child:PlayAnimToEnd()
    CameraStartRavineCollapse()
    StopSoundAvalancheLoop()
    game.Audio.StartMusic("SND_MX_STN_chasm_climb_crumble")
    PlayShake_FallingApart(1, 6)
    timer.StartLevelTimer(3, function()
      GameObjects.Stn550_ice_tower_03_break.Child:PlayAnimToEnd()
    end)
    timer.StartLevelTimer(2, function()
      GameObjects.Stn550_ice_tower_02_break.Child:PlayAnimToEnd()
    end)
    timer.StartLevelTimer(4, function()
      GameObjects.Stn550_ice_tower_04_break.Child:PlayAnimToEnd()
    end)
    timer.StartLevelTimer(5, function()
      GameObjects.Stn550_ice_tower_05_break.Child:PlayAnimToEnd()
    end)
    timer.StartLevelTimer(7, function()
      GameObjects.CA_Point_Forward_Stn550_ChiselTip.LuaObjectScript.Enable()
    end)
    timer.StartLevelTimer(10, function()
      StartQuest_GetChiselTip()
    end)
    timer.StartLevelTimer(11, function()
      ShowCaveInCrawlExit()
      EnableKratosInput()
      BOOKMARK_14_Stonemason_070_ChasmIntro()
    end)
  end
end
function ShowCaveInCrawlExit()
  bCrawlEntryCavedIn = true
  GameObjects.CaveInCrawlExit:Show()
end
function StartQuest_GetChiselTip()
  LD.CompleteQuest("Quest_StoneMason_Objective375")
  game.Compass.SetDesignerForcedHide(false)
end
function BOOKMARK_14_Stonemason_070_ChasmIntro()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "14_Stonemason_070_ChasmIntro"]
  tableEntry.OverrideObject = GameObjects.CheckpointOverride_Stn550
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function IceFall()
  GameObjects.scripted_Col:Hide()
  timer.StartLevelTimer(0.4, function()
    LD.ShowFX(IceFall_ref)
  end)
  timer.StartLevelTimer(0.4, CameraStartCliffCrumble())
  timer.StartLevelTimer(0, function()
    CSL.PlayShake("FSE_SHAKE_GENERIC_LARGE", 1, 0, 0)
  end)
  timer.StartLevelTimer(0.4, function()
    CSL.PlayShake("FSE_SHAKE_GENERIC_LARGE", 1, 0, 0)
  end)
  timer.StartLevelTimer(1, function()
    CSL.PlayShake("FSE_SHAKE_GENERIC_GIANT", 2.5, 0, 0)
  end)
  timer.StartLevelTimer(0, function()
    CSL.PlayShake("FSE_SWAY_CLIFF_CRUMBLE_SWAY", 8, 0, 4)
  end)
  timer.StartLevelTimer(0, function()
    CSL.PlayShake("FSE_SHAKE_CLIFF_CRUMBLE", 8, 0, 2)
  end)
end
function Stn500CameraUpdates()
  if game.World.IsInsideCameraZone(player.Position, "CamZone_CClimb_ToChisel_010") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_Stn550_ChiselApproach")
  end
end
function SetBool_ExitCollapseCameraZone()
  print("CAMERA: SetBool_ExitCollapseCameraZone")
  bCamCollapseZone = true
end
function GetBool_ExitCollapseCameraZone()
  return bCamCollapseZone
end
function SetBool_CliffCollapseSurprise()
  print("CAMERA: SetBool_CliffCollapseSurprise")
  bSurpriseCliffCollapse = true
end
function GetBool_CliffCollapseSurprise()
  return bSurpriseCliffCollapse
end
function WakeRavineClimbJumpFWD()
  CWU.WakeUpTheRecenterZones("RCenter_WakeGroup_RavineJumpClimb_Fwd", camWakeUpLevel)
end
function OnExitFromClimbToCrawl3()
  LD.CompleteQuest("Quest_StoneMason_Objective400")
end
function DisableKratosInput()
  pad:DisableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickX)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickY)
end
function EnableKratosInput()
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
  pad:EnableGameButton(tweaks.ePad.kPadSquare)
  pad:EnableGameButton(tweaks.ePad.kPadTriangle)
  pad:EnableGameButton(tweaks.ePad.kPadCross)
  pad:EnableGameButton(tweaks.ePad.kPadL1)
  pad:EnableGameButton(tweaks.ePad.kPadL2)
  pad:EnableGameButton(tweaks.ePad.kPadL3)
  pad:EnableGameButton(tweaks.ePad.kPadR1)
  pad:EnableGameButton(tweaks.ePad.kPadR2)
  pad:EnableGameButton(tweaks.ePad.kPadR3)
  pad:EnableGameButton(tweaks.ePad.kPadRight)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickX)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickY)
end
function CameraStartRavineCollapse()
  oneshotCamRavineCollapse = CCOS.OneShotCamera.New("PLYR_Vista_Stn550_Ravine_Reveal", 8, nil)
  oneshotCamRavineCollapse:Start()
  oneshotCamRavineCollapse:SetCallback(DestroyRavineCamera)
  player:SetMaxSpeedOverride(1.5)
  timer.StartLevelTimer(7.5, function()
    player:ClearMaxSpeedOverride()
  end)
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 6,
    TweenIn = {Time = 2},
    TweenOut = {Time = 3.5}
  })
  timer.StartLevelTimer(3, function()
    game.Blender.Trigger({
      Priority = 3,
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 0.5,
      TweenIn = {Time = 0.1},
      TweenOut = {Time = 1}
    })
  end)
end
function CameraStartCliffCrumble()
  oneShotCliffBreakStart = CCOS.OneShotCamera.New("PLYR_CrackClimb_Vista_CliffBreak_Start", 2.2, nil)
  oneShotCliffBreakEnd = CCOS.OneShotCamera.New("PLYR_CrackClimb_Vista_CliffBreak_End", 7.2, nil)
  oneShotCliffBreakStart:Start()
  oneShotCliffBreakEnd:Start()
  oneShotCliffBreakEnd:SetCallback(DestroyCliffCameras)
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 3,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 6.4}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 3,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 6.4}
  })
  timer.StartLevelTimer(0.25, function()
    game.Blender.Trigger({
      Priority = 10,
      Name = "FSE_SHAKE_GENERIC_GIANT",
      Duration = 2,
      TweenIn = {Time = 0},
      TweenOut = {Time = 1}
    })
  end)
  timer.StartLevelTimer(1, function()
    game.Blender.Trigger({
      Priority = 3,
      Name = "FFB_GENERIC_RUMBLE_STRONG",
      Duration = 0.5,
      TweenIn = {Time = 0.1},
      TweenOut = {Time = 0}
    })
  end)
  timer.StartLevelTimer(3, function()
    game.Blender.Trigger({
      Priority = 4,
      Name = "FFB_GENERIC_RUMBLE_STRONG",
      Duration = 0.5,
      TweenIn = {Time = 0.1},
      TweenOut = {Time = 1}
    })
  end)
  timer.StartLevelTimer(5, function()
    game.Blender.Trigger({
      Priority = 5,
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 0.8,
      TweenIn = {Time = 0.1},
      TweenOut = {Time = 0}
    })
  end)
  timer.StartLevelTimer(7.53, function()
    game.Blender.Trigger({
      Priority = 8,
      Name = "FSE_SHAKE_GENERIC_MEDIUM",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.2}
    })
  end)
end
function DestroyRavineCamera()
  oneshotCamRavineCollapse = nil
end
function DestroyCliffCameras()
  oneShotCliffBreakStart = nil
  oneShotCliffBreakEnd = nil
end
local Stn500Ref, SNDBridgeBreak
function StopSoundAvalancheLoop()
  CallFunctionOnStn500Ref("StopSoundAvalancheLoop")
end
function CallFunctionOnStn500Ref(funcString)
  if Stn500Ref == nil then
    Stn500Ref = game.FindLevel("Stn500_ImpactSite")
  end
  if Stn500Ref == nil then
    return
  else
    Stn500Ref:CallScript(funcString)
  end
end
function SoundInit()
  SNDBridgeBreak = bridgeToBreak:FindSingleSoundEmitterByName("SNDPlatformBreak")
end
function PlaySoundBridgeBreak()
  if bridgeBroken == false then
    LD.PlaySoundOnFrame(SNDBridgeBreak, bridgeToBreak, "SND_MECH_Stone_Mason_Wood_Plank_Collapse", 0, "Forward")
    bridgeBroken = true
  end
end
