local LD = require("design.LevelDesignLibrary")
local collisionCheck = require("camera.collisioncheck")
local timers = require("level.timer")
local thisObj
local btrPlayedTab = {
  candelabrum = false,
  delay = false,
  shatter = false,
  forgotMiddle = false,
  forgotRight = false,
  shatterCombat = false,
  bFirstHitDone = nil,
  bCrashDone = nil
}
local bBtrZoneIn = false
local HudToggle = true
local penDepth = 0.5
local verticalP = 0
local horizontalP = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnFirstStart(level)
  GameObjects.BtrZone_CrashingTheParty:HideEntityVolume()
end
function OnUpdate(level, obj)
  if bBtrZoneIn == true and not btrPlayedTab.candelabrum and not btrPlayedTab.bFirstHitDone and btrPlayedTab.bCrashDone == true then
    if collisionCheck.isTargetInFrustumUnobstructed(GameObjects.BtrMarker_CrashingTheParty:GetWorldPosition(), horizontalP, verticalP, penDepth, HudToggle) then
      btrPlayedTab.candelabrum = true
      PlayCandelabrum()
      game.SubObject.Sleep(thisObj)
    end
  elseif btrPlayedTab.bFirstHitDone then
    game.SubObject.Sleep(thisObj)
  end
end
function OnSaveCheckpoint(level, obj)
  return {played = btrPlayedTab}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  btrPlayedTab = savedInfo.played
end
function WorstGodsDone()
  GameObjects.BtrZone_CrashingTheParty:ShowEntityVolume()
  game.SubObject.Wake(thisObj)
end
function FirstHitDone()
  btrPlayedTab.bFirstHitDone = true
end
function BtrZone_In()
  bBtrZoneIn = true
end
function BtrZone_Out()
  bBtrZoneIn = false
end
function PlayCrashingTheParty()
  game.Audio.PlayBanter("stn_CrashingTheParty", SetCrashDone)
end
function SetCrashDone()
  btrPlayedTab.bCrashDone = true
end
function PlayCandelabrum()
  game.Audio.PlayBanter("stn_CrashingTheParty_Candela")
end
function PlaySwingSmash()
  timers.StartLevelTimer(2, function()
    game.Audio.PlayBanter("stn_CrashingTheParty_SwingSmash")
  end)
  timers.StartLevelTimer(20, PlayDelay)
end
function PlayDelay()
  if not btrPlayedTab.delay then
    game.Audio.PlayBanter("stn_CrashingTheParty_Delay")
    btrPlayedTab.delay = true
  end
end
function PreventDelayBtr()
  btrPlayedTab.delay = true
end
function PlayShatter()
  game.Audio.PlayBanter("stn_CrashingTheParty_Shatter")
  btrPlayedTab.shatter = true
end
function PlayForgotMiddleShatter()
  if not btrPlayedTab.forgotMiddle then
    game.Audio.PlayBanter("stn_CrashingTheParty_ForgotMiddleShatter")
    btrPlayedTab.forgotMiddle = true
  end
end
function PlayForgotRightShatter()
  if not btrPlayedTab.forgotRight then
    game.Audio.PlayBanter("stn_CrashingTheParty_ForgotRightShatter")
    btrPlayedTab.forgotRight = true
  end
end
function PlayShatterCombat()
  if not btrPlayedTab.shatterCombat then
    game.Audio.PlayBanter("stn_CrashingTheParty_ShatterCombat")
    btrPlayedTab.shatterCombat = true
  end
end
function MiddleShattered()
  btrPlayedTab.forgotMiddle = true
end
function RightShattered()
  btrPlayedTab.forgotRight = true
end
