local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local LM = require("level.loadmonitor")
local sindriSpawnObject, bSindriSpawned
function Stn600_Bookmark_UnlockChiselDoor()
  GameObjects.ChiselDoor_StoneMason:DestroyDoor()
end
function OnScriptLoaded(level)
  sindriSpawnObject = GameObjects.SmallShop.Child:FindSingleGOByName("VendorSpawner").Child
  LD.HideFX(GameObjects.ChanderlierIceBlocker)
end
function OnFirstStart()
  GameObjects.TraverseLink_3m_Up_Stn600:HideTraverseLink()
  VibrateSpawnerCheck()
end
function OnStart()
  VibrateSpawnerCheck()
  GameObjects.EntityZoneEvents_Return_Stn600.LuaObjectScript.Disable()
  if bSindriSpawned == true then
    sindriSpawnObject.LuaObjectScript.SpawnEnemy()
  end
  if game.Wallets.HasResource("HERO", "ChiselUnlock") then
    game.Compass.SetGatewayMarkerIsOpen("SM_600_Helper", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("SM_600_Helper", false)
  end
end
local warpData
function ChiselBugFixup()
  local completedCine = game.Level.GetVariable("CompletedCineNumber")
  local cineNumber_MagniModiFight = 358
  if completedCine < cineNumber_MagniModiFight then
    if game.Wallets.HasResource("HERO", "ChiselUnlock") then
      game.Wallets.RemoveResource("HERO", "ChiselUnlock", 1)
    end
    if warpData == nil then
      warpData = {}
    end
    local warpReferenceObj = GameObjects.ChiselFixup_WarpLocation.Child
    warpData.playerPos = warpReferenceObj:GetWorldJointPosition(warpReferenceObj:GetJointIndex("kratos"))
    warpData.playerDir = warpReferenceObj:GetWorldJointForward(warpReferenceObj:GetJointIndex("kratos"))
    warpData.sonPos = warpReferenceObj:GetWorldJointPosition(warpReferenceObj:GetJointIndex("son"))
    warpData.sonDir = warpReferenceObj:GetWorldJointForward(warpReferenceObj:GetJointIndex("son"))
  end
end
function OnUpdate(level)
  if warpData ~= nil then
    game.UI.LoadCheck("Stn550_ChasmClimb")
    local player = game.Player.FindPlayer()
    local son = game.AI.FindSon()
    player:Warp(warpData.playerPos, warpData.playerDir)
    if son ~= nil and son:IsAvailableInLevel() then
      son:Warp(warpData.sonPos, warpData.sonDir)
    end
    game.World.StoreCheckpoint()
    warpData = nil
  end
end
function BreakChandelierIceBlocker()
  LD.ShowFX(GameObjects.ChanderlierIceBlocker)
end
function VibrateSpawnerCheck()
  if LD.GetEntityVariable("CompletedCineNumber") >= 360 then
    GameObjects.Stn600_throwableCrystalSpawner0:Show()
    timer.StartLevelTimer(1, function()
      EnableCrystalSpawner()
    end)
  else
    DisableCrystalSpawner()
  end
end
function EnableCrystalSpawner()
  GameObjects.Stn600_throwableCrystalSpawner0.LuaObjectScript.InteractEnable()
end
function ShowCrystalSpawner()
  GameObjects.Stn600_throwableCrystalSpawner0:Show()
end
function DisableCrystalSpawner()
  print("attempign to disable spawner")
  GameObjects.Stn600_throwableCrystalSpawner0:Hide()
  GameObjects.Stn600_throwableCrystalSpawner0.LuaObjectScript.InteractDisable()
end
function OnSaveCheckpoint(level)
  return {bSindriSpawned = bSindriSpawned}
end
function OnRestoreCheckpoint(level, savedInfo)
  bSindriSpawned = savedInfo.bSindriSpawned
end
function LoadCheck_Stn800_Stn600()
  game.UI.LoadCheck("Stn660_POIReturnCombat", "Stn750_ReturnHallway")
end
function LoadCheck_Stn600_Stn800()
  game.UI.LoadCheck("Stn800_Shortcut")
end
function EnableSmallShopStn600()
  if bSindriSpawned ~= true then
    sindriSpawnObject.LuaObjectScript.SpawnEnemy()
    bSindriSpawned = true
  end
end
function LockEntranceDoor()
  GameObjects.Stn600_SpreadDoor_StoneMason.LuaObjectScript.Lock()
end
function UnlockEntranceDoor()
  GameObjects.Stn600_SpreadDoor_StoneMason.LuaObjectScript.Unlock()
end
function Entrance_Door_Side_A()
  Stn610_Enable_LTW_Stn610_BanquetTable()
  GameObjects.LTW_Stn600_ExitChasmRoom.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Stn550.LuaObjectScript.Disable()
end
function Entrance_Door_Side_B()
  Stn610_Disable_LTW_Stn610_BanquetTable()
  GameObjects.CA_SyncExitHelper_Stn600_ChasmRoomExit.LuaObjectScript.Enable()
  GameObjects.LTW_Stn600_ExitChasmRoom.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Stn550.LuaObjectScript.Enable()
end
function Stn610_Enable_LTW_Stn610_BanquetTable()
  game.UI.LoadCheck("Stn610_POIIntroCombat")
  local stn610_Monitor = LM.CreateLoadMonitor()
  stn610_Monitor:AddCallback({
    Wads = {
      "Stn610_POIIntroCombat"
    },
    Functions = {
      function(wads)
        wads.Stn610_POIIntroCombat:CallScript("Enable_LTW_Stn610_BanquetTable")
      end
    }
  })
end
function Stn610_Disable_LTW_Stn610_BanquetTable()
  local stn610 = game.FindLevel("Stn610_POIIntroCombat")
  stn610:CallScript("Disable_LTW_Stn610_BanquetTable")
end
function EnableMantle()
  GameObjects.TraverseLink_3m_Up_Stn600:ShowTraverseLink()
end
function EnableRopeDrop_Stn600()
  GameObjects.RopeDrop_Stn600.LuaObjectScript.EnablePlayerInteract()
end
function HideRopeDropColl_Stn600()
  GameObjects.Col_ChainDrop_Stn600:Hide()
end
function AreaAnnounce_Stn600_Enter()
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_DiscoverLocation("Banquet Hall")
end
function EnableAreaAnnounceReturnTrig()
  GameObjects.EntityZoneEvents_Return_Stn600.LuaObjectScript.Enable()
  GameObjects.CA_Stn600_IdleBehavior_ChiselDoor.LuaObjectScript.Enable()
end
function AreaAnnounce_Stn600_Return()
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_DiscoverLocation("Banquet Hall")
end
function EnableStn800LTW()
  local stn800 = game.FindLevel("Stn800_Shortcut")
  if stn800 ~= nil then
    stn800:CallScript("Enable_LTW_Stn800")
  end
end
function DisableStn800LTW()
  local stn800 = game.FindLevel("Stn800_Shortcut")
  if stn800 ~= nil then
    stn800:CallScript("Disable_LTW_Stn800")
  end
end
function DisableShopBanter()
  GameObjects.SmallShop.LuaObjectScript.EnableCinematicTriggerTalkInteract()
end
function EnableShopBanter()
  GameObjects.SmallShop.LuaObjectScript.DisableCinematicTriggerTalkInteract()
end
