local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local color = require("core.color")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local CCOS = require("camera.camera_oneshot")
local CSL = require("camera.shakelibrary")
local bReEntered, debugText, Encounter66, Encounter67, Encounter68
local wallLeft_hits = 0
local wallCenter_hits = 0
local wallRight_hits = 0
local iceBreaks = 0
local vibrateCount = 0
local isSwinging03 = false
local enableWreckingDamage = false
local animMonitor03, Enemy_HealthMonitor
local SectionBBroken = false
local chanderlierDestroyed = false
local bTableDestroyed, EntryZoneMonitor, entryZone
local trolInsideZone = false
local playerInsideZone = false
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
local chand, ChandelierPristine, ChandelierBroken, CrystalRocket, bChandStage2Done, oneShotEncounterZoom, bLeftCbtDone, bMidCbtDone, bRightCbtDone
thisLevel = nil
stn600 = nil
thisObj = nil
player = nil
local Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, Area_1_Encounter_4, Area_1_Encounter_5
function OnScriptLoaded(level, obj)
  player = game.Player:FindPlayer()
  thisLevel = level
  thisObj = obj
  stn600 = game.FindLevel("Stn600_ChasmRoom")
  chand = GameObjects.masonchandlier00.Child
  ChandelierPristine = GameObjects.masonchandlier00:FindSingleGOByName("chandlierBaseMesh")
  ChandelierBroken = GameObjects.masonchandlier00:FindSingleGOByName("chandlierBaseMesh_broken")
  CrystalRocket = GameObjects.Crystal_Rocket
  Frozen_Area_1_Fight_1()
  Frozen_Area_1_Fight_2()
  SoundInit()
  LD.HideFX(GameObjects.IceWallA)
  LD.HideFX(GameObjects.IceWallB)
  LD.HideFX(GameObjects.IceWallC)
  LD.HideFX(GameObjects.ChandelierExplosionFx1)
  LD.HideFX(GameObjects.ChandelierExplosionFx2)
end
function OnFirstStart(level)
  chand:PlayAnimationCycle({
    Animation = "envChandlier_State0Idle"
  })
  ChandelierBroken:Hide()
  CrystalRocket:Hide()
  GameObjects.STN_610_NOGO_01:Hide()
  GameObjects.LetsOver_A:HideCollision()
  GameObjects.LetsOver_B:HideCollision()
  GameObjects.LetsOver_C:HideCollision()
  GameObjects.Stn610pntLite5:Hide()
  VibrateSpawnerCheck610()
  GameObjects.EZ_Stn610_CrystalStumpApproach:HideEntityVolume()
end
function OnStart(level, obj)
  if bChandStage2Done == true then
    GameObjects.vibrateDetector_Brk_B2_Anim:PlayAnimToEnd()
  end
  if not bTableDestroyed then
    GameObjects.HealthRune_Large_Table.LuaObjectScript.Disable()
  else
    GameObjects.Breakable_Table:Hide()
  end
  if Area_1_Encounter_2:WasRunning() then
    Area_1_Encounter_2:Start()
  end
  if Area_1_Encounter_3:WasRunning() then
    Area_1_Encounter_3:Start()
    timer.StartLevelTimer(0.03, SpawnTroll)
  end
  if Area_1_Encounter_4:WasRunning() then
    Area_1_Encounter_4:Start()
  end
  VibrateSpawnerCheck610()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    vibrateCount = vibrateCount,
    bChandStage2Done = bChandStage2Done,
    bLeftCbtDone = bLeftCbtDone,
    bMidCbtDone = bMidCbtDone,
    bRightCbtDone = bRightCbtDone,
    bTableDestroyed = bTableDestroyed,
    iceBreaks = iceBreaks,
    bReEntered = bReEntered
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  vibrateCount = savedInfo.vibrateCount
  bChandStage2Done = savedInfo.bChandStage2Done
  bLeftCbtDone = savedInfo.bLeftCbtDone
  bMidCbtDone = savedInfo.bMidCbtDone
  bRightCbtDone = savedInfo.bRightCbtDone
  bTableDestroyed = savedInfo.bTableDestroyed
  iceBreaks = savedInfo.iceBreaks
  bReEntered = savedInfo.bReEntered
end
function BtrWorstGodsDone()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.WorstGodsDone()
end
function BtrFirstHitDone()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.FirstHitDone()
end
function Enable_LTW_Stn610_BanquetTable()
  if not bReEntered then
    GameObjects.LTW_Stn610_BanquetTable.LuaObjectScript.Enable()
  else
    GameObjects.LTW_Stn610_ReEntry.LuaObjectScript.Enable()
    ReEntry_SetupSonNav()
  end
end
function Disable_LTW_Stn610_BanquetTable()
  if not bReEntered then
    bReEntered = true
  end
  if vibrateCount == 0 then
    GameObjects.LTW_Stn610_BanquetTable.LuaObjectScript.Disable()
  else
    GameObjects.LTW_Stn610_ReEntry.LuaObjectScript.Disable()
  end
end
function ReEntry_SetupSonNav()
  timer.StartLevelTimer(4, function()
    if vibrateCount == 0 then
      GameObjects.CA_Stn610_LookUpAtChand_1.LuaObjectScript.Enable()
    elseif vibrateCount == 1 then
      GameObjects.CA_observe_on_alert_Stn610_CP2.LuaObjectScript.Enable()
    elseif vibrateCount == 2 then
      GameObjects.CA_observe_on_alert_Stn610_CP3.LuaObjectScript.Enable()
    elseif vibrateCount == 3 then
      GameObjects.CA_ShieldEyes_Stn610_Crystal.LuaObjectScript.Enable()
    end
  end)
end
function ShakeRumble()
  game.FX.SubmitEffect(camShakeLarge)
  game.FX.SubmitEffect(ForceFeedbackRumble)
end
function StuckInIce03()
  if SectionBBroken == false then
    PlayChandelierAttachSound()
  end
end
function BreakSection_B()
  GameObjects.vibrateDetector_Brk_B2_Anim:PlayAnimToEnd()
  bChandStage2Done = true
end
function DestroySection_A()
  CSL.PlayDefaultShake("ShakeRumbleLarge", 0.69, 0, 0.8)
  iceBreaks = iceBreaks + 1
  LD.ShowFX(GameObjects.IceWallA)
  GameObjects.IceWallA_cracks:Hide()
  PlaySoundIceBreak(1)
  GameObjects.Pristine_A:HideCollision()
  GameObjects.LetsOver_A:ShowCollision()
  GameObjects.frozen_draugrs_left:Hide()
  GameObjects.STN_610_NOGO_01:Hide()
  Area_1_Encounter_2:Start()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PreventDelayBtr()
  MusicDestroyAWulverIn()
  GameObjects.EEE_Stn610_IceWall_Left.LuaObjectScript.Trigger()
  IceBreakTracker()
end
function DestroySection_B()
  CSL.PlayDefaultShake("ShakeRumbleLarge", 0.69, 0, 0.8)
  iceBreaks = iceBreaks + 1
  LD.ShowFX(GameObjects.IceWallB)
  GameObjects.IceWallB_cracks:Hide()
  PlaySoundIceBreak(2)
  GameObjects.Pristine_B:HideCollision()
  GameObjects.LetsOver_B:ShowCollision()
  Area_1_Encounter_3:Start()
  GameObjects.STN_610_NOGO_01:Hide()
  GameObjects.frozen_troll:Hide()
  timer.StartLevelTimer(0.03, SpawnTroll)
  CameraEncounterZoom()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PreventDelayBtr()
  MusicDestroyBTrollIn()
  GameObjects.EEE_Stn610_IceWall_Center.LuaObjectScript.Trigger()
  IceBreakTracker()
end
function DestroySection_C()
  CSL.PlayDefaultShake("ShakeRumbleLarge", 0.69, 0, 0.8)
  iceBreaks = iceBreaks + 1
  LD.ShowFX(GameObjects.IceWallC)
  GameObjects.IceWallC_cracks:Hide()
  PlaySoundIceBreak(3)
  GameObjects.Pristine_C:HideCollision()
  GameObjects.LetsOver_C:ShowCollision()
  GameObjects.STN_610_NOGO_01:Show()
  GameObjects.frozen_draugrs_right:Hide()
  Area_1_Encounter_4:Start()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PreventDelayBtr()
  MusicDestroyCJotunnIn()
  GameObjects.EEE_Stn610_IceWall_Right.LuaObjectScript.Trigger()
  IceBreakTracker()
end
function IceBreakTracker()
  if iceBreaks == 3 then
    GameObjects.ChanderlierIceBlocker1.Child:PlayAnimToEnd()
  end
end
function Stn600_EnableMantle()
  local stn600 = game.FindLevel("Stn600_ChasmRoom")
  stn600:CallScript("EnableMantle")
end
function Vibrate()
  print("Vibrate()")
  if isSwinging03 == true then
    PlayChandelierDetachSound()
  end
end
function Pause01()
  chand:PlayAnimationCycle({
    Animation = "envChandlier_State1Idle"
  })
end
function Pause02()
  chand:PlayAnimationCycle({
    Animation = "envChandlier_State2Idle"
  })
end
function FreePendulum()
  print("FreePendulum()")
  vibrateCount = vibrateCount + 1
  if vibrateCount == 1 then
    print("vibrateCount == 1")
    BtrFirstHitDone()
    Stn600_BreakChandelierIceBlocker()
    chand:PlayAnimationToEnd({
      Animation = "envChandlier_State1Enter"
    })
    chand:OnAnimationDone(thisLevel, "Pause01", {Force = true})
    GameObjects.EEE_Stn610_ChandFree.LuaObjectScript.Trigger()
    ClearSonContext()
    timer.StartLevelTimer(0.3, BreakTable)
    timer.StartLevelTimer(0.75, function()
      GameObjects.HealthRune_Large_Table.LuaObjectScript.Enable()
    end)
    bTableDestroyed = true
    PlayChandelierBreakout()
    PlayChandelierAttachSoundOnFrame(2, 49)
    timer.StartLevelTimer(1.25, function()
      GameObjects.ChandelierConcussionFx1:PlayAnimToEnd()
    end)
    GameObjects.CA_Stn610_LookUpAtChand_1.LuaObjectScript.Disable()
    GameObjects.CA_Stn610_LookAtTable.LuaObjectScript.Disable()
    GameObjects.CA_Stn610_LookUpAtIce1.LuaObjectScript.Disable()
    GameObjects.LTW_Stn610_BanquetTable.LuaObjectScript.Disable()
    GameObjects.CA_Stn610_LookUpAtChand_1.LuaObjectScript.Disable()
    timer.StartLevelTimer(3, function()
      GameObjects.CA_observe_on_alert_Stn610_CP2.LuaObjectScript.Enable()
    end)
    CSL.PlayDefaultShake("ShakeRumbleLarge", 0.96, 0, 0.3)
    timer.StartLevelTimer(1.55, function()
      CSL.PlayDefaultShake("ShakeRumbleGiant", 0.45, 0.1, 0.6)
    end)
  elseif vibrateCount == 2 then
    chand:PlayAnimationToEnd({
      Animation = "envChandlier_State2Enter"
    })
    chand:OnAnimationDone(thisLevel, "Pause02", {Force = true})
    LD.ShowFX(GameObjects.ChandelierExplosionFx1)
    GameObjects.EEE_Stn610_ChandStage2.LuaObjectScript.Trigger()
    ClearSonContext()
    timer.StartLevelTimer(1.75, function()
      GameObjects.ChandelierConcussionFx2:PlayAnimToEnd()
    end)
    GameObjects.IceWallA_cracks:PlayAnimToEnd()
    GameObjects.IceWallB_cracks:PlayAnimToEnd()
    GameObjects.IceWallC_cracks:PlayAnimToEnd()
    PlayChandelierDetachSound(2)
    PlayChandelierAttachSoundOnFrame(5, 64)
    GameObjects.CA_observe_on_alert_Stn610_CP2.LuaObjectScript.Disable()
    GameObjects.CA_observe_on_alert_Stn610_CP3.LuaObjectScript.Enable()
    CSL.PlayDefaultShake("ShakeRumbleLarge", 0.96, 0, 0.3)
    timer.StartLevelTimer(1.77, function()
      CSL.PlayDefaultShake("ShakeRumbleSmall", 0.45, 0.1, 0.6)
    end)
  elseif vibrateCount == 3 then
    print("vibrateCount == 3")
    GameObjects.EEE_Stn610_ChandStage3.LuaObjectScript.Trigger()
    ClearSonContext()
    chand:PlayAnimationToEnd({
      Animation = "envChandlier_State2React"
    })
    LD.ShowFX(GameObjects.ChandelierExplosionFx2)
    GameObjects.masonChandlier00:FindSingleGOByName("Stn610pntLite4"):Hide()
    GameObjects.masonChandlier00:FindSingleGOByName("BifrostVibrate_Intact").LuaObjectScript.Deactivate()
    GameObjects.masonChandlier00:FindSingleGOByName("BifrostVibrate_Intact"):Hide()
    ChandelierPristine:Hide()
    ChandelierBroken:Show()
    CrystalRocket:Show()
    LD.ShowFX(CrystalRocket)
    timer.StartLevelTimer(1, function()
      CrystalRocketSequence()
    end)
    CSL.PlayDefaultShake("ShakeRumbleLarge", 0.96, 0, 0.3)
    PlayChandelierAttachSoundOnFrame(5, 19)
    local crystalRocketSoundEmitter = GameObjects.Crystal_Rocket_Mesh.SoundEmitters[1]
    LD.PlaySoundOnFrame(crystalRocketSoundEmitter, chand, "SND_WPN_Bifrost_Bomb_Hit_Surface", 7, "forward")
    LD.PlaySoundOnFrame(crystalRocketSoundEmitter, chand, "SND_WPN_Bifrost_Bomb_Throw_Hit_Latch", 7, "forward")
  end
end
function Stn600_LockEntranceDoor()
  local stn600 = game.FindLevel("Stn600_ChasmRoom")
  stn600:CallScript("LockEntranceDoor")
end
function Stn600_UnlockEntranceDoor()
  local stn600 = game.FindLevel("Stn600_ChasmRoom")
  stn600:CallScript("UnlockEntranceDoor")
end
function Stn600_BreakChandelierIceBlocker()
  if stn600 ~= nil then
    stn600:CallScript("BreakChandelierIceBlocker")
  end
end
function CrystalRocketSequence()
  local stn600 = game.FindLevel("Stn600_ChasmRoom")
  GameObjects.Stn610pntLite5:Show()
  if stn600 ~= nil then
    stn600:CallScript("ShowCrystalSpawner")
  end
  GameObjects.CA_observe_on_alert_Stn610_CP3.LuaObjectScript.Interrupt()
  GameObjects.CA_observe_on_alert_Stn610_CP3.LuaObjectScript.Disable()
  GameObjects.CA_ShieldEyes_Stn610_Crystal.LuaObjectScript.Enable()
  GameObjects.EZ_Stn610_CrystalStumpApproach:ShowEntityVolume()
  timer.StartLevelTimer(2, Enable600Spawner)
end
function VibrateSpawnerCheck610()
  local stn600 = game.FindLevel("Stn600_ChasmRoom")
  if stn600 ~= nil then
    if 3 <= vibrateCount or LD.GetEntityVariable("CompletedCineNumber") >= 360 then
      stn600:CallScript("ShowCrystalSpawner")
      timer.StartLevelTimer(1, Enable600Spawner)
    else
      stn600:CallScript("DisableCrystalSpawner")
    end
  end
end
function Enable600Spawner()
  stn600:CallScript("EnableCrystalSpawner")
end
function ApproachSpawner()
  GameObjects.CA_ShieldEyes_Stn610_Crystal.LuaObjectScript.Disable()
  GameObjects.CA_observe_on_alert_Stn610_Ice.LuaObjectScript.Enable()
end
function ApproachSpawnerRepeat()
  if bLeftCbtDone ~= true or bMidCbtDone ~= true or bRightCbtDone ~= true then
    Stn600_LockEntranceDoor()
  end
end
function ClearSonContext()
  timer.StartLevelTimer(3, function()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
  end)
end
function BreakTable()
  GameObjects.CA_Stone_Banquet.LuaObjectScript.Disable()
  CSL.PlayDefaultShake("ShakeRumbleSmall", 1, 0, 0.2)
  timer.StartLevelTimer(0.7, function()
    CSL.PlayDefaultShake("ShakeRumbleSmall", 1.2, 0.3, 0.3)
  end)
  GameObjects.Breakable_Table:PlayAnimToEnd()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PlaySwingSmash()
  LD.PlaySound(GameObjects.SNDGrpBrkBanquetTable.SoundEmitters[1], "SND_BRK_Wood_Table_ChasmRoom")
end
function SpawnTroll()
  for _, go in ipairs(thisLevel:FindGameObjectsByMarker("FrozenTrollMarker")) do
    go:TriggerMoveEvent("kLESpawnIceBreak")
  end
end
function Frozen_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Ground Enemies", {
    CheckpointOnComplete = true,
    spawnWad = "Stn610_POIIntroCombat"
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Helwalkers_N_SDBR",
      spawnLocators = "A1_Loc_C_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Helwalkers_N_SDBR",
      spawnLocators = "A1_Loc_C_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Helwalkers_N_SDBR",
      spawnLocators = "A1_Loc_C_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_1:OnEnemySpawn(function(enemy)
    timer.StartLevelTimer(1, function()
      enemy:TriggerMoveEvent("kLEAlert")
    end)
  end, {count = 1})
  Area_1_Encounter_1:OnEnemySpawn(function(enemy)
    timer.StartLevelTimer(3, function()
      enemy:TriggerMoveEvent("kLEAlert")
    end)
  end, {count = 2})
  Area_1_Encounter_1:OnEnemySpawn(function(enemy)
    timer.StartLevelTimer(5, function()
      enemy:TriggerMoveEvent("kLEAlert")
    end)
  end, {count = 3})
end
function Frozen_Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Frozen 1", {
    CheckpointOnComplete = true,
    spawnWad = "Stn610_POIIntroCombat",
    LeashZone = "LshZn_Stn610"
  })
  Area_1_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Wulver_P_SFA",
      spawnLocators = "A1_Loc_Left_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = 2
    },
    {
      spawners = "Wulver_N_SFA",
      spawnLocators = "A1_Loc_Left_U_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.75,
      powerLevel = 3
    },
    {
      spawners = "Wulver_N_SFA",
      spawnLocators = "A1_Loc_Left_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 3
    }
  })
  Area_1_Encounter_2:OnStart(Stn600_LockEntranceDoor)
  Area_1_Encounter_2:OnComplete(function()
    Area_1_Encounter_2:SetComplete()
    Area_1_Encounter_2:Stop()
  end, 1)
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Frozen 2 Troll", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Stn611"
  })
  Area_1_Encounter_3:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Troll_SB",
      markerID = "FrozenTrollMarker",
      spawnWad = "Stn610_POIIntroCombat",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3,
      powerLevel = 3
    }
  })
  Area_1_Encounter_3:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Wolf_F_SFA",
      spawnWad = "Stn610_POIIntroCombat",
      spawnLocators = "A1_Loc_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.5, 2},
      powerLevel = 3
    }
  })
  Area_1_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Wolf_F_SFA",
      spawnWad = "Stn610_POIIntroCombat",
      spawnLocators = "A1_Loc_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.5, 3},
      powerLevel = 3
    }
  })
  Area_1_Encounter_3:OnStart(Stn600_LockEntranceDoor)
  Area_1_Encounter_3:OnEnemySpawn(Troll_Health_Monitor, {
    markerID = "FrozenTrollMarker"
  })
  Area_1_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Frozen 3", {
    CheckpointOnComplete = true,
    spawnWad = "Stn610_POIIntroCombat",
    LeashZone = "LshZn_Stn610"
  })
  Area_1_Encounter_4:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Jotunn_J_SFA",
      markerID = "FrozenJotunnMarker",
      spawnLocators = "A1_Loc_Right_U_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyer_I_SABU",
      spawnLocators = "A1_Loc_Open_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.1,
      initialSpawnCooldown = 0.25
    },
    {
      spawners = "Flyer_F_SABU",
      spawnLocators = "A1_Loc_Open_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.5,
      initialSpawnCooldown = 0
    },
    {
      spawners = "Flyer_I_SABF",
      spawnLocators = "A1_Loc_Open_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.5
    }
  })
  Area_1_Encounter_4:OnStart(Stn600_LockEntranceDoor)
  Area_1_Encounter_2:OnComplete(LeftEncounterDone)
  Area_1_Encounter_3:OnComplete(MiddleEncounterDone)
  Area_1_Encounter_4:OnComplete(RightEncounterDone)
end
function LeftEncounterDone()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PlayShatter()
  bLeftCbtDone = true
  CheckEncountersCompleted()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Speed")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Power")
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  MusicDestroyAWulverOut()
end
function MiddleEncounterDone()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PlayShatterCombat()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.MiddleShattered()
  MusicDestroyBTrollOut()
  bMidCbtDone = true
  CheckEncountersCompleted()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Stonebeard_King")
  game.AI.FindSon():CallScript("ClearBehaviorContext")
end
function RightEncounterDone()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.PlayShatterCombat()
  GameObjects.Btr_CrashingTheParty.LuaObjectScript.RightShattered()
  bRightCbtDone = true
  CheckEncountersCompleted()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ogre_Charger")
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  MusicCheckRightEncounter()
end
function CheckEncountersCompleted()
  if bLeftCbtDone and bMidCbtDone and bRightCbtDone then
    GameObjects.CA_observe_on_alert_Stn610_Ice.LuaObjectScript.Disable()
    Stn600_EnableMantle()
    Stn600_UnlockEntranceDoor()
  end
end
local SNDChandelier
local soundIceEmitters = {}
function SoundInit()
  SNDChandelier = chand:FindSingleSoundEmitterByName("SNDChandelier")
  soundIceEmitters[1] = GameObjects.SNDIceEmitters:FindSingleSoundEmitterByName("SNDIceBreak1")
  soundIceEmitters[2] = GameObjects.SNDIceEmitters:FindSingleSoundEmitterByName("SNDIceBreak2")
  soundIceEmitters[3] = GameObjects.SNDIceEmitters:FindSingleSoundEmitterByName("SNDIceBreak3")
  soundIceEmitters[4] = GameObjects.SNDIceEmitters:FindSingleSoundEmitterByName("SNDIceBreak4")
  soundIceEmitters[5] = GameObjects.SNDIceEmitters:FindSingleSoundEmitterByName("SNDIceBreak5")
end
function PlayChandelierBreakout()
  PlayChandelierSwingSound()
  LD.PlaySound(soundIceEmitters[4], "SND_MECH_Chandelier_Breakout_Stn600")
  LD.PlaySound(soundIceEmitters[4], "SND_BRK_Ice_Explo_Blast_Wall_Open")
end
function PlayChandelierAttachSound(dest)
  LD.PlaySound(soundIceEmitters[dest], "SND_MECH_Chandelier_Attach_Stn600")
end
function PlayChandelierAttachSoundOnFrame(dest, count)
  LD.PlaySoundOnFrame(soundIceEmitters[dest], chand, "SND_MECH_Chandelier_Attach_Stn600", count, "forward")
end
function PlayChandelierDetachSound(source)
  PlayChandelierSwingSound()
  LD.PlaySound(soundIceEmitters[source], "SND_MECH_Chandelier_Detach_Stn600")
end
function PlayChandelierSwingSound()
  LD.PlaySound(SNDChandelier, "SND_MECH_Chandelier_Swing_Stn600")
end
function PlaySoundIceBreak(emitter)
  LD.PlaySound(soundIceEmitters[emitter], "SND_MECH_Chandelier_Ice_Explo_Stn600")
  LD.StopSound(soundIceEmitters[emitter], "SND_AMB_EMIT_Ice_Crack_Thin_LP")
end
local LeftEncMus = false
local MidEncMus = false
local RightEncMus = false
function MusicDestroyAWulverIn()
  game.Audio.StartMusic("SND_MX_STN_banquet_fight_wulver_in")
end
function MusicDestroyAWulverOut()
  game.Audio.StartMusic("SND_MX_STN_banquet_fight_wulver_out")
  LeftEncMus = true
  if LeftEncMus == true and MidEncMus == true and RightEncMus == true then
    game.Audio.StartMusic("SND_MX_STN_banquet_hall_clear")
  end
end
function MusicDestroyBTrollIn()
  game.Audio.StartMusic("SND_MX_STN_banquet_fight_troll_in")
end
function stn610TrollDeadMusic()
  game.Audio.StartMusic("SND_MX_STN_banquet_fight_troll_out")
end
function MusicDestroyBTrollOut()
  MidEncMus = true
  if LeftEncMus == true and MidEncMus == true and RightEncMus == true then
    game.Audio.StartMusic("SND_MX_STN_banquet_hall_clear")
  end
end
function MusicDestroyCJotunnIn()
  game.Audio.StartMusic("SND_MX_STN_banquet_fight_ogre_in")
end
function MusicDestroyCJotunnOut()
  game.Audio.StartMusic("SND_MX_STN_banquet_fight_ogre_out")
end
function MusicCheckRightEncounter()
  RightEncMus = true
  if LeftEncMus == true and MidEncMus == true and RightEncMus == true then
    game.Audio.StartMusic("SND_MX_STN_banquet_hall_clear")
  end
end
function CameraEncounterZoom()
  oneShotEncounterZoom = CCOS.OneShotCamera.New("PLYR_Nar_EncounterZoom", 3, nil)
  oneShotEncounterZoom:Start()
  oneShotEncounterZoom:SetCallback(DestroyOneShotEncounterZoom)
end
function DestroyOneShotEncounterZoom()
  oneShotEncounterZoom = nil
end
function OnUpdate(level, obj)
  if oneShotEncounterZoom ~= nil then
    oneShotEncounterZoom:Update()
  end
  if iceBreaks == 2 and player:IsPlayingMove("MOV_AimStand") and game.Interact.IsTagSetFiltered("ThrowableCrystal") then
    Crack_and_Release()
  end
end
function Crack_and_Release()
  if Area_1_Encounter_2:IsComplete() and Area_1_Encounter_3:IsComplete() then
    DestroySection_C()
  end
  if Area_1_Encounter_3:IsComplete() and Area_1_Encounter_4:IsComplete() then
    DestroySection_A()
  end
  if Area_1_Encounter_2:IsComplete() and Area_1_Encounter_4:IsComplete() then
    DestroySection_B()
  end
end
function Troll_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:MeterGetValue("Health")
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.8
    local Health_Phase_2 = EnemyHealth * 0.55
    local Health_Phase_3 = EnemyHealth * 0.15
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_1_Encounter_3:StartWave(2)
    end)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_1_Encounter_3:StartWave(3)
    end)
    game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_04")
  end
end
function Trigger_Out_Of_Bounds()
  player:AddMarker("Out_Of_Bounds")
end
function Trigger_In_Bounds()
  player:RemoveMarker("Out_Of_Bounds")
end
