LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local LM = require("level.loadmonitor")
local stn600loaded = false
function OnFirstStart(level)
  local chand
  chand = GameObjects.masonchandlier00.Child
  chand:PlayAnimationCycle({
    Animation = "envChandlier_State2Idle"
  })
  GameObjects.masonChandlier00:FindSingleGOByName("Stn610pntLite4"):Hide()
  GameObjects.masonChandlier00:FindSingleGOByName("BifrostVibrate_Intact").LuaObjectScript.Deactivate()
  GameObjects.masonChandlier00:FindSingleGOByName("BifrostVibrate_Intact"):Hide()
  GameObjects.masonChandlier00:FindSingleGOByName("BifrostVibrate_Intact").LuaObjectScript.Disable(false)
end
function OnUpdate(level)
  if not stn600loaded then
    local stn600 = game.FindLevel("Stn600_ChasmRoom")
    if stn600 ~= nil then
      stn600:CallScript("LockEntranceDoor")
      stn600loaded = true
    end
  end
end
function ChiselBugFixup()
  local stn600_Monitor = LM.CreateLoadMonitor()
  stn600_Monitor:AddCallback({
    Wads = {
      "Stn600_ChasmRoom"
    },
    Functions = {
      function(wads)
        wads.Stn600_ChasmRoom:CallScript("ChiselBugFixup")
      end
    }
  })
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
end
