local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local color = require("core.color")
local BossEncounter = require("boss.statemachine")
local PL = require("design.PrototypeLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local mpicon = require("ui.mpicon")
local actorlib = require("narrative.actor")
local playChiselSickCineOnce = false
local cineNumberForFightComplete = 360
local Done = false
thisLevel = nil
player = nil
son = nil
local snowFlash, magni, modi
local dennyDebug = false
local fxPlayed = false
local isFromCine = false
local modiHealth_Phase1 = 750
local modiHealth_Phase2 = 500
local modiHealth_Phase3 = 250
local magniHealth_Phase1 = 750
local magniHealth_Phase2 = 500
local magniHealth_Phase3 = 250
local modiHealthSnowBlind_Phase1 = 500
local modiHealthSnowBlind_Phase2 = 250
local modiHealthSnowBlind_Phase3 = 1
local magniHealthSnowBlind_Phase1 = 500
local magniHealthSnowBlind_Phase2 = 250
local magniHealthSnowBlind_Phase3 = 1
local blindHitsToWin_Phase1 = 3
local blindHitsToWin_Phase2 = 4
local blindHitsToWin_Phase3 = 1
local blindHeroAttack = 10
local healthTotalSnowBlind_Phase1 = modiHealthSnowBlind_Phase1 + magniHealthSnowBlind_Phase1
local healthTotalSnowBlind_Phase2 = modiHealthSnowBlind_Phase2 + magniHealthSnowBlind_Phase2
local healthTotalSnowBlind_Phase3 = modiHealthSnowBlind_Phase3 + magniHealthSnowBlind_Phase3
local magniMinHealth = 0
local modiMinHealth = 0
local Area_1_Encounter_1, A1_ZM_1
local TEMP_HACK_CheckpointRestored = false
local snowblindAttackDelay = 0
local snowblindAttackDelay_phase1 = 8
local snowblindAttackDelay_phase2 = 3
snowblindActive = false
broRunReady = false
local fromCheckpoint = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  BossEncounter:SetDebugInput(true)
end
function ResetMomentum()
  if player:HasMeter("Momentum") then
    player:MeterSetValue("Momentum", 0)
  end
end
function SetupMagniModi()
  local bossTable = BossEncounter:GetBoss()
  if bossTable == nil then
    return
  end
  if BossEncounter:GetActiveStateName() == "stage5_1" then
    magni = bossTable[1]
    return
  end
  if modi == nil then
    modi = bossTable[1]
    modi:AddMarker("BossModi")
  end
  if magni == nil then
    magni = bossTable[2]
    magni:AddMarker("BossMagni")
  end
  GameObjects.Stn700_Banter.LuaObjectScript.SetupMagniModi(magni, modi)
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") == 360 and game.Level.GetVariable("bossCombatComplete") == true then
    son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
  end
  if not IsBossFightComplete() then
    SetupMagniModi()
    GameObjects.NavObstacle_MagniBody:HideNavObstacle()
    GameObjects.Collision_MagniBody:HideCollision()
    local stn700 = game.FindLevel("Stn700_ChiselRoom")
    if stn700 ~= nil then
      stn700:CallScript("HideDeadMagni")
    end
  end
  TEMP_HACK_CheckpointRestored = false
  DL.HideLevelObject(level, "stn700_Lightning_lights")
end
function OnStartGameFromThisLevel(level)
  print("OnStartGameFromThisLevel")
  BossEncounter:ForwardState()
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Stn700_ChiselRoom" and not IsBossFightComplete() then
    newLevel:CallScript("HideDeadMagni")
  end
end
function OnUpdate(level)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  fromCheckpoint = true
  if IsBossFightComplete() then
    return
  end
  if TEMP_HACK_CheckpointRestored then
    return
  end
  TEMP_HACK_CheckpointRestored = true
  checkpoint.Restore(savedInfo.levelstate)
  if savedInfo.levelstate[level].__bossState.activeIndex == 1 then
    return
  elseif savedInfo.levelstate[level].__bossState.activeIndex ~= 16 then
    BossEncounter:AddCreature("ModiSpawner")
    print("spawn modi")
  end
  BossEncounter:AddCreature("MagniSpawner")
  print("spawn magni")
end
local BossStage_0_1 = BossEncounter:AddStage("stage0_1")
local BossStage_1_1 = BossEncounter:AddStage("stage1_1", true)
local BossStage_1_2 = BossEncounter:AddStage("stage1_2")
local BossStage_1_2b = BossEncounter:AddStage("stage1_2b", true)
local BossStage_1_3 = BossEncounter:AddStage("stage1_3")
local BossStage_2_1 = BossEncounter:AddStage("stage2_1", true)
local BossStage_2_2 = BossEncounter:AddStage("stage2_2")
local BossStage_2_2b = BossEncounter:AddStage("stage2_2b", true)
local BossStage_2_3 = BossEncounter:AddStage("stage2_3")
local BossStage_3_1 = BossEncounter:AddStage("stage3_1", true)
local BossStage_3_2 = BossEncounter:AddStage("stage3_2")
local BossStage_3_2b = BossEncounter:AddStage("stage3_2b", true)
local BossStage_4_1 = BossEncounter:AddStage("stage4_1", true)
local BossStage_5_1 = BossEncounter:AddStage("stage5_1")
function IsBossFightComplete()
  return game.Level.GetVariable("CompletedCineNumber") >= cineNumberForFightComplete and game.Level.GetVariable("bossCombatComplete") == true
end
function SetSnowblindLightningState(isOn)
  if isOn then
    DL.ShowLevelObject(thisLevel, "stn700_Lightning_lights")
  else
    DL.HideLevelObject(thisLevel, "stn700_Lightning_lights")
  end
end
function StageSetup(curPhase)
  SetSnowblindLightningState(false)
  Boss_ShowHealth()
  magni:MeterSetValue("MamoRevive", 0)
  modi:MeterSetValue("MamoRevive", 0)
  if magni:PickupIsAcquired("MagniEnraged") then
    magni:PickupRelinquish("MagniEnraged")
  end
  if magni:PickupIsAcquired("MagniWeakened") then
    magni:PickupRelinquish("MagniWeakened")
  end
  if modi:PickupIsAcquired("ModiEnraged") then
    modi:PickupRelinquish("ModiEnraged")
  end
  if modi:PickupIsAcquired("ModiWeakened") then
    modi:PickupRelinquish("ModiWeakened")
  end
  local modiThresholdForThisPhase = modiHealthSnowBlind_Phase1
  local magniThresholdForThisPhase = magniHealthSnowBlind_Phase1
  if curPhase == 1 then
    magni:MeterSetValue("Health", magniHealth_Phase1)
    modi:MeterSetValue("Health", modiHealth_Phase1)
    magniMinHealth = magniHealth_Phase2 + 1
    modiMinHealth = magniHealth_Phase2 + 1
    magni:PickupAcquire("MagniNavigateFar")
  end
  if curPhase == 2 then
    SpawnHealth()
    magni:MeterSetValue("Health", magniHealth_Phase2)
    modi:MeterSetValue("Health", modiHealth_Phase2)
    magniMinHealth = magniHealth_Phase3 + 1
    modiMinHealth = magniHealth_Phase3 + 1
    if magni:PickupIsAcquired("MagniNavigateFar") then
      magni:PickupRelinquish("MagniNavigateFar")
    end
    modi:PickupAcquire("ModiNavigateFar")
    modiThresholdForThisPhase = modiHealthSnowBlind_Phase2
    magniThresholdForThisPhase = magniHealthSnowBlind_Phase2
  end
  if curPhase == 3 then
    SpawnHealth()
    magni:MeterSetValue("Health", magniHealth_Phase3)
    modi:MeterSetValue("Health", modiHealth_Phase3)
    magniMinHealth = 1
    modiMinHealth = 1
    modiThresholdForThisPhase = modiHealthSnowBlind_Phase3
    magniThresholdForThisPhase = magniHealthSnowBlind_Phase3
  end
  magni:CallScript("SetPhase", curPhase, magniThresholdForThisPhase)
  modi:CallScript("SetPhase", curPhase, modiThresholdForThisPhase)
  GameObjects.Stn700_Banter.LuaObjectScript.SetPhase(curPhase)
  fxPlayed = false
  son:CallScript("InBossFight", true)
  player:RemoveMarker("LUA_TurnR")
  player:RemoveMarker("LUA_TurnL")
  player:RemoveMarker("LUA_StopTurn")
end
function StageSnowBlindSetup(curPhase)
  game.Interact.DisableTags("SpecialBossMoment")
  player:RemoveMarker("LUA_TurnR")
  player:RemoveMarker("LUA_TurnL")
  player:RemoveMarker("LUA_StopTurn")
  if curPhase == 1 then
    ResetSnowblindAttack(snowblindAttackDelay_phase1, "")
    magni:MeterSetValue("Health", magniHealthSnowBlind_Phase1)
    modi:MeterSetValue("Health", modiHealthSnowBlind_Phase1)
  end
  if curPhase == 2 then
    ResetSnowblindAttack(snowblindAttackDelay_phase2, "")
    magni:MeterSetValue("Health", magniHealthSnowBlind_Phase2)
    modi:MeterSetValue("Health", modiHealthSnowBlind_Phase2)
  end
  if curPhase == 3 then
    ResetSnowblindAttack(1, "")
    magni:MeterSetValue("Health", magniHealthSnowBlind_Phase3)
    modi:MeterSetValue("Health", modiHealthSnowBlind_Phase3)
  end
  magni:CallScript("SetPhase", curPhase, 0)
  modi:CallScript("SetPhase", curPhase, 0)
  GameObjects.Stn700_Banter.LuaObjectScript.SetPhase(curPhase)
  fxPlayed = false
end
local magniGrabTutorialOn = false
function MagniGrabTutorial()
  if magni:IsPlayingMove("MOV_CS_MagniGrabKratosEnter") == true and magniGrabTutorialOn == false then
    TUT.Stn700_MagniGrab_Tutorial()
    magniGrabTutorialOn = true
  elseif magni:IsPlayingMove("MOV_CS_MagniGrabKratosEnter") == false and magniGrabTutorialOn == true then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    magniGrabTutorialOn = false
  end
end
function PreventDoubleRage()
  if magni:PickupIsAcquired("MagniEnraged") and modi:PickupIsAcquired("ModiEnraged") then
    magni:PickupRelinquish("MagniEnraged")
    modi:PickupRelinquish("ModiEnraged")
  end
end
function DoReviveLogic(curPhase)
  local reviveRate = 2
  if curPhase == 2 then
    reviveRate = 3
  elseif curPhase == 3 then
    reviveRate = 4
  end
  if math.abs(magni:MeterGetValue("Health") - modi:MeterGetValue("Health")) < 30 and 1 < reviveRate then
    reviveRate = 1
  end
  local difficulty = magni:AttributeGetValue("Difficulty")
  if difficulty == 1 then
    reviveRate = reviveRate * 0.5
  elseif difficulty == 3 then
    reviveRate = reviveRate * 2
  elseif difficulty == 4 then
    reviveRate = reviveRate * 4
  end
  local modiDown = false
  local magniDown = false
  if modi:IsPlayingMove("MOV_HitModiWeakened") or modi:IsPlayingMove("MOV_HitModiWeakenedLoop") then
    modiDown = true
  end
  if magni:IsPlayingMove("MOV_HitMagniWeakened") or magni:IsPlayingMove("MOV_HitMagniWeakenedLoop") then
    magniDown = true
  end
  if magni:IsPlayingMove("MOV_HitMagniWeakenedLoop") and modiDown == false then
    magni:MeterSetValue("MamoRevive", magni:MeterGetValue("MamoRevive") - thisLevel:GetUnitTime() * reviveRate)
  end
  if modi:IsPlayingMove("MOV_HitModiWeakenedLoop") and magniDown == false then
    modi:MeterSetValue("MamoRevive", modi:MeterGetValue("MamoRevive") - thisLevel:GetUnitTime() * reviveRate)
  end
end
function SonElectricFX()
  if son:PickupIsAcquired("KratosElectricShock") then
    son:PickupRelinquish("KratosElectricShock")
    if son:PickupIsAcquired("SonElectricShock") == false then
      son:PickupAcquire("SonElectricShock")
    end
  end
end
function CheckHealthThresholdCombat()
  if dennyDebug == false then
    if magni:GetHitPoints() < magniMinHealth then
      magni:MeterSetValue("Health", magniMinHealth)
    end
    if modi:GetHitPoints() < modiMinHealth then
      modi:MeterSetValue("Health", modiMinHealth)
    end
    local totalMamoHealth = magni:GetHitPoints() + modi:GetHitPoints()
    if magni:PickupIsAcquired("MagniWeakened") == true and modi:PickupIsAcquired("ModiWeakened") == true then
      return true
    end
  end
  return false
end
function CheckSnowblindHitsRemaining(curPhase)
  local hitsToWin = blindHitsToWin_Phase1
  local healthpool = healthTotalSnowBlind_Phase1
  if curPhase == 2 then
    hitsToWin = blindHitsToWin_Phase2
    healthpool = healthTotalSnowBlind_Phase2
  elseif curPhase == 3 then
    hitsToWin = blindHitsToWin_Phase3
    healthpool = healthTotalSnowBlind_Phase3
  end
  local totalMamoHealth = magni:GetHitPoints() + modi:GetHitPoints()
  local healthRemaining = totalMamoHealth - (healthpool - hitsToWin * blindHeroAttack)
  local hitsRemaining = healthRemaining / blindHeroAttack
  return hitsRemaining
end
function CheckHealthThresholdSnowblind(curPhase)
  if CheckSnowblindHitsRemaining(curPhase) <= 0 and magni:IsPlayingMove("MOV_Hit_MaMo_SnowBlind_Knockback") == false and modi:IsPlayingMove("MOV_Hit_MaMo_SnowBlind_Knockback") == false then
    return true
  end
  return false
end
function ForceIdle()
  magni:TriggerMoveEvent("LE_ForceIdle")
  modi:TriggerMoveEvent("LE_ForceIdle")
  player:TriggerMoveEvent("LE_ForceIdle")
end
function StartSnowblindMode()
  SetSnowblindLightningState(true)
  Boss_HideHealth()
  snowblindActive = true
  magni:CallScript("SetSnowblindMode", true)
  modi:CallScript("SetSnowblindMode", true)
  engine.SendHook("LuaHook_SetBossFightBrain", game.AI.FindSon(), true)
  DL.WarpCreature(player, thisLevel, "SnowBlindLocation_Hero")
  DL.WarpCreature(son, thisLevel, "SnowBlindLocation_Son")
  DL.WarpCreature(magni, thisLevel, "SnowBlindLocation_NW_Magni")
  DL.WarpCreature(modi, thisLevel, "SnowBlindLocation_N_Modi")
  player:TriggerMoveEvent("LE_MaMo_SnowBlind_Enter")
  magni:TriggerMoveEvent("LE_WarpToIdle")
  modi:TriggerMoveEvent("LE_WarpToIdle")
  ResetMomentum()
  GameObjects.Stn700_Banter.LuaObjectScript.StartSnowblindMode(magni, modi)
end
function EndSnowblindMode()
  game.Interact.EnableTags("SpecialBossMoment")
  snowblindActive = false
  uiCalls.UI_Event_TurnOffDesignerMessage()
  magni:CallScript("SetSnowblindMode", false)
  modi:CallScript("SetSnowblindMode", false)
  engine.SendHook("LuaHook_SetBossFightBrain", game.AI.FindSon(), false)
  print("Whiteout off")
  game.Audio.SetWwiseState("MX_STN_magnimodi_snowblind", "snowblind_out")
  player:TriggerMoveEvent("LE_MaMo_SnowBlind_Exit")
  son:TriggerMoveEvent("LE_MaMo_SnowBlind_Exit")
  magni:TriggerMoveEvent("LE_MaMo_SnowBlind_Exit")
  modi:TriggerMoveEvent("LE_MaMo_SnowBlind_Exit")
  GameObjects.Stn700_Banter.LuaObjectScript.EndSnowblindMode()
end
function SnowBlindRotateKratos()
  if player:HasMarker("Knockback") ~= true and player:HasMarker("NoTurning") ~= true then
    if game.Camera.GetOrbitRotationRelative() >= 15 then
      if player:HasMarker("LUA_StopTurn") == true then
        player:RemoveMarker("LUA_StopTurn")
      end
      if player:HasMarker("LUA_TurnL") == false then
        player:AddMarker("LUA_TurnL")
      end
      if player:HasMarker("LUA_TurnR") == true then
        player:RemoveMarker("LUA_TurnR")
      end
    elseif game.Camera.GetOrbitRotationRelative() <= -15 then
      if player:HasMarker("LUA_StopTurn") == true then
        player:RemoveMarker("LUA_StopTurn")
      end
      if player:HasMarker("LUA_TurnR") == false then
        player:AddMarker("LUA_TurnR")
      end
      if player:HasMarker("LUA_TurnL") == true then
        player:RemoveMarker("LUA_TurnL")
      end
    elseif game.Camera.GetOrbitRotationRelative() < 1 and game.Camera.GetOrbitRotationRelative() > -1 then
      if player:HasMarker("LUA_TurnR") == true then
        player:RemoveMarker("LUA_TurnR")
      end
      if player:HasMarker("LUA_TurnL") == true then
        player:RemoveMarker("LUA_TurnL")
      end
      if player:HasMarker("LUA_StopTurn") == false then
        player:AddMarker("LUA_StopTurn")
      end
    end
  end
end
local flashDuration = 1.5
local flashTween = 0.5
local fx_flash_1
function HandleWhiteOutFX()
  if fxPlayed == false and (magni:IsPlayingMove("MOV_BroRunImpact") and magni:GetActiveMovePercent() >= 0.32 or magni:IsPlayingMove("MOV_BroRunImpactClose") and magni:GetActiveMovePercent() >= 0.32) then
    fx_flash_1 = {
      EffectName = "FSE_MAMO_SNOWBLIND_FLASH",
      TweenInTime = flashTween,
      TweenOutTime = flashTween,
      Duration = flashDuration
    }
    game.FX.SubmitEffect(fx_flash_1)
    fxPlayed = true
  end
end
function SpawnHealthIndividual(healthLoc)
  local spawnArgs1 = {
    SpawnObject = "goHealthRune_Small",
    HookName = "CallScript_OnHealthSpawned",
    OffsetPosition = DL.GetMarkerPosition(thisLevel, healthLoc),
    Level = thisLevel
  }
  magni:SpawnGameObject(spawnArgs1)
end
function SpawnHealth()
  print("HEALTH SPAWNED")
  SpawnHealthIndividual("HealthLocation_1")
  SpawnHealthIndividual("HealthLocation_2")
  SpawnHealthIndividual("HealthLocation_3")
  SpawnHealthIndividual("HealthLocation_4")
end
function DespawnHealth()
  magni:CallScript("CallScript_DespawnAllHealth", thisLevel)
end
function CallScript_DestroyHealth(level, hpickup)
  hpickup:Destroy()
end
function TransitionBroRunStart()
  if magni:HasMarker("StageTransition") == false then
    magni:AddMarker("StageTransition")
  end
  broRunReady = false
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
end
function TransitionBroRunUpdate()
  if magni:IsPlayingMove("MOV_HitMagniWeakenedLoop") and modi:IsPlayingMove("MOV_HitModiWeakenedLoop") then
    broRunReady = true
  end
  if broRunReady == true then
    if magni:IsPlayingMove("MOV_BroRunEnter") == false and magni:IsPlayingMove("MOV_BroRun") == false and magni:IsPlayingMove("MOV_BroRunLoop") == false and magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
      magni:TriggerMoveEvent("LE_BroRun")
    end
    if modi:IsPlayingMove("MOV_BroRunEnter") == false and modi:IsPlayingMove("MOV_BroRun") == false and modi:IsPlayingMove("MOV_BroRunLoop") == false and modi:IsPlayingMove("MOV_BroRunImpact") == false and modi:IsPlayingMove("MOV_BroRunImpactClose") == false then
      modi:TriggerMoveEvent("LE_BroRun")
    end
  end
  if magni:IsPlayingMove("MOV_BroRunImpact") == true or magni:IsPlayingMove("MOV_BroRunImpactClose") == true then
    BossEncounter:ForwardState()
  end
end
function TransitionBroRunExit()
  if magni:HasMarker("StageTransition") then
    magni:RemoveMarker("StageTransition")
  end
end
function BossStage_0_1:OnEnter(level)
  if BossEncounter:GetBoss() == nil then
    BossEncounter:AddCreature("ModiSpawner")
    BossEncounter:AddCreature("MagniSpawner")
  end
  BossEncounter:SpawnBoss()
  SetupMagniModi()
  son:CallScript("InBossFight", true)
  print("IM IN THE MAGNI MODI FIGHT NOWWWWWWWW!!!!!!")
  magni:CallScript("LuaHook_SetState", "NONHOSTILE")
  modi:CallScript("LuaHook_SetState", "NONHOSTILE")
  game.Combat.TurnOnAndLockCombatStatus()
  son:CallScript("LuaHook_MarkBowUnsheathedInCutscene")
end
function BossStage_0_1:OnUpdate(level)
end
local bossHealthBarOn = false
function Boss_ShowHealth()
  if bossHealthBarOn == false then
    mpicon.level.Create(magni:GetGameObject(), "MAGNI_HEALTH_BAR")
    mpicon.level.SetTextObjectText(magni:GetGameObject(), "MAGNI_HEALTH_BAR", "bossName", "[MSG:" .. 38184 .. "]")
    mpicon.level.SetTextObjectText(magni:GetGameObject(), "MAGNI_HEALTH_BAR", "icon", "\198\158")
    mpicon.level.PlayAnimation(magni:GetGameObject(), "MAGNI_HEALTH_BAR", 0, "bossHealthBar_ToggleStunMeterOn")
    mpicon.level.Create(modi:GetGameObject(), "MODI_HEALTH_BAR")
    mpicon.level.SetTextObjectText(modi:GetGameObject(), "MODI_HEALTH_BAR", "bossName", "[MSG:" .. 38183 .. "]")
    mpicon.level.SetTextObjectText(modi:GetGameObject(), "MODI_HEALTH_BAR", "icon", "\198\159")
    mpicon.level.PlayAnimation(modi:GetGameObject(), "MODI_HEALTH_BAR", 0, "bossHealthBar_ToggleStunMeterOn")
    bossHealthBarOn = true
  end
end
function Boss_HideHealth()
  if bossHealthBarOn == true then
    mpicon.level.Off(magni:GetGameObject(), "MAGNI_HEALTH_BAR")
    mpicon.level.Off(modi:GetGameObject(), "MODI_HEALTH_BAR")
    bossHealthBarOn = false
  end
end
local sonDis = false
function BossStage_1_1:OnEnter(level)
  StageSetup(1)
  son:CallScript("ToggleReactionTimer", "Reaction", false)
  son:CallScript("InBossFight", true)
  game.Audio.StartMusic("SND_MX_STN_magnimodi_fight_in")
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
  if not isFromCine then
    DL.WarpCreature(magni, thisLevel, "Warp_SnowblindEndMagni")
    DL.WarpCreature(modi, thisLevel, "Warp_SnowblindEndModi")
  end
  magni:CallScript("LuaHook_SetState", "INCOMBAT")
  modi:CallScript("LuaHook_SetState", "INCOMBAT")
  magni:CallScript("LuaHook_TargetKratos", "INCOMBAT")
  modi:CallScript("LuaHook_TargetSon", "INCOMBAT")
end
function BossStage_1_1:OnUpdate(level)
  SonElectricFX()
  PreventDoubleRage()
  DoReviveLogic(1)
  MagniGrabTutorial()
  if sonDis == false then
    sonDis = true
    son:CallScript("ToggleReactionTimer", "Reaction", false)
  end
  if CheckHealthThresholdCombat() then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_2:OnEnter(level)
  StageSnowBlindSetup(1)
  TransitionBroRunStart()
end
function BossStage_1_2:OnUpdate(level)
  TransitionBroRunUpdate()
end
function BossStage_1_2:OnExit(level)
  TransitionBroRunExit()
end
function BossStage_1_2b:OnEnter(level)
  StageSnowBlindSetup(1)
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
  if magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
    magni:TriggerMoveEvent("LE_BroRunImpact")
  end
end
function BossStage_1_2b:OnUpdate(level)
  HandleWhiteOutFX()
  if magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_3:OnEnter(level)
  StageSnowBlindSetup(1)
  StartSnowblindMode()
  timer.StartLevelTimer(5, function()
    if snowblindActive then
      TUT.Stn700_SnowBlind_Tutorial()
    end
  end)
  print("BossStage_1_3 Enter")
  game.Audio.SetWwiseState("MX_STN_magnimodi_snowblind", "snowblind_in")
  game.Audio.StartMusic("SND_MX_STN_magnimodi_snowblind_in")
end
function BossStage_1_3:OnUpdate(level)
  if player:HasMarker("MaMoSnowblind") then
    game.Camera.SubmitCameraByName("CBT_MaMoSnowblind")
  end
  SnowBlindRotateKratos()
  if SnowblindCanAttack() then
    if CheckHealthThresholdSnowblind(1) then
      BossEncounter:ForwardState()
      return
    else
      SnowblindHandleAttack(1)
    end
  end
end
function BossStage_1_3:OnExit(level)
  EndSnowblindMode()
end
function BossStage_2_1:OnEnter(level)
  StageSetup(2)
  son:CallScript("InBossFight", true)
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
  DL.WarpCreature(magni, thisLevel, "Warp_SnowblindEndMagni")
  DL.WarpCreature(modi, thisLevel, "Warp_SnowblindEndModi")
  magni:CallScript("LuaHook_SetState", "INCOMBAT")
  modi:CallScript("LuaHook_SetState", "INCOMBAT")
  game.Audio.StartMusic("SND_MX_STN_magnimodi_fight_p2")
end
function BossStage_2_1:OnUpdate(level)
  SonElectricFX()
  PreventDoubleRage()
  DoReviveLogic(2)
  MagniGrabTutorial()
  if CheckHealthThresholdCombat() == true then
    BossEncounter:ForwardState()
    return
  end
end
function BossStage_2_2:OnEnter(level)
  StageSnowBlindSetup(2)
  TransitionBroRunStart()
end
function BossStage_2_2:OnUpdate(level)
  TransitionBroRunUpdate()
end
function BossStage_2_2:OnExit(level)
  TransitionBroRunExit()
end
function BossStage_2_2b:OnEnter(level)
  StageSnowBlindSetup(2)
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
  if magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
    magni:TriggerMoveEvent("LE_BroRunImpact")
  end
end
function BossStage_2_2b:OnUpdate(level)
  HandleWhiteOutFX()
  if magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
    BossEncounter:ForwardState()
  end
end
function BossStage_2_3:OnEnter(level)
  print("BossStage_2_3 Enter")
  StageSnowBlindSetup(2)
  StartSnowblindMode()
  DespawnHealth()
  game.Audio.SetWwiseState("MX_STN_magnimodi_snowblind", "snowblind_in")
  game.Audio.StartMusic("SND_MX_STN_magnimodi_snowblind_in")
  timer.StartLevelTimer(5, function()
    if snowblindActive then
      TUT.Stn700_SnowBlind_Tutorial()
    end
  end)
end
function BossStage_2_3:OnUpdate(level)
  if player:HasMarker("MaMoSnowblind") then
    game.Camera.SubmitCameraByName("CBT_MaMoSnowblind")
  end
  SnowBlindRotateKratos()
  if SnowblindCanAttack() then
    if CheckHealthThresholdSnowblind(2) then
      BossEncounter:ForwardState()
      return
    else
      SnowblindHandleAttack(2)
    end
  end
end
function BossStage_2_3:OnExit(level)
  EndSnowblindMode()
end
function BossStage_3_1:OnEnter(level)
  StageSetup(3)
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
  DL.WarpCreature(magni, thisLevel, "Warp_SnowblindEndMagni")
  DL.WarpCreature(modi, thisLevel, "Warp_SnowblindEndModi")
  magni:CallScript("LuaHook_SetState", "INCOMBAT")
  modi:CallScript("LuaHook_SetState", "INCOMBAT")
  game.Audio.StartMusic("SND_MX_STN_magnimodi_fight_p3")
  if fromCheckpoint then
    modi:TriggerMoveEvent("LE_ModiCheckpointTaunt")
  end
end
function BossStage_3_1:OnUpdate(level)
  SonElectricFX()
  PreventDoubleRage()
  DoReviveLogic(3)
  MagniGrabTutorial()
  if CheckHealthThresholdCombat() == true then
    BossEncounter:ForwardState()
    return
  end
end
function BossStage_3_2:OnEnter(level)
  StageSnowBlindSetup(3)
  TransitionBroRunStart()
end
function BossStage_3_2:OnUpdate(level)
  TransitionBroRunUpdate()
end
function BossStage_3_2:OnExit(level)
  TransitionBroRunExit()
end
function BossStage_3_2b:OnEnter(level)
  StageSnowBlindSetup(3)
  if BossEncounter:IsDebugSkip() then
    ForceIdle()
  end
  if magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
    magni:TriggerMoveEvent("LE_BroRunImpact")
  end
end
function BossStage_3_2b:OnUpdate(level)
  HandleWhiteOutFX()
  if magni:IsPlayingMove("MOV_BroRunImpact") == false and magni:IsPlayingMove("MOV_BroRunImpactClose") == false then
    BossEncounter:ForwardState()
  end
end
local kratosActor = actorlib.Actor.New("Kratos MagniKill", game.Player.FindPlayer)
local sonActor = actorlib.Actor.New("Son MagniKill", function()
  return son
end)
local magniActor = actorlib.Actor.New("Magni MagniKill", function()
  return magni
end)
local modiActor = actorlib.Actor.New("Modi MagniKill", function()
  return modi
end)
local magniKillTutOn = false
function BossStage_4_1:OnEnter(level)
  ResetMomentum()
  DL.ShowLevelObject(thisLevel, "magniKillArrowA")
  DL.ShowLevelObject(thisLevel, "magniKillArrowB")
  DL.ShowLevelObject(thisLevel, "magniKillArrowC")
  uiCalls.UI_Event_TurnOffDesignerMessage()
  magniKillTutOn = false
  Boss_HideHealth()
  local sequence = LD.CreateCineSequence(thisLevel, GameObjects.MagniKillSync, "MagniKill")
  sequence:ActorSync(kratosActor, {
    Slaves = {
      {Actor = sonActor},
      {Actor = magniActor},
      {Actor = modiActor}
    },
    Branch = "BRA_MagniKillEnter",
    ReferenceJoint = "MagniKillSyncJoint"
  })
  sequence:StartSequence()
  magni:CallScript("LuaHook_SetState", "NONHOSTILE")
  if modi ~= nil then
    modi:CallScript("LuaHook_SetState", "NONHOSTILE")
  end
  GameObjects.Stn700_Banter.LuaObjectScript.OutroStart()
end
function BossStage_4_1:OnUpdate(level)
  if player:IsPlayingMove("MOV_MagniKillEnter") and player:GetActiveMovePercent() >= 0.95 or player:IsPlayingMove("MOV_MagniKillFail") and player:GetActiveMovePercent() >= 0.9 then
    if magniKillTutOn == false then
      TUT.Stn700_MagniKill_Tutorial()
      magniKillTutOn = true
    end
  elseif magniKillTutOn == true then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    magniKillTutOn = false
  end
  if player:IsPlayingMove("MOV_MagniKillWin") and player:GetActiveMovePercent() >= 0.85 then
    if playChiselSickCineOnce == false then
      print("============ CALLING CHISEL SICK SEQUENCE FROM COMBAT ===============")
      GameObjects.Cine_ChiselSick.LuaObjectScript.ChiselSickSequence()
      playChiselSickCineOnce = true
    end
    son:CallScript("ToggleReactionTimer", "Reaction", true)
    print("BossStage_4_1 Exit")
    BossEncounter:ForwardState()
  end
end
function BossStage_4_1:OnExit(level)
end
function BossStage_5_1:OnEnter(level)
  game.Interact.EnableTags("SpecialBossMoment")
  if IsBossFightComplete() then
    return
  end
  DL.HideLevelObject(thisLevel, "magniKillArrowA")
  DL.HideLevelObject(thisLevel, "magniKillArrowB")
  DL.HideLevelObject(thisLevel, "magniKillArrowC")
  if game.Level.GetVariable("bossCombatComplete") == false then
    game.Level.SetVariable("bossCombatComplete", true)
    son:CallScript("InBossFight", false)
    DL.HideLevelObject(thisLevel, "SCRIPTED_SnowBlocker")
    Enable_UnlockChiselEvent()
  end
  if magni == nil then
    magni = BossEncounter:GetBoss()
  end
  magni:CallScript("LuaHook_SetState", "NONHOSTILE")
  if modi ~= nil then
    modi:CallScript("LuaHook_SetState", "NONHOSTILE")
  end
  game.Combat.UnlockCombatStatus()
  print("IM OUT OF THE MAGNI MODI FIGHT NOWWWWWWWW!!!!!!")
  player:RemoveMarker("LUA_TurnR")
  player:RemoveMarker("LUA_TurnL")
  player:RemoveMarker("LUA_StopTurn")
end
function BossStage_5_1:OnUpdate(level)
end
function Enable_UnlockChiselEvent()
  GameObjects.Collision_MagniBody:ShowCollision()
  GameObjects.NavObstacle_MagniBody:ShowNavObstacle()
  GameObjects.ChiselChop.LuaObjectScript:Enable()
  GameObjects.CA_Observe_Forward_Up_Stn700_Chop.LuaObjectScript.Enable()
  GameObjects.LTW_toChisel.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_Stn700_Chisel.LuaObjectScript.Enable()
  son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
end
function ChiselGearGiven()
  GameObjects.LTW_toChisel.LuaObjectScript.Disable()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_IdleBehavior_Stn700_Chisel.LuaObjectScript.Disable()
  end, 3.5)
end
function UnlockChiselEvent()
  if game.Level.GetVariable("CompletedCineNumber") < 360 then
    game.Level.SetVariable("CompletedCineNumber", 360)
    LD.SetSelectedRealm("Midgard")
    LD.SetBridgePosition("Midgard")
  end
  StartQuest_ReturnToBoat()
  timer.StartLevelTimer(0.1, function()
    game.Audio.PlayBanter("stn_PostChiselPrompt")
  end)
end
function HideMagniCollision()
  GameObjects.Collision_MagniBody:HideCollision()
  GameObjects.NavObstacle_MagniBody:HideNavObstacle()
end
function StartQuest_ReturnToBoat()
  game.QuestManager.ProposeQuestState("Quest_StoneMason_Objective550", "Complete")
  LD.ActivateQuest("Quest_Parent_TyrsVault")
  UpdateCompassMarkers()
  game.World.StoreCheckpoint()
end
function Stn700_HideCompass()
  game.Compass.SetDesignerForcedHide(true)
end
function Stn700_ShowCompass()
  game.Compass.SetDesignerForcedHide(false)
end
function UpdateCompassMarkers()
  game.Compass.SetGatewayMarkerIsOpen("SM_750_Helper4", true)
  game.Compass.SetGatewayMarkerIsOpen("SM_600_Helper", true)
  game.Compass.SetGatewayMarkerIsOpen("SM_150_Helper", true)
  game.Compass.SetGatewayMarkerIsOpen("SM_550_Helper", false)
end
local warpSteps = 3
function SnowblindCanAttack()
  local retVal = false
  if player:IsPlayingMove("MOV_MaMo_SnowBlind_Enter") == false and (magni:IsPlayingMove("MOV_WarpToIdle") or magni:IsPlayingMove("MOV_TeaseRetreatSnowBlind") or magni:IsPlayingMove("MOV_AttackSprintExit")) and (modi:IsPlayingMove("MOV_WarpToIdle") or modi:IsPlayingMove("MOV_TeaseRetreatSnowBlind") or modi:IsPlayingMove("MOV_AttackSprintExit")) then
    retVal = true
  end
  return retVal
end
snowblindAtkType = ""
snowblindAtkStep = 0
snowblindAtkMagniPos = ""
snowblindAtkModiPos = ""
function RandomizeSnowblindAttackPosSameSide()
  local rand = math.random(1, 4)
  if rand == 1 then
    SetSnowblindAttackPos("SnowBlindLocation_S_Modi", "SnowBlindLocation_SW_Magni", "SnowBlindLocation_SE_Magni")
  elseif rand == 2 then
    SetSnowblindAttackPos("SnowBlindLocation_N_Modi", "SnowBlindLocation_NW_Magni", "SnowBlindLocation_NE_Magni")
  elseif rand == 3 then
    SetSnowblindAttackPos("SnowBlindLocation_W_Modi", "SnowBlindLocation_NW_Magni", "SnowBlindLocation_SW_Magni")
  elseif rand == 4 then
    SetSnowblindAttackPos("SnowBlindLocation_E_Modi", "SnowBlindLocation_NE_Magni", "SnowBlindLocation_SE_Magni")
  end
end
function RandomizeSnowblindAttackPos()
  local rand = math.random(1, 4)
  if rand == 1 then
    SetSnowblindAttackPos("SnowBlindLocation_S_Modi", "SnowBlindLocation_NW_Magni", "SnowBlindLocation_NE_Magni")
  elseif rand == 2 then
    SetSnowblindAttackPos("SnowBlindLocation_N_Modi", "SnowBlindLocation_SW_Magni", "SnowBlindLocation_SE_Magni")
  elseif rand == 3 then
    SetSnowblindAttackPos("SnowBlindLocation_W_Modi", "SnowBlindLocation_NE_Magni", "SnowBlindLocation_SE_Magni")
  elseif rand == 4 then
    SetSnowblindAttackPos("SnowBlindLocation_E_Modi", "SnowBlindLocation_NW_Magni", "SnowBlindLocation_SW_Magni")
  end
end
function SetSnowblindAttackPos(modiPos, magniPos1, magniPos2)
  snowblindAtkModiPos = modiPos
  snowblindAtkMagniPos = magniPos1
  if math.random(1, 2) == 1 then
    snowblindAtkMagniPos = magniPos2
  end
end
function ResetSnowblindAttack(cd, atkType)
  snowblindAtkType = atkType
  snowblindAtkStep = 0
  snowblindAtkMagniPos = ""
  snowblindAtkModiPos = ""
  snowblindAttackDelay = cd
  if atkType == "TagStrikeFront" then
    RandomizeSnowblindAttackPos()
  elseif atkType == "TagStrikeBehind" then
    RandomizeSnowblindAttackPosSameSide()
  elseif atkType == "FeintStrikeFront" then
    RandomizeSnowblindAttackPosSameSide()
  elseif atkType == "FeintStrikeBehind" then
    RandomizeSnowblindAttackPos()
  elseif atkType == "SingleStrikeMagni" then
    RandomizeSnowblindAttackPos()
  elseif atkType == "SingleStrikeModi" then
    RandomizeSnowblindAttackPos()
  end
  GameObjects.Stn700_Banter.LuaObjectScript.PlaySnowTaunt(atkType)
end
function SnowblindHandleAttack(curPhase)
  local hitsRemaining = CheckSnowblindHitsRemaining(curPhase)
  if snowblindAttackDelay <= 0 then
    if hitsRemaining <= 1 and snowblindAtkType ~= "Final" then
      ResetSnowblindAttack(3, "Final")
      DL.WarpCreature(modi, thisLevel, "SnowBlindLocation_S_Modi")
      DL.WarpCreature(modi, thisLevel, "SnowBlindLocation_NW_Magni")
      snowblindAtkModiPos = "SnowBlindLocation_S_Modi"
      snowblindAtkMagniPos = "SnowBlindLocation_NW_Magni"
      if curPhase == 1 then
        snowblindAtkStep = 1
      end
    elseif snowblindAtkType == "" then
      if curPhase == 1 then
        if hitsRemaining <= 2 then
          ResetSnowblindAttack(0, "SingleStrikeMagni")
        else
          ResetSnowblindAttack(0, "TagStrikeFront")
        end
      elseif hitsRemaining <= 2 then
        ResetSnowblindAttack(0, "SingleStrikeMagni")
      elseif hitsRemaining <= 3 then
        ResetSnowblindAttack(0, "FeintStrikeBehind")
      else
        ResetSnowblindAttack(0, "FeintStrikeFront")
      end
    end
  end
  if snowblindAttackDelay <= 0 then
    if snowblindAtkType == "TagStrikeFront" or snowblindAtkType == "TagStrikeBehind" then
      if snowblindAtkStep == 0 then
        DL.WarpCreature(modi, thisLevel, snowblindAtkModiPos)
        modi:TriggerMoveEvent("LE_SnowBlindAttack")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(modi)
        snowblindAttackDelay = 0.5
        if snowblindAtkType == "TagStrikeBehind" then
          snowblindAttackDelay = 1.5
        end
      else
        DL.WarpCreature(magni, thisLevel, snowblindAtkMagniPos)
        magni:TriggerMoveEvent("LE_SnowBlindAttack")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(magni)
        ResetSnowblindAttack(3, "")
        if snowblindAtkType == "TagStrikeBehind" then
          ResetSnowblindAttack(5, "")
        end
      end
      snowblindAtkStep = snowblindAtkStep + 1
    elseif snowblindAtkType == "FeintStrikeFront" then
      if snowblindAtkStep == 0 then
        DL.WarpCreature(magni, thisLevel, snowblindAtkMagniPos)
        magni:TriggerMoveEvent("LE_SnowBlindAttackTease")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(magni)
      else
        DL.WarpCreature(modi, thisLevel, snowblindAtkModiPos)
        modi:TriggerMoveEvent("LE_SnowBlindAttack")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(modi)
        ResetSnowblindAttack(3, "")
      end
      snowblindAtkStep = snowblindAtkStep + 1
    elseif snowblindAtkType == "FeintStrikeBehind" then
      if snowblindAtkStep == 0 then
        DL.WarpCreature(modi, thisLevel, snowblindAtkModiPos)
        modi:TriggerMoveEvent("LE_SnowBlindAttackTease")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(modi)
      else
        DL.WarpCreature(magni, thisLevel, snowblindAtkMagniPos)
        magni:TriggerMoveEvent("LE_SnowBlindAttack")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(magni)
        ResetSnowblindAttack(3, "")
      end
      snowblindAtkStep = snowblindAtkStep + 1
    elseif snowblindAtkType == "SingleStrikeMagni" then
      DL.WarpCreature(magni, thisLevel, snowblindAtkMagniPos)
      magni:TriggerMoveEvent("LE_SnowBlindAttack")
      GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(magni)
      ResetSnowblindAttack(1, "")
      snowblindAtkStep = snowblindAtkStep + 1
    elseif snowblindAtkType == "SingleStrikeModi" then
      DL.WarpCreature(modi, thisLevel, snowblindAtkModiPos)
      modi:TriggerMoveEvent("LE_SnowBlindAttack")
      GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(modi)
      ResetSnowblindAttack(5, "")
      snowblindAtkStep = snowblindAtkStep + 1
    elseif snowblindAtkType == "Final" then
      if snowblindAtkStep == 0 then
        DL.WarpCreature(magni, thisLevel, snowblindAtkMagniPos)
        magni:TriggerMoveEvent("LE_SnowBlindAttackTease")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(magni)
        snowblindAttackDelay = 1
      else
        DL.WarpCreature(modi, thisLevel, snowblindAtkModiPos)
        modi:TriggerMoveEvent("LE_SnowBlindAttack")
        GameObjects.Stn700_Banter.LuaObjectScript.SnowblindAttack(modi)
        ResetSnowblindAttack(3, "")
      end
      snowblindAtkStep = snowblindAtkStep + 1
    end
  else
    snowblindAttackDelay = snowblindAttackDelay - thisLevel:GetUnitTime()
  end
end
local WarpBoss = function(ai)
  if ai:GetName() == "MAGNI00" then
    DL.WarpCreature(ai, thisLevel, "SnowBlindLocation_NE_Magni")
    magni:TriggerMoveEvent("LE_WarpToIdle")
  else
    DL.WarpCreature(ai, thisLevel, "SnowBlindLocation_N_Modi")
    modi:TriggerMoveEvent("LE_WarpToIdle")
  end
end
local markTargetDist = 0
local markTargetName
function ResetClosest()
  markTargetDist = 0
  markTargetName = nil
end
function CheckForClosest(level, ai, markerName)
  local markPos = DL.GetMarkerPosition(level, markerName)
  local dist = math.abs((markPos - ai:GetWorldPosition()).length)
  if markTargetName == nil or dist < markTargetDist then
    markTargetName = markerName
    markTargetDist = dist
  end
  return dist
end
function WarpBossClosest(level, ai)
  ResetClosest()
  if ai:GetName() == "MAGNI00" then
    CheckForClosest(level, ai, "SnowBlindLocation_NW_Magni")
    CheckForClosest(level, ai, "SnowBlindLocation_NE_Magni")
    CheckForClosest(level, ai, "SnowBlindLocation_SW_Magni")
    CheckForClosest(level, ai, "SnowBlindLocation_SE_Magni")
  else
    CheckForClosest(level, ai, "SnowBlindLocation_N_Modi")
    CheckForClosest(level, ai, "SnowBlindLocation_W_Modi")
    CheckForClosest(level, ai, "SnowBlindLocation_S_Modi")
    CheckForClosest(level, ai, "SnowBlindLocation_E_Modi")
  end
  DL.WarpCreature(ai, thisLevel, markTargetName)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Temp Boss Fight STN700", {CheckpointOnComplete = true})
  A1_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.entityZone_MagniModi)
  A1_ZM_1:SetTriggerCountLimit(1)
  A1_ZM_1:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies()
  end)
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Traveler_S_SFG",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.03
    },
    {
      spawners = "Traveler_N_SFG",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.03
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Spawn)
  Area_1_Encounter_1:OnComplete(Enable_UnlockChiselEvent)
end
function AdanceMagniModiEncounter()
  BossEncounter:SetDebugInput(true)
  isFromCine = true
  BossEncounter:ForwardState()
end
