local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local timers = require("level.timer")
local thisObj, thisLevel, player, kratosActor, sonActor, magniActor, modiActor, jotunnActor, cameraCineEnter_AttackOfTheBros
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  CreateActors()
  SetJotunnSpawnFunction()
end
function OnUpdate(level, obj)
  if cameraCineEnter_AttackOfTheBros ~= nil then
    cameraCineEnter_AttackOfTheBros:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function CreateActors()
  kratosActor = actor.Actor.New("Attack of the Bros: Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Attack of the Bros: Son", game.AI.FindSon)
  magniActor = actor.Actor.New("Attack of the Bros: Magni Actor", ND.FindMagni)
  modiActor = actor.Actor.New("Attack of the Bros: Modi Actor", ND.FindModi)
  jotunnActor = actor.Actor.New("Attack of the Bros: Jotunn Actor")
end
local FindMagniModi = function()
  local magniFound = false
  local modiFound = false
  for _, enemy in ipairs(player:FindEnemies(50)) do
    if enemy:GetName() == "magni00" then
      magniFound = true
    elseif enemy:GetName() == "modi00" then
      modiFound = true
    end
  end
  return magniFound and modiFound
end
function SetJotunnSpawnFunction()
  jotunnActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_AttackOfTheBros_Group", "AttackOfTheBros_SynchJoint", "CRT_Jotunn00", "BRA_AttackOfTheBros", "jotunn")
  end)
end
function AttackOfTheBrosSequence()
  local attackOfTheBrosSeq = LD.CreateCineSequence(thisLevel, thisObj, "Attack of the Bros")
  local attackOfTheBros_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_AttackOfTheBros"
    },
    {
      Actor = magniActor,
      Branch = "BRA_AttackOfTheBros"
    },
    {
      Actor = modiActor,
      Branch = "BRA_AttackOfTheBros"
    },
    {
      Actor = jotunnActor,
      Branch = "BRA_AttackOfTheBros"
    }
  }
  attackOfTheBrosSeq:SetPostSkipMusic("SND_MX_STN_start_master")
  attackOfTheBrosSeq:Do(Wake)
  attackOfTheBrosSeq:WaitForActorPlayingMove(kratosActor, "MOV_Buddy_Drop_5m_1Way_No_Unsheathe")
  attackOfTheBrosSeq:Do(ShowForcedCombatCamera)
  attackOfTheBrosSeq:Do(StartCineEnter_AttackOfTheBros)
  attackOfTheBrosSeq:Do(function()
    thisLevel:CallScript("AdanceMagniModiEncounter")
  end)
  attackOfTheBrosSeq:WaitForFunctionTrue(FindMagniModi)
  attackOfTheBrosSeq:RequestCineModeAndWait(kratosActor, thisObj)
  attackOfTheBrosSeq:Do(function()
    attackOfTheBrosSeq:MarkAbleToSkip()
  end)
  attackOfTheBrosSeq:SpawnActorAndWait(jotunnActor)
  attackOfTheBrosSeq:ActorSync(kratosActor, {
    Slaves = attackOfTheBros_ActorTable,
    Branch = "BRA_AttackOfTheBros",
    ReferenceJoint = "AttackOfTheBros_SynchJoint"
  })
  attackOfTheBrosSeq:Do(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  attackOfTheBrosSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.165)
  attackOfTheBrosSeq:Do(InterruptArenaBanter)
  attackOfTheBrosSeq:WaitForFunctionTrue(function()
    return game.AI.FindSon().AnimPercent >= 0.9
  end)
  attackOfTheBrosSeq:DespawnActor(jotunnActor)
  attackOfTheBrosSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.985)
  attackOfTheBrosSeq:Do(function()
    attackOfTheBrosSeq:EndSkipIfActive()
  end)
  attackOfTheBrosSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  attackOfTheBrosSeq:WaitForActorMoveComplete(kratosActor)
  attackOfTheBrosSeq:Do(HideCineTriggerZone)
  attackOfTheBrosSeq:StopPuppetingActor(kratosActor)
  attackOfTheBrosSeq:StopPuppetingActor(sonActor)
  attackOfTheBrosSeq:StopPuppetingActor(magniActor)
  attackOfTheBrosSeq:StopPuppetingActor(modiActor)
  attackOfTheBrosSeq:SetCompletedCineNumber(358)
  attackOfTheBrosSeq:Do(HideForcedCombatCamera)
  attackOfTheBrosSeq:Do(function()
    thisLevel:CallScript("AdanceMagniModiEncounter")
  end)
  attackOfTheBrosSeq:StartSequence()
end
function HideCineTriggerZone()
  GameObjects.Cine_AttackOfTheBros_Group:Hide()
end
function Wake()
  game.SubObject.Wake(thisObj)
end
function StartCineEnter_AttackOfTheBros()
  cameraCineEnter_AttackOfTheBros = CCEC.CineEnterCamera.New("ENV_CineEnter_AttackOfTheBros", 10)
  cameraCineEnter_AttackOfTheBros:SetCallback(DestroyCineEnter_AttackOfTheBros)
  cameraCineEnter_AttackOfTheBros:Start()
end
function DestroyCineEnter_AttackOfTheBros()
  cameraCineEnter_AttackOfTheBros = nil
  game.SubObject.Sleep(thisObj)
end
function InterruptArenaBanter()
  game.Audio.InterruptBanterOnCharacter("InArenaVO_Emitter")
end
function ShowForcedCombatCamera()
  GameObjects.CamZone_MagniModi_ForcedCombat:ShowCameraVolume()
end
function HideForcedCombatCamera()
  timers.StartLevelTimer(4.56, function()
    GameObjects.CamZone_MagniModi_ForcedCombat:HideCameraVolume()
  end)
end
