local ND = require("design.NarrativeDesignLibrary")
local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, player, kraActor, sonActor, modiActor, magniActor, arrow01Prop, arrow02Prop
local synchJointStr = "ChiselSick_SynchJoint"
local kraStartJointStr = "Kra_StartJoint"
local sonStartJointStr = "Son_StartJoint"
local modiStartJointStr = "Modi_StartJoint"
local magniStartJointStr = "Magni_StartJoint"
local chiselSickBranchStr = "BRA_ChiselSick"
local cine_lights_360
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  cine_lights_360 = GameObjects.Cine_Start_360
  HideCineLights()
  SetupProps()
  HideProps()
  if game.Level.GetVariable("CompletedCineNumber") < 360 or game.Level.GetVariable("bossCombatComplete") == false then
    SetupActors()
  end
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function SetupActors()
  kraActor = actor.Actor.New("CHISEL SICK: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("CHISEL SICK: Son Actor", game.AI.FindSon)
  modiActor = actor.Actor.New("CHISEL SICK: Modi Actor", ND.FindModi)
  magniActor = actor.Actor.New("CHISEL SICK: Modi Actor", ND.FindMagni)
end
function SetupProps()
  arrow01Prop = thisObj:FindSingleGOByName("arrow01Prop").Child
  arrow02Prop = thisObj:FindSingleGOByName("arrow02Prop").Child
end
function HideProps()
  arrow01Prop:Hide()
  arrow02Prop:Hide()
end
function ShowProps()
  arrow01Prop:Show()
  arrow02Prop:Show()
  arrow01Prop:HideJoint(arrow01Prop:GetJointIndex("arrow00_stream"))
  arrow02Prop:HideJoint(arrow02Prop:GetJointIndex("arrow00_stream"))
  arrow01Prop:ShowJoint(arrow01Prop:GetJointIndex("arrow20_stream"))
  arrow02Prop:ShowJoint(arrow02Prop:GetJointIndex("arrow20_stream"))
end
function ChiselSickSequence()
  print("========= PLAY CHISEL SICK SEQUENCE ============")
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Chisel Sick Sequence")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = modiActor},
    {Actor = magniActor},
    {
      Obj = arrow01Prop,
      Anim = "narStnChiselSick000Cine1"
    },
    {
      Obj = arrow02Prop,
      Anim = "narStnChiselSick000Cine2"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_STN_start_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.8958333)
  cineSeq:Do(ShowProps)
  cineSeq:Do(PlayCineLights)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = chiselSickBranchStr,
    ReferenceJoint = synchJointStr
  })
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.98)
  cineSeq:StopPuppetingActor(modiActor)
  cineSeq:DespawnActor(modiActor)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(magniActor)
  cineSeq:Do(HideProps)
  cineSeq:Do(function()
    LD.SetSelectedRealm("Midgard")
    LD.SetBridgePosition("Midgard")
  end)
  cineSeq:SetCompletedCineNumber(360)
  cineSeq:Do(AwardTrophy)
  cineSeq:Do(MagniModiBestiaryEntries)
  cineSeq:Do(function()
    uiCalls.UI_Event_DiscoverLocation("Stonemason Chisel")
  end)
  cineSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(function()
    game.Audio.PlayBanter("stn_WhatWeCameFor")
  end)
  cineSeq:Do(function()
    game.Compass.SetDesignerForcedHide(false)
  end)
  cineSeq:StartSequence()
end
function AwardTrophy()
  print("Award Trophy: Do You Know Who My Dad Is?")
  game.UnlockTrophy(5)
end
function MagniModiBestiaryEntries()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Magni")
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Modi")
end
function PlayCineLights()
  cine_lights_360:Show()
  cine_lights_360:JumpAnimToFrame(0)
  cine_lights_360:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_360:Hide()
end
function MagniKilled()
  local isPlayingMagniKillWin = player:IsPlayingMove("MOV_MagniKillWin") and player:GetActiveMovePercent() >= 0.93
  return isPlayingMagniKillWin
end
