local LD = require("design.LevelDesignLibrary")
local thisObj, player, son, magni, modi
local tauntTimerLength = 30
local phase1Taunts = {
  "Phase1Taunts01",
  "Phase1Taunts02",
  "Phase1Taunts03"
}
local phase2Taunts = {
  "Phase2Taunts01"
}
local phase2TauntsModiToSon = {
  "Phase2Taunts_ModiSon01",
  "Phase2Taunts_ModiSon02"
}
local phase3Taunts = {
  "Phase3Taunts01",
  "Phase3Taunts02"
}
local useBanterTellMagniBool = true
local useBanterTellModiBool = true
local currentMagniTarget = ""
local currentModiTarget = ""
local snow1Taunts = {
  "BacktoBack1_Tell01",
  "BacktoBack1_Tell02"
}
local snow2Taunts = {
  "BacktoBack2_Tell01",
  "BacktoBack2_Tell02"
}
local playingSnowTaunt = false
local phase = 0
local snowblindBool = false
local firstPhaseTauntPlayed = false
local checkTauntTimerActive = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if 0 < phase then
    if magni ~= nil and modi ~= nil and not InSnowblindOrTransitioning() and firstPhaseTauntPlayed then
      CheckAttention()
    end
  elseif game.Level.GetVariable("CompletedCineNumber") == 358 then
    SetPhase(1)
  end
end
function NextCheckTaunt(delayTime)
  if not checkTauntTimerActive then
    LD.CallFunctionAfterDelay(CheckTaunts, delayTime)
    checkTauntTimerActive = true
  end
end
function CheckTaunts()
  checkTauntTimerActive = false
  if phase == 4 then
    return
  end
  if not InSnowblindOrTransitioning() then
    local tauntsNotEmpty = false
    firstPhaseTauntPlayed = true
    if phase == 3 and 0 < #phase3Taunts then
      game.Audio.PlayBanter(phase3Taunts[1])
      table.remove(phase3Taunts, 1)
      NextCheckTaunt(tauntTimerLength)
      return
    end
    if 2 <= phase and 0 < #phase2TauntsModiToSon then
      if IsTargeting(modi, son) then
        game.Audio.PlayBanter(phase2TauntsModiToSon[1])
        table.remove(phase2TauntsModiToSon, 1)
        NextCheckTaunt(tauntTimerLength)
        return
      else
        tauntsNotEmpty = true
      end
    end
    if 2 <= phase and 0 < #phase2Taunts then
      game.Audio.PlayBanter(phase2Taunts[1])
      table.remove(phase2Taunts, 1)
      NextCheckTaunt(tauntTimerLength)
      return
    end
    if 0 < #phase1Taunts then
      game.Audio.PlayBanter(phase1Taunts[1])
      table.remove(phase1Taunts, 1)
      NextCheckTaunt(tauntTimerLength)
      return
    end
    if tauntsNotEmpty then
      NextCheckTaunt(2)
    end
  end
end
function IsTargeting(boss, testTarget)
  return testTarget == boss:GetTargetCreature()
end
function CheckAttention()
  if currentMagniTarget ~= "Hero" and IsTargeting(magni, player) then
    currentMagniTarget = "Hero"
    game.Audio.PlayBanterNonCritical("AttentionShift_MagniKratos")
  end
  if currentModiTarget ~= "Hero" and IsTargeting(modi, player) then
    currentModiTarget = "Hero"
    game.Audio.PlayBanterNonCritical("AttentionShift_ModiKratos")
  end
  if currentMagniTarget ~= "Son" and IsTargeting(magni, son) then
    currentMagniTarget = "Son"
    game.Audio.PlayBanterNonCritical("AttentionShift_MagniSon")
  end
  if currentModiTarget ~= "Son" and IsTargeting(modi, son) then
    currentModiTarget = "Son"
    game.Audio.PlayBanterNonCritical("AttentionShift_ModiSon")
  end
end
function SnowblindAttack(creature)
  if not LD.IsPositionInFrontOfObject(creature:GetWorldPosition(), player) then
    LD.CallFunctionAfterDelay(PlaySnowAlert, 0.25)
  end
end
function PlayBigModiHit()
  game.Audio.PlayBanterNonCritical("BrotherlyShoveHit_Magni")
end
function PlayBigMagniHit()
  game.Audio.PlayBanterNonCritical("BrotherlyShoveHit_Modi")
end
function InSnowblindOrTransitioning()
  return snowblindBool or magni:HasMarker("StageTransition") or magni:IsPlayingMove("MOV_BroRunImpact") or magni:IsPlayingMove("MOV_BroRunImpactClose")
end
function StartSnowblindMode()
  if phase == 1 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("BacktoBack1_Start", PlaySnowTaunt)
    end, 2)
  else
    LD.CallFunctionAfterDelay(PlaySnowTaunt, 2)
  end
  snowblindBool = true
end
function EndSnowblindMode()
  snowblindBool = false
  currentMagniTarget = ""
  currentModiTarget = ""
  firstPhaseTauntPlayed = false
  game.Audio.SetBanterFact("GenericBackToBackBanterAllowed", false, 10)
end
function FinishPlayingSnowTaunt()
  playingSnowTaunt = false
  if phase == 1 and #snow1Taunts == 0 or phase == 2 and #snow2Taunts == 0 then
    game.Audio.SetBanterFact("GenericBackToBackBanterAllowed", "True", "Infinite")
  end
end
function PlaySnowTaunt(atkType)
  if snowblindBool and atkType ~= "" and not playingSnowTaunt then
    if phase == 3 then
      return
    end
    if phase == 2 and 0 < #snow2Taunts then
      game.Audio.PlayBanter(snow2Taunts[1], FinishPlayingSnowTaunt)
      table.remove(snow2Taunts, 1)
      playingSnowTaunt = true
      return
    end
    if phase == 1 and 0 < #snow1Taunts then
      game.Audio.PlayBanter(snow1Taunts[1], FinishPlayingSnowTaunt)
      table.remove(snow1Taunts, 1)
      playingSnowTaunt = true
      return
    end
  end
end
function PlaySnowAlert()
  game.Audio.PlayBanterNonCritical("BacktoBackAlert")
end
function OutroStart()
  phase = 4
  game.Audio.PlayBanter("BacktoBack3_Final")
  game.SubObject.Sleep(thisObj)
end
function SetPhase(curPhase)
  if game.Level.GetVariable("CompletedCineNumber") == 358 and phase ~= curPhase then
    phase = curPhase
    NextCheckTaunt(2)
    firstPhaseTauntPlayed = false
    game.Audio.SetBanterFact("modimagniphase", curPhase, "Forever")
  end
end
function SetupMagniModi(magniBoss, modiBoss)
  magni = magniBoss
  modi = modiBoss
  game.SubObject.Wake(thisObj)
end
