local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisObj, keyType
local keyRunes = {}
local keys = {}
local challengeComplete = false
local keysUsed = 0
local RuneCellViewTrigger
local bInsideProxTrig = false
local bRuneCellSolved, bRuneCellCompleted
local bViewingCellGate = false
local RuneCellViewMonitor
local debug_toggle = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  for i = 1, 3 do
    keys[i] = GameObjects["prisonGate_breakable_0" .. tostring(i)]
    keyRunes[i] = obj:FindSingleGOByName("prisonGate_keyRune0" .. tostring(i))
  end
  SoundInit()
  game.SubObject.Sleep(thisObj)
end
function OnStart()
  if bRuneCellSolved then
    RuneCellViewMonitor = CreateLookAtMonitor(GameObjects.RuneCellViewTrigger, ViewingCellGate, NotViewingCellGate)
    RuneCellViewMonitor:Start()
  end
end
function OnPreStart(level, obj)
  local runeSymbolNumbers = {
    17,
    21,
    13
  }
  for i = 1, 3 do
    keyRunes[i].LuaObjectScript.SelectRune(runeSymbolNumbers[i])
  end
  if challengeComplete == false then
    for i = 1, 3 do
      keys[i].LuaObjectScript.OnBroken(function()
        KeyBroken(i)
      end)
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    challengeComplete = challengeComplete,
    keysUsed = keysUsed,
    bRuneCellSolved = bRuneCellSolved
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  challengeComplete = savedInfo.challengeComplete
  keysUsed = savedInfo.keysUsed
  bRuneCellSolved = savedInfo.bRuneCellSolved
end
function KeyBroken(index)
  local TUT = require("game.GlobalTutorials")
  keysUsed = keysUsed + 1
  keyRunes[index].LuaObjectScript.Disable()
  TUT.RunicProgress_Tutorial(keysUsed)
  game.Audio.PlaySound("SND_UX_Challenge_Progress")
  if keysUsed == 3 and challengeComplete == false then
    challengeComplete = true
    RuneCellSolved()
  end
end
function CreateLookAtMonitor(object, LookAt, LookAway)
  local lookAtMonitor = monitors.CreateLookAtMonitor(object:GetWorldPosition())
  lookAtMonitor:SetMinPercentFromScreenEdge(10)
  lookAtMonitor:OnLookAt(LookAt)
  lookAtMonitor:OnLookAway(LookAway)
  return lookAtMonitor
end
function RuneCellSolved()
  bRuneCellSolved = true
  if not RuneCellViewMonitor then
    RuneCellViewMonitor = CreateLookAtMonitor(GameObjects.RuneCellViewTrigger, ViewingCellGate, NotViewingCellGate)
    RuneCellViewMonitor:Start()
  end
end
function RunCheck()
  if bRuneCellSolved and bInsideProxTrig and bViewingCellGate then
    bRuneCellSolved = false
    OpenPrisonGate()
  end
end
function ViewingCellGate()
  bViewingCellGate = true
  RunCheck()
end
function NotViewingCellGate()
  bViewingCellGate = false
end
function RuneCellProxCheck_In()
  bInsideProxTrig = true
  RunCheck()
end
function RuneCellProxCheck_Out()
  bInsideProxTrig = false
end
function OpenPrisonGate()
  bRuneCellSolved = false
  GameObjects.PrisonGate:PlayAnimToEnd()
  PlaySoundPrisonGate()
  RuneCellViewMonitor:Stop()
  RuneCellViewMonitor:Terminate()
  RuneCellViewMonitor = nil
  GameObjects.RuneCellViewTrigger:HideEntityVolume()
  GameObjects.CA_Observe_Forward_Stn750_JailCell1.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Stn750_UpBracer.LuaObjectScript.Disable()
  GameObjects.CA_LookUnderObject_Stn750_JailCell.LuaObjectScript.Enable()
  _G.SetGateVar()
end
local SNDGate
function SoundInit()
  SNDGate = thisObj.SoundEmitters[1]
end
function PlaySoundPrisonGate()
  LD.PlaySoundOnFrame(SNDGate, GameObjects.PrisonGate, "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up", 28, "forward")
  LD.PlaySoundOnFrame(SNDGate, GameObjects.PrisonGate, "SND_DOOR_Metal_Lift_Gate_Forest_LP", 28, "forward")
  LD.PlaySoundOnFrame(SNDGate, GameObjects.PrisonGate, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling", 90, "forward")
  LD.StopSoundOnFrame(SNDGate, GameObjects.PrisonGate, "SND_DOOR_Metal_Lift_Gate_Forest_LP", 90, "forward")
end
