local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local VibrateTriggered = false
local crystalHolder, pillarBreakable, son, bGateDone
function OnScriptLoaded(level)
  crystalHolder = level:GetGameObject("Cockpit_01")
  pillarBreakable = level:GetGameObject("PillarPiece")
  son = game.AI.FindSon()
  SoundInit()
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") == 360 then
    son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
  end
  if game.Wallets.HasResource("HERO", "ChiselUnlock") then
    game.Compass.SetGatewayMarkerIsOpen("SM_750_Helper4", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("SM_750_Helper4", false)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    bGateDone = bGateDone
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bGateDone = savedInfo.bGateDone
end
function LoadCheck_Stn750_Stn600()
  game.UI.LoadCheck("Stn600_ChasmRoom")
end
function LoadCheck_Stn750_Stn700()
  game.UI.LoadCheck("Stn700_ChiselRoom")
end
function SetGateVar()
  bGateDone = true
end
function EnableCellCA()
  if not bGateDone then
    GameObjects.CA_Observe_Forward_Stn750_JailCell1.LuaObjectScript.Enable()
  end
end
function CreateLookAtMonitor(object, LookAt, LookAway)
  local lookAtMonitor = monitors.CreateLookAtMonitor(object:GetWorldPosition())
  lookAtMonitor:SetMinPercentFromScreenEdge(70)
  lookAtMonitor:OnLookAt(LookAt)
  lookAtMonitor:OnLookAway(LookAway)
  return lookAtMonitor
end
function Vibrate()
  if VibrateTriggered == false then
    VibrateTriggered = true
    GameObjects.Stn750_VibrateCrystalLight:Hide()
    PlaySoundCockpitDrop()
    crystalHolder:PlayAnimToEnd()
    pillarBreakable:PlayAnimToEnd()
    timer.StartLevelTimer(1, function()
      GameObjects.EEE_Stn750_CrystalDrop.LuaObjectScript.Trigger()
    end)
  end
end
function returnHallMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_chasm_retraversal_in")
end
local SNDCockpit
function SoundInit()
  SNDCockpit = crystalHolder:FindSingleSoundEmitterByName("SNDCockpit")
end
function PlaySoundCockpitDrop()
  LD.PlaySound(SNDCockpit, "SND_BRK_Ice_Metal_Cockpit_Stn750")
end
