local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisObj, thisLevel, player, son, myBreakableMonitor, Breakable_S2_Monitor_01, Breakable_S2_Monitor_02, Breakable_S2_Monitor_03, Breakable_S2_Monitor_04, Breakable_S2_Monitor_05, crystalHolder, fallAnimation, fallingCrystal
local Stage2Count = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  crystalHolder = thisLevel:GetGameObject("CrystalPuzzle_Stage1_Breakble_01")
  fallAnimation = thisObj:FindSingleGOByName("FallAnim")
  fallingCrystal = thisObj:FindSingleGOByName("CarryBifrostLight_Base5").Child
  myBreakableMonitor = monitors.CreateBreakableMonitor(crystalHolder)
  myBreakableMonitor:OnBreak(DropCrystal)
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function DropCrystal()
  GameObjects.blueLights:Hide()
  fallAnimation:PlayAnimToEnd()
  GameObjects.CA_PointUp_Stn800_LookAtBifrost.LuaObjectScript.Disable()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Reaction_Interest_Low_CrystalFall_Stn800.LuaObjectScript.Trigger()
  end, 0.9)
  fallAnimation:OnAnimDone(thisObj, "CrystalDropped")
  LD.PlaySoundOnFrame(fallingCrystal.SoundEmitters[1], fallAnimation, "SND_MAG_Temporal_Light_Crystal_Ground_Drop", 24, "forward")
  local stn800 = game.FindLevel("Stn800_Shortcut")
  if stn800 ~= nil then
    stn800:CallScript("Disable_CA_Stn800_Clue")
  end
end
function CrystalDropped()
  fallingCrystal.LuaObjectScript.EnableInteract()
end
