local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local color = require("core.color")
local thisObj, thisLevel, kraActor, sonActor, balActor, freActor, snowflake0, snowflake1
local baldurAftermathStarted = false
local cine_lights
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart()
  CreateActorsforBaldurDeath()
  cine_lights = GameObjects.Cine_Start_560
  HideCineLights()
  if game.Level.GetVariable("CompletedCineNumber") == 570 and not baldurAftermathStarted then
    LD.CallFunctionAfterDelay(PlayBaldurAftermath, 2)
  end
end
function OnSaveCheckpoint(level, obj)
  return {baldurAftermathStarted = baldurAftermathStarted}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  baldurAftermathStarted = savedInfo.baldurAftermathStarted
end
function CreateActorsforBaldurDeath()
  kraActor = actor.Actor.New("BALDUR DEATH: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("BALDUR DEATH: Son Actor", game.AI.FindSon)
  balActor = actor.Actor.New("BALDUR DEATH: Baldur Actor", ND.FindBaldur)
  freActor = actor.Actor.New("BALDUR DEATH: Freya Actor", ND.FindFreya)
end
function BaldurDeathSequence()
  local snowflake0 = GameObjects.snowflake00_Top.Child
  snowflake0:StartAnim("narStnBaldurDeath000CineScene")
  snowflake0:JumpAnimToFrame(0)
  snowflake0:PauseAnim()
  local snowflake1 = GameObjects.snowflake10_Top.Child
  snowflake1:StartAnim("narStnBaldurDeath000CineScene")
  snowflake1:JumpAnimToFrame(0)
  snowflake1:PauseAnim()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "BaldurDeath")
  local baldurDeath_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_BaldurDeath"
    },
    {
      Actor = balActor,
      Branch = "BRA_BaldurDeath"
    },
    {
      Actor = freActor,
      Branch = "BRA_BaldurDeath"
    },
    {
      Obj = snowflake0,
      Anim = "narStnBaldurDeath000CineScene"
    },
    {
      Obj = snowflake1,
      Anim = "narStnBaldurDeath000CineScene"
    }
  }
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(function()
    game.Audio.SetBanterFact("disableBoatLoreInWAD", false)
  end)
  cineSeq:SetPostSkipMusic("SND_MX_STN_boss_master", "SND_MX_STN_start_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:ActorSync(kraActor, {
    Slaves = baldurDeath_ActorTable,
    Branch = "BRA_BaldurDeath",
    ReferenceJoint = "BaldurDeath_SynchJoint"
  })
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:DespawnActor(balActor)
  cineSeq:DespawnActor(freActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(HideSnake)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(function()
    LD.UnlockHrimthursRevengeBoatLore()
    LD.CallFunctionAfterDelay(PlayBaldurAftermath, 2)
    BaldurDeathMusic()
  end)
  cineSeq:SetCompletedCineNumber(570)
  cineSeq:Do(AwardTrophy)
  cineSeq:Do(UnlockBestiaryEntry)
  cineSeq:Do(CompleteObjectiveReenableBoatloreAndBookmark)
  cineSeq:WaitForFunctionTrue(function()
    return game.UI.LoadCheck("Stn980_BossShoulder", "Stn090_LakeVista", "Stn900_BossSky", "Stn975_BossLighting", "Stn950_BossSound", "Cal080_Global", "WaterGlobal", "Stn910_c570_BaldurDeath", "BoatGlobal", "Stn905_ChiselSite", "Cal275_StonemasonLH", "Cal270_StoneMasonLH", "Cal050_Sound", "Cal075_Lighting") == 0
  end)
  cineSeq:StartSequence()
end
function PlayBaldurAftermath()
  game.Audio.PlayBanter("BaldurDeathAftermath")
  baldurAftermathStarted = true
  game.Audio.SetBanterFact("disableBoatLoreInWAD", false)
end
function BaldurDeathMusic()
  local stn950 = game.FindLevel("Stn950_BossSound")
  if stn950 then
    stn950:CallScript("BaldurDeath")
  end
end
function CompleteObjectiveReenableBoatloreAndBookmark()
  UpdateCompass()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective860", "Complete")
  LD.ActivateQuest("Quest_MothersAshes_Parent")
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "34_StoneMason_020_BaldurKilled"]
  game.Compass.SetDesignerForcedHide(false)
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function AwardTrophy()
  print("Trophy Awarded: Not My First Giant")
  game.UnlockTrophy(10)
end
function UnlockBestiaryEntry()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_FreyaBrood")
end
function HideSnake()
  local snake = GameObjects.worldsnake00_Top.Child
  snake:Hide()
end
function PlayCineLights()
  cine_lights:Show()
  cine_lights:JumpAnimToFrame(0)
  cine_lights:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights:Hide()
end
function UpdateCompass()
  LD.SetMarkerState("SM_600_VendorLocation", 0)
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_013", false)
end
