local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, kraActor, sonActor, balActor, freActor, stoneActor, vineActor, vineActor1, vineActor2, mistletoeArrow, baldurRockA, cine_lights
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart()
  if game.Level.GetVariable("CompletedCineNumber") < 550 then
    CreateActors()
    SpawnVine1()
    SpawnVine2()
  end
  cine_lights = GameObjects.Cine_Start_550
  HideCineLights()
end
local FindVines = function()
  local objArray = game.World.FindGameObjectsByMarker("freyavines00")
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
      local vineObj = obj:GetCreature():GetAI()
      if vineObj:HasMarker("CineVine") then
        return vineObj
      end
    end
  end
  return nil
end
function CreateActors()
  kraActor = actor.Actor.New("FINAL FIGHT INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("FINAL FIGHT INTRO: Son Actor", game.AI.FindSon)
  balActor = actor.Actor.New("FINAL FIGHT INTRO: Baldur Actor", ND.FindBaldur)
  freActor = actor.Actor.New("FINAL FIGHT INTRO: Freya Actor", ND.FindFreya)
  stoneActor = actor.Actor.New("FINAL FIGHT INTRO: StoneMason Actor", ND.FindStoneMason)
  vineActor = actor.Actor.New("FINAL FIGHT INTRO: Vine0 Actor", FindVines)
  vineActor1 = actor.Actor.New("FINAL FIGHT INTRO: Vine1 Actor")
  vineActor2 = actor.Actor.New("FINAL FIGHT INTRO: Vine2 Actor")
  mistletoeArrow = GameObjects.mistletoeArrow00_Top.Child
  baldurRockA = GameObjects.rockABaldurReturns00_Top.Child
  HideProps()
end
function SpawnVine1()
  vineActor1:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_ShieldsDown_Group", "vines0_ShieldsDown_StartJoint1", "CRT_FreyaVines00", "BRA_ShieldsDown1", "vines1")
  end)
end
function SpawnVine2()
  vineActor2:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_ShieldsDown_Group", "vines0_ShieldsDown_StartJoint2", "CRT_FreyaVines00", "BRA_ShieldsDown2", "vines2")
  end)
end
function ShieldsDownSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "ShieldsDown")
  local shieldsDown_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_ShieldsDown"
    },
    {
      Actor = balActor,
      Branch = "BRA_ShieldsDown"
    },
    {
      Actor = freActor,
      Branch = "BRA_ShieldsDown"
    },
    {
      Actor = stoneActor,
      Branch = "BRA_ShieldsDown"
    },
    {
      Actor = vineActor,
      Branch = "BRA_ShieldsDown"
    },
    {
      Actor = vineActor1,
      Branch = "BRA_ShieldsDown1"
    },
    {
      Actor = vineActor2,
      Branch = "BRA_ShieldsDown2"
    },
    {
      Obj = mistletoeArrow,
      Anim = "narStnShieldsDown000CineScene"
    },
    {
      Obj = baldurRockA,
      Anim = "narStnShieldsDown000CineScene"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_STN_boss_master", "SND_MX_STN_start_master", nil, nil, "SND_MX_STN_baldur3_mason_carry")
  cineSeq:MarkAbleToSkip()
  cineSeq:WaitForLoadCheck("Stn910_c550_ShieldsDown")
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:SpawnActorAndWait(vineActor1)
  cineSeq:SpawnActorAndWait(vineActor2)
  cineSeq:WaitForActorPlayingMove(kraActor, "MOV_CSBaldurSlamUppercutExit")
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.5)
  cineSeq:Do(ShowRock)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.98)
  cineSeq:Do(ShowMistletoe)
  cineSeq:Do(PlayCineLights)
  cineSeq:ActorSync(kraActor, {
    Slaves = shieldsDown_ActorTable,
    Branch = "BRA_ShieldsDown",
    ReferenceJoint = "ShieldsDown_SynchJoint"
  })
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 635)
  cineSeq:Do(SwitchToBrokenQuiver)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.94)
  cineSeq:Do(function()
    if not cineSeq.skipping then
      cineSeq.ableToSkip = false
      game.SetAbleToSkip(false)
    end
  end)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(2)
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.98)
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:Do(FadeToBlack)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:WaitForActorNotPlayingMove(sonActor, "MOV_ShieldsDown")
  cineSeq:WaitForActorNotPlayingMove(freActor, "MOV_ShieldsDown")
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(freActor)
  cineSeq:StopPuppetingActor(balActor)
  cineSeq:StopPuppetingActor(stoneActor)
  cineSeq:StopPuppetingActor(vineActor1)
  cineSeq:StopPuppetingActor(vineActor2)
  cineSeq:DespawnActor(freActor)
  cineSeq:DespawnActor(vineActor1)
  cineSeq:DespawnActor(vineActor2)
  cineSeq:Do(HideProps)
  cineSeq:Do(HideCineLights)
  cineSeq:SetCompletedCineNumber(550)
  cineSeq:StartSequence()
end
function ShowMistletoe()
  mistletoeArrow:Show()
end
function ShowRock()
  baldurRockA:Show()
  baldurRockA:JumpAnimationToFrame(0, {
    Animation = "narStnShieldsDown000CineScene"
  })
  baldurRockA:PauseAnimation()
end
function HideProps()
  mistletoeArrow:Hide()
  baldurRockA:Hide()
end
function FadeToBlack()
  uiCalls.UI_Event_Fade_To_Black(1)
end
function PlayCineLights()
  cine_lights:Show()
  cine_lights:JumpAnimToFrame(0)
  cine_lights:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights:Hide()
end
function SwitchToBrokenQuiver()
  ND.SafePickupSetStage(sonActor:GetCreature(), "SonStrap_Visual", 1)
end
