local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, kraActor, sonActor, balActor, stoneActor, freActor, vineActor, vineActor1, vineActor2
local stoneMasonKillBool = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function CreateActors()
  kraActor = actor.Actor.New("MASON KILL: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("MASON KILL: Son Actor", game.AI.FindSon)
  balActor = actor.Actor.New("MASON KILL: Baldur Actor", ND.FindBaldur)
  stoneActor = actor.Actor.New("MASON KILL: StoneMason Actor", ND.FindStoneMason)
  freActor = actor.Actor.New("MASON KILL: Freya Actor")
  vineActor = actor.Actor.New("MASON KILL: Vine0 Actor")
  vineActor1 = actor.Actor.New("MASON KILL: Vine1 Actor")
  vineActor2 = actor.Actor.New("MASON KILL: Vine2 Actor")
  SpawnFreya()
  SetSpawnFunctions()
end
function SpawnFreya()
  freActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "CombatCine_StoneMasonKill_Group", "Freya_StoneMasonKill_StartJoint", "CRT_Freya00", "BRA_CSStoneMasonKill", "freya")
  end)
end
function SetSpawnFunctions()
  local wad980 = game.FindLevel("Stn980_BossShoulder")
  vineActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(wad980, "CombatCine_StoneMasonKill_Group", "FreyaVines_StoneMasonKill_StartJoint", "CRT_FreyaVines00", "BRA_CSStoneMasonKill", "vines")
  end)
  vineActor1:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(wad980, "CombatCine_StoneMasonKill_Group", "FreyaVines_StoneMasonKill_StartJoint1", "CRT_FreyaVines00", "BRA_CSStoneMasonKill1", "vines1")
  end)
  vineActor2:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(wad980, "CombatCine_StoneMasonKill_Group", "FreyaVines_StoneMasonKill_StartJoint2", "CRT_FreyaVines00", "BRA_CSStoneMasonKill2", "vines2")
  end)
end
function StoneMasonKillSequence()
  CreateActors()
  local snake = GameObjects.worldsnake00_Top.Child
  snake:StartAnim("phase3_csStoneMasonKill")
  snake:JumpAnimToFrame(0)
  snake:PauseAnim()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "StoneMasonKill")
  local stoneMasonKill_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_CSStoneMasonKill"
    },
    {
      Actor = balActor,
      Branch = "BRA_CSStoneMasonKill"
    },
    {
      Actor = stoneActor,
      Branch = "BRA_StoneMason_FinalKill"
    },
    {
      Actor = freActor,
      Branch = "BRA_CSStoneMasonKill"
    },
    {
      Obj = snake,
      Anim = "phase3_csStoneMasonKill"
    },
    {
      Actor = vineActor,
      Branch = "BRA_CSStoneMasonKill"
    },
    {
      Actor = vineActor1,
      Branch = "BRA_CSStoneMasonKill1"
    },
    {
      Actor = vineActor2,
      Branch = "BRA_CSStoneMasonKill2"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_STN_boss_master", "SND_MX_STN_start_master", "SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_STN_baldur_death", nil, "SND_MX_CAL_snake_belly_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:WaitForLoadCheck("Stn910_BossEntrance")
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:SpawnActorAndWait(freActor)
  cineSeq:SpawnActorAndWait(vineActor)
  cineSeq:SpawnActorAndWait(vineActor1)
  cineSeq:SpawnActorAndWait(vineActor2)
  cineSeq:ActorSync(kraActor, {
    Slaves = stoneMasonKill_ActorTable,
    Branch = "BRA_CSStoneMasonKill",
    ReferenceJoint = "BaldurDeathConnect_SynchJoint"
  })
  cineSeq:Do(function()
    GameObjects.Mason_Kill_Pebbles.Child:PlayAnimToEnd()
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.8)
  cineSeq:Do(function()
    cineSeq:SetMaxSkipSpeedup(1)
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(balActor)
  cineSeq:StopPuppetingActor(stoneActor)
  cineSeq:StopPuppetingActor(freActor)
  cineSeq:StopPuppetingActor(vineActor1)
  cineSeq:StopPuppetingActor(vineActor2)
  cineSeq:DespawnActor(vineActor1)
  cineSeq:DespawnActor(vineActor2)
  cineSeq:Do(function()
    snake:Hide()
  end)
  cineSeq:Do(function()
    local localLevel = game.FindLevel("Stn910_BossEntrance")
    if localLevel ~= nil then
      local newObject = localLevel:FindSingleGameObject("Cine_BaldurDeath_Group")
      if newObject ~= nil then
        newObject:CallScript("BaldurDeathSequence")
      end
    end
  end)
  cineSeq:StartSequence()
end
