local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local thisLevel, Area_1_Encounter_3
function OnScriptLoaded(level)
  thisLevel = level
  Golem_Bonus()
end
function OnFirstStart(level)
  LD.SetEntityVariable("STN_FinalBossStarted", true)
  GameObjects.Hand_Alt:Hide()
  GameObjects.Hand_Alt:HideCollision()
  GameObjects.Mason_Body:Hide()
  GameObjects.Mason_Body:HideCollision()
  CleanupDock_FinalBoss()
end
function OnStart(level)
  if LD.GetEntityVariable("STN_IceGolemAlive") == true and game.Level.GetVariable("CompletedCineNumber") > 609 then
    Area_1_Encounter_3:Start()
    LD.SetMarkerState("STN_200_AncientFight", 1)
  end
end
function OnUpdate(level)
  if game.Level.GetVariable("CompletedCineNumber") <= 550 then
    GameObjects.loadFinalBossFightZone:ShowEntityVolume()
    GameObjects.loadZone_EndGame:HideEntityVolume()
    GameObjects.LoadZone_BeforeDoor:HideEntityVolume()
  else
    GameObjects.loadFinalBossFightZone:HideEntityVolume()
    GameObjects.loadZone_EndGame:ShowEntityVolume()
    GameObjects.LoadZone_BeforeDoor:ShowEntityVolume()
    GameObjects.DockBlocker:Hide()
    GameObjects.DockBlocker:HideCollision()
    GameObjects.NavObstacle_Rock:HideNavObstacle()
  end
end
function OnSaveCheckpoint(level)
end
function OnRestoreCheckpoint(level, savedInfo)
end
function WarpFromSnakeBelly()
  local boat = game.Boat.GetPlayerBoat()
  if boat then
    boat:Warp(GameObjects.snakeExitLocation.WorldPosition, GameObjects.snakeExitLocation:GetWorldForward())
    timers.StartLevelTimer(1, function()
      uiCalls.UI_Event_Fade_In(1)
    end)
    GameObjects.Cine_FinalFightIntro_Group.LuaObjectScript.FinalFightIntroSequence()
    timers.StartLevelTimer(10, function()
      GameObjects.loadFinalBossFightZone:ShowEntityVolume()
    end)
  else
    game.Player.FindPlayer():Warp(GameObjects.snakeExitLocation.WorldPosition, GameObjects.snakeExitLocation:GetWorldForward())
    uiCalls.UI_Event_Fade_In(1)
  end
end
function DebugInitHandPose()
  GameObjects.Hand_Alt:Hide()
  GameObjects.Hand_Alt:HideCollision()
  GameObjects.Mason_Body:Hide()
  GameObjects.Mason_Body:HideCollision()
  CleanupDock_FinalBoss()
end
function HideVis()
  GameObjects.Stn100_Vis_NoOffset:Hide()
  GameObjects.hands_start:Hide()
end
function ShowVis()
  GameObjects.Stn100_Vis_NoOffset:Show()
end
function SwapHandPose()
  GameObjects.Hand_Alt:Show()
  GameObjects.Hand_Alt:ShowCollision()
  GameObjects.hands_start:Hide()
  GameObjects.hands_start:HideCollision()
  GameObjects.Mason_Body:Show()
  GameObjects.Mason_Body:ShowCollision()
end
function CleanupDock_FinalBoss()
  GameObjects.HIDEABLE_OBJECTS:Hide()
  GameObjects.HIDEABLE_OBJECTS:HideCollision()
end
function StartBaldurFreyaRock()
  GameObjects.baldur_freya_rock_break.Child:PlayAnimToEnd()
end
function ResetBaldurFreyaRock()
  GameObjects.baldur_freya_rock_break.Child:PlayAnimToFrame(0, -30)
end
function ChiselQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Find_SM")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Find_SM")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Find", 1)
  end
end
function Golem_Bonus()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Stn910 Golem", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneStn910",
    AutoResetOnReload = true
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Golem_I_SFG",
      spawnLocators = "A1_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.01
    }
  })
  Area_1_Encounter_3:OnComplete(function()
    LD.SetEntityVariable("STN_IceGolemAlive", false)
    LD.SetMarkerState("STN_200_AncientFight", 0)
  end)
end
local skippedFinalFightIntro = false
function OnSkipFinalFightIntro()
  skippedFinalFightIntro = true
end
function FinalFightMusicDelay()
  if not skippedFinalFightIntro then
    game.Audio.StartMusic("SND_MX_STN_baldur3_fight1_prelap")
  end
end
