local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local DL = require("design.DesignerLibrary")
local player, baldur, calloutTimer
local allowCallouts = false
local currentlyPlayingCallout = false
local playedRootingStart = false
local phase1_BaldurAttack = {
  "Baldur3_Phase1_Attack",
  "Baldur3_Phase1_Attack",
  "Baldur3_Phase1_Attack",
  "Baldur3_Phase1_Attack"
}
local phase1Callouts_Ice = {
  "Baldur3_Phase1_Elements_Freeze_Callout1",
  "Baldur3_Phase1_Elements_Freeze_Callout2",
  "Baldur3_Phase1_Elements_Freeze_Callout3"
}
local phase1Callouts_Fire = {
  "Baldur3_Phase1_Elements_Fire_Callout1",
  "Baldur3_Phase1_Elements_Fire_Callout2",
  "Baldur3_Phase1_Elements_Fire_Callout3"
}
local phase2_ProjectionGrabBaldur = "Baldur3_Phase2_Roots_BaldurStruggle"
local phase2_ProjectionBaldurBreak = "Baldur3_Phase2_Roots_BaldurBreak"
local phase2_ProjectionSonBreak = {
  "Baldur3_Phase2_Roots_SonBreak1",
  "Baldur3_Phase2_Roots_SonBreak2"
}
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function GetBaldur()
  baldur = ND.FindBaldur()
end
function StartPhase0()
  game.Audio.SetBanterFact("stonemasonPhase", 0, "Infinite")
end
function FinishPlayingCallout()
  currentlyPlayingCallout = false
end
function PlayHawkAndShove()
  currentlyPlayingCallout = true
  game.Audio.PlayBanter("HawkAndShove", FinishPlayingCallout, true)
end
function StartVineAttackPhase0()
  if not currentlyPlayingCallout and not playedRootingStart then
    game.Audio.PlayBanter("Baldur3_Phase0_Rooting_Start")
    playedRootingStart = true
  end
  timers.StartLevelTimer(0.5, PreCheckVineHitPhase0)
end
local snaredKratos = false
local snaredBaldur = false
function PreCheckVineHitPhase0()
  GetBaldur()
  snaredKratos = DL.CheckCreatureContext(player:GetContext(), "FREYA_VINE_GRAB")
  snaredBaldur = DL.CheckCreatureContext(baldur:GetContext(), "FREYA_VINE_GRAB")
  timers.StartLevelTimer(0.5, CheckVineHitPhase0)
end
function CheckVineHitPhase0()
  GetBaldur()
  snaredKratos = snaredKratos or DL.CheckCreatureContext(player:GetContext(), "FREYA_VINE_GRAB")
  snaredBaldur = snaredBaldur or DL.CheckCreatureContext(baldur:GetContext(), "FREYA_VINE_GRAB")
  if not currentlyPlayingCallout then
    if snaredBaldur then
      if snaredKratos then
        game.Audio.SetBanterFact("StonemasonVineGrabbed", "Both", "Encounter")
      else
        game.Audio.SetBanterFact("StonemasonVineGrabbed", "Baldur", "Encounter")
      end
    elseif snaredKratos then
      game.Audio.SetBanterFact("StonemasonVineGrabbed", "Kratos", "Encounter")
    else
      game.Audio.SetBanterFact("StonemasonVineGrabbed", "None", "Encounter")
    end
    game.Audio.PlayBanter("Baldur3_Phase0_Rooting_Struggle", FinishPlayingCallout, true)
    currentlyPlayingCallout = true
    playedRootingStart = false
  end
  snaredBaldur = false
  snaredKratos = false
end
function StartPhase1()
  game.Audio.SetBanterFact("stonemasonPhase", 1, "Infinite")
end
function StartPhase1Elements()
  allowCallouts = true
  ResetPhase1ElementsCallouts(7)
end
function ResetPhase1ElementsCallouts(customTime)
  if calloutTimer then
    StopCallouts()
  end
  if allowCallouts then
    calloutTimer = timers.StartLevelTimer(customTime or 20, PlayCallout_Phase1Elements)
  end
end
function ForceStopCallouts()
  allowCallouts = false
  StopCallouts()
end
function StopCallouts()
  if calloutTimer ~= nil then
    calloutTimer:Stop()
    calloutTimer = nil
  end
end
function PlayCallout_Phase1Elements()
  GetBaldur()
  ResetPhase1ElementsCallouts(5)
  if baldur:PickupIsAcquired("Baldur_IceMode") then
    if 0 < #phase1Callouts_Ice then
      game.Audio.PlayBanterNonCritical(phase1Callouts_Ice[1], nil, nil, true, function()
        ResetPhase1ElementsCallouts()
        table.remove(phase1Callouts_Ice, 1)
      end)
    end
  elseif 0 < #phase1Callouts_Fire then
    game.Audio.PlayBanterNonCritical(phase1Callouts_Fire[1], nil, nil, true, function()
      ResetPhase1ElementsCallouts()
      table.remove(phase1Callouts_Fire, 1)
    end)
  end
end
function PlayBaldurAttack_Phase1()
  game.Audio.PlayBanterNonCritical(phase1_BaldurAttack[math.random(#phase1_BaldurAttack)])
end
function StartPhase2()
  game.Audio.SetBanterFact("stonemasonPhase", 2, "Encounter")
end
function PlayRooting_Phase2_BaldurStruggle()
  game.Audio.PlayBanterNonCritical(phase2_ProjectionGrabBaldur)
end
function PlayRooting_Phase2_BaldurBreak()
  game.Audio.PlayBanterNonCritical(phase2_ProjectionBaldurBreak)
end
function PlayRooting_Phase2_SonBreak()
  game.Audio.PlayBanterNonCritical(phase2_ProjectionSonBreak[math.random(#phase2_ProjectionSonBreak)])
end
function StartPhase3()
  allowCallouts = true
  ResetPhase3Callouts(5)
  game.Audio.SetBanterFact("stonemasonPhase", 3, "Infinite")
end
function ResetPhase3Callouts(customTime)
  if calloutTimer then
    StopCallouts()
  end
  if allowCallouts then
    calloutTimer = timers.StartLevelTimer(customTime or 15, PlayCallout_Phase3)
  end
end
function PlayCallout_Phase3()
  ResetPhase3Callouts(5)
  game.Audio.PlayBanterNonCritical("Baldur3_Phase3_Callout", nil, nil, true, ResetPhase3Callouts)
end
