local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local EC = require("design.Encounter")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local BossEncounter = require("boss.statemachine")
local CCOS = require("camera.camera_oneshot")
local checkpoint = require("level.checkpoint")
local mpicon = require("ui.mpicon")
local thisLevel, varBossStage
local beginFromFinalFightIntro = false
local banterScript, player, son, stoneMason, baldur, freya, cineVines, worldSnake
local isReload = false
local reloadFade = false
local pad, timerPhase0
local cookieIntro = false
local Phase2_IntroProjectionEncounter, Phase2_MainProjectionEncounter, Phase2_MainProjectionEncounter_RestartTimer
local transitionChiselLift = false
local baldurEnterPhase1 = false
local kratosRageReady = false
local kratosRageActivated = false
local masonKillStart = false
local backToBack_BaldurLocators = {}
local backToBack_BaldurPosition
local backToBack_BaldurWarpCount = 0
local backToBack_BaldurWarpDelayTimer
local backToBack_BaldurReadyToWarp = false
local backToBack_DurationTimer, backToBack_CameraOrbitString
local backToBack_Start = false
local backToBack_Complete = false
local backToBack_bntrPlayed
local backToback_bntrTaunt_01 = "Baldur3_BacktoBack1"
local backToback_bntrTaunt_02 = "Baldur3_BacktoBack2"
local backToback_bntrTaunt_03 = "Baldur3_BacktoBack3"
local backToback_bntrTaunt_04 = "Baldur3_BacktoBack4"
local vineSummonReady = false
local iceBreathSnowblind = false
local iceBreathSnowblindTimer = 30
local baldurRockThrowBroken = false
local relicRoomBroken = false
local slingshotWallBroken = false
local woodBeamBroken = false
local chiselRoomBroken = false
local Baldur_HealthBar_On = false
local BaldurHealthTotal = 0
local BaldurHealthMax_Phase_0 = 0
local BaldurHealthMin_Phase_0 = 0
local BaldurHealthMax_Phase_1A = 0
local BaldurHealthMin_Phase_1A = 0
local BaldurHealthMax_Phase_1B = 0
local BaldurHealthMin_Phase_1B = 0
local BaldurHealthMax_Phase_2 = 0
local BaldurHealthMin_Phase_2 = 0
local BaldurHealthMax_Phase_4 = 0
local BaldurHealthMin_Phase_4 = 0
local BaldurHealthTrigger_ElementTransition = 0
local BaldurHealthTrigger_StoneMasonAttack_01 = 0
local BaldurHealthTrigger_StoneMasonAttack_02 = 0
local BaldurHealthTrigger_StoneMasonAttack_03 = 0
local BaldurHealthTrigger_StoneMasonAttack_04 = 0
local BaldurHealthTrigger_StoneMasonAttack_05 = 0
local Kratos_HandLift_Struggle = false
local Son_ShootHand_Window = false
local Son_MMADefShot_Window = false
local Son_MMAHangShot_Window = false
local Son_MMAChoke_Window = false
local Kratos_MMAChoke_Window = false
local Son_Beatdown_Whiff_01 = false
local Son_Beatdown_Whiff_02 = false
local Son_Beatdown_Whiff_03 = false
local oneshotCameraMasonGroundPoundIntro, oneshotCameraCookieIntro, oneshotSnowBlindHoldHack
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  pad = player.Pad
  BossEncounter:AddCreature("BaldurSpawner")
  banterScript = GameObjects.Btr_FinalFight.LuaObjectScript
  BossEncounter:SetDebugInput(true)
  Phase2_CreateIntroProjectionEncounter()
  Phase2_CreateMainProjectionEncounter()
end
function OnFirstStart(level)
  varBossStage = 0
end
function OnStart(level)
  if baldur == nil then
    baldur = BossEncounter:GetBoss()
    if baldur:PickupIsAcquired("Baldur_Phase") then
      baldur:PickupRelinquish("Baldur_Phase")
      GetBaldurHealthVariables()
    end
  else
    baldur = BossEncounter:GetBoss()
    if baldur:PickupIsAcquired("Baldur_Phase") then
      baldur:PickupRelinquish("Baldur_Phase")
      GetBaldurHealthVariables()
    end
  end
  GameObjects.Stn980_Stage_0:HideEntityVolume()
  GameObjects.Stn980_Stage_1:HideEntityVolume()
  GameObjects.Stn980_Stage_2:HideEntityVolume()
  GameObjects.Stn980_Stage_3:HideEntityVolume()
  GameObjects.Stn980_Stage_4:HideEntityVolume()
  GameObjects.Phase2_ChiselLift_Zone:HideEntityVolume()
  GameObjects.ChiselClimb_placeholder:Hide()
  GameObjects.ChiselClimb_placeholder:HideCollision()
  GameObjects.ChiselClimb_placeholder:HideTraversePath()
  GameObjects.ContextAction_Son_ShootFromPoint.LuaObjectScript.Disable()
end
function OnUpdate(level)
  if game.Level.GetVariable("CompletedCineNumber") == 540 and BossEncounter:GetActiveIndex() == 1 then
    BossEncounter:ForwardState()
  end
  if stoneMason ~= nil and stoneMason:HasMarker("Attacking") == true then
    if stoneMason:HasMarker("Shockwave") == true then
      game.Camera.SubmitCameraByName("CBT_StoneMason_Tell_HammerFist_Shockwave")
    elseif stoneMason:HasMarker("HammerFist") == true then
      game.Camera.SubmitCameraByName("CBT_StoneMason_Tell_HammerFist_EQ")
    end
    game.Camera.SubmitCameraByName("CBT_StoneMason_Wide_Xtreme")
  end
  if oneshotSnowBlindHoldHack ~= nil then
    oneshotSnowBlindHoldHack:Update()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  isReload = true
  checkpoint.Restore(savedInfo.levelstate)
end
local BossStage_0_1 = BossEncounter:AddStage("BossStage_0_1", true)
local BossStage_0_2 = BossEncounter:AddStage("BossStage_0_2")
local BossStage_0_3 = BossEncounter:AddStage("BossStage_0_3")
local BossStage_1_1 = BossEncounter:AddStage("BossStage_1_1")
local BossStage_1_2 = BossEncounter:AddStage("BossStage_1_2")
local BossStage_1_3 = BossEncounter:AddStage("BossStage_1_3", true)
local BossStage_1_4 = BossEncounter:AddStage("BossStage_1_4")
local BossStage_1_5 = BossEncounter:AddStage("BossStage_1_5")
local BossStage_1_6 = BossEncounter:AddStage("BossStage_1_6", true)
local BossStage_2_0 = BossEncounter:AddStage("BossStage_2_0")
local BossStage_2_1 = BossEncounter:AddStage("BossStage_2_1", true)
local BossStage_2_2 = BossEncounter:AddStage("BossStage_2_2")
local BossStage_2_3 = BossEncounter:AddStage("BossStage_2_3", true)
local BossStage_3_1 = BossEncounter:AddStage("BossStage_3_1")
local BossStage_3_2 = BossEncounter:AddStage("BossStage_3_2")
local BossStage_3_3 = BossEncounter:AddStage("BossStage_3_3")
local BossStage_4_1 = BossEncounter:AddStage("BossStage_4_1", true)
local BossStage_4_2 = BossEncounter:AddStage("BossStage_4_2")
local BossStage_4_3 = BossEncounter:AddStage("BossStage_4_3")
local BossStage_5_0 = BossEncounter:AddStage("BossStage_5_0")
local BossStage_5_1 = BossEncounter:AddStage("BossStage_5_1")
function BossStage_0_1:OnEnter(level)
  StageSetup(0, "PHASE 0-1: FIGHT WITH INVULNERABLE BALDUR")
  player:MeterSetValue("Health", 5000)
  local resetLevel = game.FindLevel("Stn910_BossEntrance")
  if resetLevel ~= nil then
    resetLevel:CallScript("DebugInitHandPose")
  end
  son:CallScript("LuaHook_DisableAutonomousSon")
  game.Combat.TurnOnAndLockCombatStatus()
  if not beginFromFinalFightIntro then
    local spawnPos = DL.GetMarkerPosition(thisLevel, "Freya_Locator")
    local spawnFace = DL.GetMarkerRotation(thisLevel, "Freya_Locator")
    if freya == nil then
      freya = game.AI.Spawn(level, spawnPos, spawnFace, "CRT_Freya00", "BRA_Spawn_StoneMasonBoss")
      if not freya:PickupIsAcquired("Freya_StoneMasonBoss") then
        freya:PickupAcquire("Freya_StoneMasonBoss")
      end
    end
  end
  baldur:CallScript("SetHostile")
  baldur:TriggerMoveEvent("kLETauntInvite_Decision")
  if baldur:PickupIsAcquired("Baldur_Invulnerable") == false then
    baldur:PickupAcquire("Baldur_Invulnerable")
  end
  if Baldur_HealthBar_On == false then
    Baldur_HealthBar_On = true
    baldur:CallScript("LuaHook_ShowHealth", baldur)
  end
  timerPhase0 = timers.StartLevelTimer(180, function()
    if baldur:HasMarker("SM_Phase0_Complete") == false then
      baldur:AddMarker("SM_Phase0_Complete")
    end
  end)
  if not beginFromFinalFightIntro then
    banterScript.StartPhase0()
  end
  if BossEncounter:IsDebugSkip() or isReload then
    isReload = false
    TeleportKratosSonBaldur("Ph0_Start_Kratos", "Ph0_Start_Son", "Ph0_Start_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    SonClearAvailabilityRequests()
    baldur:MeterSetValue("Health", BaldurHealthMax_Phase_0)
    baldur:CallScript("LuaHook_SM_Phase0_ResetHealth")
    if baldur:PickupIsAcquired("Baldur_Invulnerable") == false then
      baldur:PickupAcquire("Baldur_Invulnerable")
    end
    if baldur:HasMarker("SM_Phase0_Complete") == true then
      baldur:RemoveMarker("SM_Phase0_Complete")
    end
    DL.WarpCreature(freya, thisLevel, "Freya_Locator")
    if cineVines ~= nil then
      cineVines:Destroy()
    end
    isReload = false
  end
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_fight1_in")
end
function BossStage_0_1:OnUpdate(level)
  if baldur:HasMarker("TauntHealing") and baldur:PickupIsAcquired("Baldur_HealingFactor") == false then
    baldur:PickupAcquire("Baldur_HealingFactor")
  end
  if baldur:PickupIsAcquired("Baldur_HealingFactor") and baldur:GetHitPoints() == baldur:MeterGetMax("Health") then
    baldur:PickupRelinquish("Baldur_HealingFactor")
  end
  if baldur:GetHitPoints() <= BaldurHealthMin_Phase_0 and IsBaldurReadyToTransition() or baldur:HasMarker("SM_Phase0_Complete") or player:MeterGetValue("Health") <= player:MeterGetMax("Health") * 0.15 then
    BossEncounter:ForwardState()
  end
end
function BossStage_0_1:OnExit(level)
  if baldur:HasMarker("SM_Phase0_Complete") == true then
    baldur:RemoveMarker("SM_Phase0_Complete")
  end
  if timerPhase0 ~= nil then
    timerPhase0:Stop()
  end
end
function BossStage_0_2:OnEnter(level)
  StageSetup(0, "PHASE 0-2: BALDUR STARTS TRANSITION")
  if baldur:HasMarker("StageTransition") == false then
    baldur:AddMarker("StageTransition")
  end
  if baldur:HasMarker("SM_Phase0_Complete") == true then
    baldur:RemoveMarker("SM_Phase0_Complete")
  end
  local spawnPos = DL.GetMarkerPosition(thisLevel, "Ph0_ShieldsDown_Vines")
  local spawnFace = DL.GetMarkerRotation(thisLevel, "Ph0_ShieldsDown_Vines")
  if cineVines == nil then
    cineVines = game.AI.Spawn(level, spawnPos, spawnFace, "CRT_FreyaVines00", "BRA_Spawn_CSBaldurSlamUppercut")
  end
  if BossEncounter:IsDebugSkip() then
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:TriggerMoveEvent("LE_PhaseTransitionAttackDecision")
  end
end
function BossStage_0_2:OnUpdate(level)
  local CSShieldsDownRot = baldur:GetAnimDriver("BaldurSlamUpperEnterRot")
  CSShieldsDownRot.ValueVec = baldur:GetWorldPosition() - thisLevel:FindSingleGameObject("Ph0_CSBaldurSlamUpper_Rot"):GetWorldPosition()
  DL.SetMotionWarpDrivers(thisLevel, player, "BaldurSlamUpperTrans", "BaldurSlamUpperRot", "Ph0_CSBaldurSlamUpper_Trans")
  if player:IsPlayingMove("MOV_CSBaldurSlamUppercutEnter") and Baldur_HealthBar_On == true then
    SonDisableCombat()
    ClearStatusEffect()
    ClearSonSpecialAttacks()
    son:AddMarker("TweakPOIResOnly")
    game.Combat.RemoveArrows(baldur)
    Baldur_HealthBar_On = false
    baldur:CallScript("LuaHook_HideHealth", baldur)
    if baldur:PickupIsAcquired("Baldur_HealingFactor") then
      baldur:PickupRelinquish("Baldur_HealingFactor")
    end
    uiCalls.UI_Event_Force_Combat_HUD_Off()
    InitStoneMason("BRA_StoneMason_WaitForShieldsDown")
  end
  if player:IsPlayingMove("MOV_CSBaldurSlamUppercutExit") then
    BossEncounter:ForwardState()
  end
end
function BossStage_0_2:OnExit(level)
  if baldur:HasMarker("StageTransition") then
    baldur:RemoveMarker("StageTransition")
  end
  if baldur:PickupIsAcquired("Baldur_Invulnerable") == true then
    baldur:PickupRelinquish("Baldur_Invulnerable")
  end
  if baldur:PickupIsAcquired("Baldur_HealingFactor") then
    baldur:PickupRelinquish("Baldur_HealingFactor")
  end
end
function BossStage_0_3:OnEnter(level)
  StageSetup(0, "PHASE 0-3: SHIELDS DOWN CINEMATIC")
  baldur:CallScript("SetNonhostile")
  if BossEncounter:IsDebugSkip() then
    TeleportKratosSonBaldur("Ph0_ShieldsDown_Kratos", "Ph0_ShieldsDown_Son", "Ph0_ShieldsDown_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    if baldur:PickupIsAcquired("Baldur_Invulnerable") == true then
      baldur:PickupRelinquish("Baldur_Invulnerable")
    end
    if Baldur_HealthBar_On == true then
      Baldur_HealthBar_On = false
      baldur:CallScript("LuaHook_HideHealth", baldur)
      uiCalls.UI_Event_Force_Combat_HUD_Off()
    end
    local spawnPos = DL.GetMarkerPosition(thisLevel, "Freya_Locator")
    local spawnFace = DL.GetMarkerRotation(thisLevel, "Freya_Locator")
    if freya == nil then
      freya = game.AI.Spawn(level, spawnPos, spawnFace, "CRT_Freya00", "BRA_Spawn_StoneMasonBoss")
    end
    if stoneMason ~= nil then
      stoneMason:Destroy()
    end
    local resetLevel = game.FindLevel("Stn910_BossEntrance")
    if resetLevel ~= nil then
      resetLevel:CallScript("ResetBaldurFreyaRock")
      baldurRockThrowBroken = false
    end
    game.Level.SetVariable("CompletedCineNumber", 540)
  end
  local localLevel = game.FindLevel("Stn910_BossEntrance")
  if localLevel ~= nil then
    local newObject = localLevel:FindSingleGameObject("Cine_ShieldsDown_Group")
    if newObject ~= nil then
      newObject:CallScript("ShieldsDownSequence")
    end
  end
end
function BossStage_0_3:OnUpdate(level)
  if player:IsPlayingMove("MOV_ShieldsDown") and baldurRockThrowBroken == false then
    local localLevel = game.FindLevel("Stn910_BossEntrance")
    if localLevel ~= nil then
      localLevel:CallScript("StartBaldurFreyaRock")
      baldurRockThrowBroken = true
    end
  end
  if game.Level.GetVariable("CompletedCineNumber") == 550 then
    BossEncounter:ForwardState()
  end
end
function BossStage_0_3:OnExit(level)
end
function BossStage_1_1:OnEnter(level)
  StageSetup(1, "PHASE 1-1: KRATOS AND SON DROP INTO ARENA", true)
  player:MeterSetValue("Health", 5000)
  LD.CallFunctionAfterDelay(function()
    uiCalls.UI_Event_Fade_In(1)
    GameObjects.Stn920_HandDrop_Cine:JumpAnimToPercent(0)
    local Stn975 = game.FindLevel("Stn975_BossLighting")
    if Stn975 ~= nil then
      Stn975:CallScript("StartExpo_HandDrop")
    end
  end, 3)
  if stoneMason == nil then
    InitStoneMason("BRA_NavCombatIdle_Phase_01")
  else
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
  end
  if not stoneMason:PickupIsAcquired("StoneMason_AttackProgress") then
    stoneMason:PickupAcquire("StoneMason_AttackProgress")
    stoneMason:PickupSetStage("StoneMason_AttackProgress", 0)
  else
    stoneMason:PickupSetStage("StoneMason_AttackProgress", 0)
  end
  if stoneMason:HasMarker("StoneMason_DisableAttacks") == false then
    stoneMason:AddMarker("StoneMason_DisableAttacks")
  end
  baldur:CallScript("SetNonhostile")
  DL.WarpCreature(baldur, thisLevel, "Ph1_ArenaEnter_Baldur")
  baldur:TriggerMoveEvent("LE_SM_BackToBackIdle")
  if freya ~= nil then
    freya:Destroy()
  end
  if cineVines ~= nil then
    cineVines:Destroy()
  end
  player:TriggerMoveEvent("LE_SM_Phase1_ArenaDrop")
  game.Audio.PlayBanter("Baldur3_Phase1_HandStart")
  if BossEncounter:IsDebugSkip() then
    if backToBack_Start == true then
      backToBack_Start = false
    end
    if cineVines ~= nil then
      cineVines:Destroy()
    end
    game.Level.SetVariable("CompletedCineNumber", 550)
  end
end
function BossStage_1_1:OnUpdate(level)
  if player:IsPlayingMove("MOV_StoneMason_Phase1_BackToBack_Idle") and backToBack_Start == false then
    CameraStartBackToBackEarlySubmit()
    backToBack_Start = true
  end
  if player:IsPlayingMove("MOV_MaMo_SnowBlind_Idle") then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_1:OnExit(level)
  backToBack_Start = false
end
function BossStage_1_2:OnEnter(level)
  StageSetup(1, "PHASE 1-2: KRATOS AND SON BACK TO BACK", true)
  if BossEncounter:IsDebugSkip() then
    TeleportKratosSonBaldur("Ph1_Start_Kratos", "Ph1_Start_Son", "Ph1_ArenaEnter_Baldur")
    player:TriggerMoveEvent("LE_SM_BtB_DebugEnter")
    baldurEnterPhase1 = false
    baldur:CallScript("SetNonhostile")
    baldur:CallScript("LuaHook_HideHealth", baldur)
    baldur:TriggerMoveEvent("LE_SM_BackToBackIdle")
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_01")
    if stoneMason:HasMarker("StoneMason_DisableAttacks") == false then
      stoneMason:AddMarker("StoneMason_DisableAttacks")
    end
    backToBack_Start = false
    backToBack_Complete = false
    local resetLevel = game.FindLevel("Stn920_BossLake")
    if resetLevel ~= nil then
      resetLevel:CallScript("ResetRelicRoom")
      relicRoomBroken = false
    end
  end
  backToBack_BaldurReadyToWarp = true
  backToBack_BaldurWarpCount = 0
  backToBack_DurationTimer = timers.StartLevelTimer(20, function()
    backToBack_Complete = true
    backToBack_BaldurReadyToWarp = false
    if backToBack_BaldurWarpDelayTimer ~= nil then
      backToBack_BaldurWarpDelayTimer:Stop()
    end
  end)
end
function BossStage_1_2:OnUpdate(level)
  local CSBaldurEnterRot = player:GetAnimDriver("BaldurEnterRot")
  CSBaldurEnterRot.ValueVec = thisLevel:FindSingleGameObject("Ph1_CSBaldurEnter_Rot"):GetWorldForward()
  BackToBackRotateKratos()
  if player:HasMarker("MaMoSnowblind") then
    game.Camera.SubmitCameraByName("CBT_StoneMasonSnowblind")
  end
  if backToBack_BaldurReadyToWarp == true then
    backToBack_BaldurReadyToWarp = false
    local currentFacingDirection = GetOrbitalRotation()
    if currentFacingDirection == "North" then
      backToBack_BaldurLocators = {
        "Ph1_Baldur_B2B_E",
        "Ph1_Baldur_B2B_W",
        "Ph1_Baldur_B2B_S"
      }
    elseif currentFacingDirection == "East" then
      backToBack_BaldurLocators = {
        "Ph1_Baldur_B2B_N",
        "Ph1_Baldur_B2B_W",
        "Ph1_Baldur_B2B_S"
      }
    elseif currentFacingDirection == "South" then
      backToBack_BaldurLocators = {
        "Ph1_Baldur_B2B_E",
        "Ph1_Baldur_B2B_W",
        "Ph1_Baldur_B2B_N"
      }
    elseif currentFacingDirection == "West" then
      backToBack_BaldurLocators = {
        "Ph1_Baldur_B2B_E",
        "Ph1_Baldur_B2B_N",
        "Ph1_Baldur_B2B_S"
      }
    else
      print("ERROR: FAILED TO SET FACING DIRECTION")
    end
    local random = math.random(1, #backToBack_BaldurLocators)
    backToBack_BaldurPosition = backToBack_BaldurLocators[random]
    backToBack_BaldurWarpCount = backToBack_BaldurWarpCount + 1
    backToBack_bntrPlayed = false
    DL.WarpCreature(baldur, thisLevel, backToBack_BaldurPosition)
    baldur:TriggerMoveEvent("LE_SM_BackToBackFeint")
    print("Warping Baldur To: " .. backToBack_BaldurPosition)
    backToBack_BaldurWarpDelayTimer = timers.StartLevelTimer(5, function()
      backToBack_BaldurReadyToWarp = true
    end)
  end
  if backToBack_bntrPlayed == false then
    if backToBack_BaldurWarpCount == 1 then
      game.Audio.PlayBanter("Baldur3_Phase1_LandStartCont")
    elseif backToBack_BaldurWarpCount == 2 then
      game.Audio.PlayBanterNonCritical(backToback_bntrTaunt_02)
    elseif backToBack_BaldurWarpCount == 3 then
      game.Audio.PlayBanterNonCritical(backToback_bntrTaunt_03)
    elseif backToBack_BaldurWarpCount == 4 then
      game.Audio.PlayBanterNonCritical(backToback_bntrTaunt_04)
    else
      print("ERROR: NO BANTER TO PLAY")
    end
    backToBack_bntrPlayed = true
  end
  if backToBack_Complete == true and baldurEnterPhase1 == false then
    baldurEnterPhase1 = true
    player:TriggerMoveEvent("LE_SM_Phase1_BaladurEnter")
  end
  if baldur:IsPlayingMove("MOV_StoneMason_WaitForArenaEnter") or baldur:IsPlayingMove("MOV_StoneMason_BackToBack_FeintEnter") and baldur:HasMarker("nooffscreen") == false then
    baldur:AddMarker("nooffscreen")
  end
  if baldur:IsPlayingMove("MOV_StoneMason_BackToBack_Feint") and baldur:HasMarker("nooffscreen") == true then
    baldur:RemoveMarker("nooffscreen")
  end
  if player:IsPlayingMove("MOV_StoneMason_Phase1_BaldurEntrance") and player:GetActiveMovePercent() >= 0.4952381 then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_2:OnExit(level)
  if backToBack_DurationTimer ~= nil then
    backToBack_DurationTimer:Stop()
  end
  if backToBack_BaldurWarpDelayTimer ~= nil then
    backToBack_BaldurWarpDelayTimer:Stop()
  end
  if baldur:HasMarker("nooffscreen") == true then
    baldur:RemoveMarker("nooffscreen")
  end
  backToBack_BaldurReadyToWarp = false
end
function BossStage_1_3:OnEnter(level)
  StageSetup(1, "PHASE 1-3: FIGHT BEFORE ELEMENT ABSORB", true)
  InitStoneMason("BRA_NavCombatIdle_Phase_01")
  SonClearAvailabilityRequests()
  if son:HasMarker("TweakPOIResOnly") then
    son:RemoveMarker("TweakPOIResOnly")
  end
  baldur:CallScript("SetHostile")
  if baldur:HasMarker("nooffscreen") == true then
    baldur:RemoveMarker("nooffscreen")
  end
  if Baldur_HealthBar_On == false then
    Baldur_HealthBar_On = true
    baldur:CallScript("LuaHook_ShowHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_On()
  end
  banterScript.StartPhase1()
  if BossEncounter:IsDebugSkip() or isReload then
    isReload = false
    game.Combat.TurnOnAndLockCombatStatus()
    TeleportKratosSonBaldur("Ph1_Start_Kratos", "Ph1_Start_Son", "Ph1_Start_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:MeterSetValue("Health", BaldurHealthMax_Phase_1A)
    baldur:TriggerMoveEvent("LE_SM_BackToBackExit")
    baldur:CallScript("LuaHook_StoneMasonBoss_DeactivateElements")
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_01")
    stoneMason:PickupSetStage("StoneMason_AttackProgress", 0)
    if stoneMason:HasMarker("StoneMason_DisableAttacks") == false then
      stoneMason:AddMarker("StoneMason_DisableAttacks")
      timers.StartLevelTimer(10, function()
        stoneMason:RemoveMarker("StoneMason_DisableAttacks")
      end)
    end
    timers.StartLevelTimer(0.1, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 0.1,
        YawRange = -1,
        RotationSpace = 1,
        TriggerLeft = -63,
        TriggerRight = -63,
        ReturnLeft = -63,
        ReturnRight = -63,
        Lock = 1
      })
    end)
    local resetLevel = game.FindLevel("Stn920_BossLake")
    if resetLevel ~= nil then
      resetLevel:CallScript("ResetRelicRoom")
      relicRoomBroken = false
    end
  end
end
function BossStage_1_3:OnUpdate(level)
  if stoneMason:IsPlayingMove("MOV_AttGroundPound_Intro") and relicRoomBroken == false then
    local localLevel = game.FindLevel("Stn920_BossLake")
    if localLevel ~= nil then
      localLevel:CallScript("BreakRelicRoom")
      relicRoomBroken = true
    end
    timers.StartLevelTimer(0.05, CameraStartMasonGroundPoundIntro)
  end
  if oneshotCameraMasonGroundPoundIntro ~= nil then
    oneshotCameraMasonGroundPoundIntro:Update()
  end
  if stoneMason:IsPlayingMove("MOV_AttGroundPound_Exit") and stoneMason:HasMarker("StoneMason_DisableAttacks") == true then
    timers.StartLevelTimer(15, function()
      stoneMason:RemoveMarker("StoneMason_DisableAttacks")
    end)
  end
  if baldur:GetHitPoints() <= BaldurHealthMin_Phase_1A and IsBaldurReadyToTransition() and baldur:HasMarker("StageTransition") == false then
    baldur:AddMarker("StageTransition")
  end
  if baldur:IsPlayingMove("MOV_FirstElementalTransition") then
    if Baldur_HealthBar_On == true then
      SonDisableCombat()
      ClearStatusEffect()
      ClearSonSpecialAttacks()
      game.Combat.RemoveArrows(baldur)
      Baldur_HealthBar_On = false
      baldur:CallScript("LuaHook_HideHealth", baldur)
      uiCalls.UI_Event_Force_Combat_HUD_Off()
    end
    if baldur:GetActiveMovePercent() >= 0.78571427 then
      BossEncounter:ForwardState()
    end
  end
end
function BossStage_1_3:OnExit(level)
  if baldur:HasMarker("StageTransition") == true then
    baldur:RemoveMarker("StageTransition")
  end
  if stoneMason:HasMarker("StoneMason_DisableAttacks") == true then
    stoneMason:RemoveMarker("StoneMason_DisableAttacks")
  end
end
function BossStage_1_4:OnEnter(level)
  StageSetup(1, "PHASE 1-4: BALDUR ACTIVATES ELEMENTS", false)
  SonClearAvailabilityRequests()
  if Baldur_HealthBar_On == false then
    Baldur_HealthBar_On = true
    baldur:CallScript("LuaHook_ShowHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_On()
  end
  banterScript.StartPhase1Elements()
  if BossEncounter:IsDebugSkip() then
    baldur:CallScript("SetHostile")
    baldur:CallScript("LuaHook_StoneMasonBoss_ActivateIceMode")
    baldur:MeterSetValue("Health", BaldurHealthMax_Phase_1B)
    if baldur:HasMarker("StageTransition") == true then
      baldur:RemoveMarker("StageTransition")
    end
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_01")
    stoneMason:PickupSetStage("StoneMason_AttackProgress", 0)
  end
end
function BossStage_1_4:OnUpdate(level)
  if baldur:GetHitPoints() <= BaldurHealthMin_Phase_1B and IsBaldurReadyToTransition() then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_4:OnExit(level)
  banterScript.ForceStopCallouts()
end
function BossStage_1_5:OnEnter(level)
  StageSetup(1, "PHASE 1-5: BALDUR STARTS TRANSITION", false)
  if baldur:HasMarker("StageTransition") == false then
    baldur:AddMarker("StageTransition")
  end
  if BossEncounter:IsDebugSkip() then
    game.Combat.TurnOnAndLockCombatStatus()
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_01")
    TeleportKratosSonBaldur("Ph1_Start_Kratos", "Ph1_Start_Son", "Ph1_Start_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:TriggerMoveEvent("LE_PhaseTransitionAttackDecision")
    baldur:CallScript("SetHostile")
    baldur:MeterSetValue("Health", BaldurHealthMin_Phase_1B)
    local resetLevel = game.FindLevel("Stn920_BossLake")
    if resetLevel ~= nil then
      resetLevel:CallScript("ResetSlingshotWall")
      relicRoomBroken = false
    end
  end
end
function BossStage_1_5:OnUpdate(level)
  DL.SetMotionWarpDrivers(thisLevel, baldur, "BaldurSlingshotEnterPos", "BaldurSlingshotEnterRot", "Ph1_CSBaldurSlingshot_Enter")
  DL.SetMotionWarpDrivers(thisLevel, baldur, "BaldurSlingshotImpactPos", "BaldurSlingshotImpactRot", "Ph1_CSBaldurSlingshot_Impact")
  if player:IsPlayingMove("MOV_CSBaldurSlingshotEnter") and Baldur_HealthBar_On == true then
    SonDisableCombat()
    ClearStatusEffect()
    son:AddMarker("TweakPOIResOnly")
    ClearSonSpecialAttacks()
    game.Combat.RemoveArrows(baldur)
    baldur:CallScript("LuaHook_StoneMasonBoss_DeactivateElements")
    Baldur_HealthBar_On = false
    baldur:CallScript("LuaHook_HideHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_Off()
  end
  if player:IsPlayingMove("MOV_CSBaldurSlingshotExit") and slingshotWallBroken == false then
    local localLevel = game.FindLevel("Stn920_BossLake")
    if localLevel ~= nil then
      localLevel:CallScript("BreakSlingshotWall")
      slingshotWallBroken = true
    end
  end
  if player:IsPlayingMove("MOV_CSStoneMasonHandLift_Idle") then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_5:OnExit(level)
  if baldur:HasMarker("StageTransition") then
    baldur:RemoveMarker("StageTransition")
  end
end
function BossStage_1_6:OnEnter(level)
  StageSetup(1, "PHASE 1-6: KRATOS LIFTS STONE MASON'S HAND", false)
  InitStoneMason("BRA_NavCombatIdle_Phase_01")
  player:CallScript("LuaHook_DisableRevive", true)
  local wad920 = game.FindLevel("Stn920_BossLake")
  if wad920 ~= nil then
    wad920:CallScript("StartLight_HandLift")
  end
  local Stn975 = game.FindLevel("Stn975_BossLighting")
  if Stn975 ~= nil then
    Stn975:CallScript("StartExpo_HandLift")
  end
  baldur:CallScript("SetNonhostile")
  if Baldur_HealthBar_On == true then
    Baldur_HealthBar_On = false
    baldur:CallScript("LuaHook_HideHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_Off()
  end
  if BossEncounter:IsDebugSkip() or isReload then
    isReload = false
    reloadFade = true
    timers.StartLevelTimer(4, function()
      reloadFade = false
    end)
    game.Combat.TurnOnAndLockCombatStatus()
    uiCalls.UI_Event_Force_Combat_HUD_Off()
    TeleportKratosSonBaldur("Ph1_HandLift_Kratos", "Ph1_HandLift_Son", "Ph1_HandLift_Baldur")
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    baldur:MeterSetValue("Health", BaldurHealthMin_Phase_1B)
    baldur:CallScript("LuaHook_StoneMasonBoss_DeactivateElements")
    baldur:CallScript("LuaHook_HideHealth", baldur)
    player:TriggerMoveEvent("LE_SM_Phase1_HandLiftEnter")
    SonDisableCombat()
    local resetLevel = game.FindLevel("Stn970_BossRoom")
    if resetLevel ~= nil then
      resetLevel:CallScript("ResetWoodBeam")
      woodBeamBroken = false
    end
  end
end
function BossStage_1_6:OnUpdate(level)
  if player:IsPlayingMove("MOV_CSStoneMasonHandLift_SonShootWin") and woodBeamBroken == false then
    local localLevel = game.FindLevel("Stn970_BossRoom")
    if localLevel ~= nil then
      localLevel:CallScript("BreakWoodBeam")
      woodBeamBroken = true
    end
    local Stn975 = game.FindLevel("Stn975_BossLighting")
    if Stn975 ~= nil then
      Stn975:CallScript("ResetExpo_HandLift")
    end
  end
  if player:HasMarker("Kratos_LiftHand_Struggle") == true and Kratos_HandLift_Struggle == false and reloadFade == false then
    Kratos_HandLift_Struggle = true
    mpicon.level.Create(GameObjects.Phase1_MPIcon_Kratos_LiftHand, "WORLD_INTERACT_MASHBUTTON")
  elseif player:HasMarker("Kratos_LiftHand_Struggle") == false and Kratos_HandLift_Struggle == true then
    Kratos_HandLift_Struggle = false
    mpicon.level.Off(GameObjects.Phase1_MPIcon_Kratos_LiftHand, "WORLD_INTERACT_MASHBUTTON")
  end
  if player:HasMarker("Son_ShootHand_Window") == true and Son_ShootHand_Window == false then
    Son_ShootHand_Window = true
    mpicon.level.Create(GameObjects.Phase1_MPIcon_Son_ShootHand, "WORLD_INTERACT_SON")
  elseif player:HasMarker("Son_ShootHand_Window") == false and Son_ShootHand_Window == true then
    Son_ShootHand_Window = false
    mpicon.level.Off(GameObjects.Phase1_MPIcon_Son_ShootHand, "WORLD_INTERACT_SON")
  end
  if player:IsPlayingMove("MOV_CSStoneMasonHandLift_SonShootWin") then
    BossEncounter:ForwardState()
  end
end
function BossStage_1_6:OnExit(level)
end
function BossStage_2_0:OnEnter(level)
  StageSetup(2, "PHASE 2-0: TRANSITION TO COOKIE JAR")
end
function BossStage_2_0:OnUpdate(level)
  if stoneMason ~= nil then
    if stoneMason:IsPlayingMove("MOV_CSStoneMasonHandLift_SonShootWin") then
      if stoneMason:GetActiveMovePercent() >= 0.907 and Phase2_IntroProjectionEncounter ~= nil then
        Phase2_IntroProjectionEncounter:Start()
      end
      if stoneMason:GetActiveMovePercent() >= 0.99 then
        BossEncounter:ForwardState()
      end
    end
  else
    BossEncounter:ForwardState()
  end
end
function BossStage_2_0:OnExit(level)
  if player:HasMarker("Kratos_LiftHand_Struggle") == true and Kratos_HandLift_Struggle == true then
    Kratos_HandLift_Struggle = false
    mpicon.level.Off(GameObjects.Phase1_MPIcon_Kratos_LiftHand, "WORLD_INTERACT_MASHBUTTON")
  end
  if player:HasMarker("Son_ShootHand_Window") == true and Son_ShootHand_Window == true then
    Son_ShootHand_Window = false
    mpicon.level.Off(GameObjects.Phase1_MPIcon_Son_ShootHand, "WORLD_INTERACT_SON")
  end
end
function BossStage_2_1:OnEnter(level)
  StageSetup(2, "PHASE 2-1: STONE MASON SPAWNS PROJECTIONS")
  player:MeterSetValue("Health", 5000)
  InitStoneMason("BRA_NavCombatIdle_Phase_02")
  SonClearAvailabilityRequests()
  GameObjects.ContextAction_Son_ShootFromPoint.LuaObjectScript.Enable()
  player:CallScript("LuaHook_DisableRevive", true)
  if son:HasMarker("DisableSummon") == false then
    son:AddMarker("DisableSummon")
    uiCalls.UI_Refresh_HUD()
  end
  if son:HasMarker("TweakPOIResOnly") then
    son:RemoveMarker("TweakPOIResOnly")
  end
  baldur:CallScript("SetHostile")
  if Baldur_HealthBar_On == false then
    Baldur_HealthBar_On = true
    baldur:CallScript("LuaHook_ShowHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_On()
  end
  if BossEncounter:IsDebugSkip() or isReload then
    isReload = false
    game.Combat.TurnOnAndLockCombatStatus()
    TeleportKratosSonBaldur("Ph2_Start_Kratos", "Ph2_Start_Son", "Ph2_Start_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:CallScript("LuaHook_StoneMasonBoss_ActivateFireMode")
    baldur:TriggerMoveEvent("LE_TauntInviteL")
    baldur:CallScript("SetHostile")
    baldur:MeterSetValue("Health", BaldurHealthMax_Phase_2)
    if Baldur_HealthBar_On == false then
      Baldur_HealthBar_On = true
      baldur:CallScript("LuaHook_ShowHealth", baldur)
      uiCalls.UI_Event_Force_Combat_HUD_On()
    end
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_02")
    local localLevel = game.FindLevel("Stn970_BossRoom")
    if localLevel ~= nil then
      localLevel:CallScript("ForceBreakCookieJarRubble")
    end
    Phase2_MainProjectionEncounter_RestartTimer = timers.StartLevelTimer(5, function()
      Phase2_MainProjectionEncounter:Start()
    end)
  end
end
function BossStage_2_1:OnUpdate(level)
  if baldur:GetHitPoints() <= BaldurHealthMin_Phase_2 and IsBaldurReadyToTransition() then
    BossEncounter:ForwardState()
  end
end
function BossStage_2_1:OnExit(level)
  if Phase2_MainProjectionEncounter_RestartTimer ~= nil then
    Phase2_MainProjectionEncounter_RestartTimer:Stop()
  end
  Phase2_CleanUpProjectionEncounters_NoDespawn()
end
function BossStage_2_2:OnEnter(level)
  StageSetup(2, "PHASE 2-2: BALDUR STARTS TRANSITION")
  if baldur:HasMarker("StageTransition") == false then
    baldur:AddMarker("StageTransition")
  end
  if BossEncounter:IsDebugSkip() then
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:TriggerMoveEvent("LE_EvadeB")
    baldur:CallScript("SetHostile")
    baldur:MeterSetValue("Health", BaldurHealthMin_Phase_2)
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_02")
    GameObjects.ChiselClimb_placeholder:HideCollision()
    GameObjects.ChiselClimb_placeholder:HideTraversePath()
    GameObjects.Phase2_ChiselLift_Zone:HideEntityVolume()
    local resetLevel = game.FindLevel("Stn970_BossRoom")
    if resetLevel ~= nil then
      resetLevel:CallScript("ResetChiselRoom")
      resetLevel:CallScript("ResetRockWallImpact")
      chiselRoomBroken = false
    end
  end
end
function BossStage_2_2:OnUpdate(level)
  DL.SetMotionWarpDrivers(thisLevel, baldur, "ChiselSlamEnterPos", "ChiselSlamEnterRot", "Ph2_CSBaldurTomahawk_Enter")
  DL.SetMotionWarpDrivers(thisLevel, baldur, "ChiselSlamExitPos", "ChiselSlamExitRot", "Ph2_CSBaldurTomahawk_Impact")
  if player:IsPlayingMove("MOV_CSBaldurTomahawkEnter") and Baldur_HealthBar_On == true then
    ClearStatusEffect()
    SonDisableSynchAndCombat()
    son:AddMarker("TweakPOIResOnly")
    game.Combat.RemoveArrows(baldur)
    Baldur_HealthBar_On = false
    baldur:CallScript("SetNonhostile")
    baldur:CallScript("LuaHook_HideHealth", baldur)
    baldur:CallScript("LuaHook_StoneMasonBoss_DeactivateElements")
    uiCalls.UI_Event_Force_Combat_HUD_Off()
  end
  if player:IsPlayingMove("MOV_CSBaldurTomahawkExit") and chiselRoomBroken == false then
    local localLevel = game.FindLevel("Stn970_BossRoom")
    if localLevel ~= nil then
      localLevel:CallScript("BreakChiselRoom")
      localLevel:CallScript("BaldurRockWallImpact")
      chiselRoomBroken = true
    end
  end
  if player:IsPlayingMove("MOV_CSBaldurTomahawkExit") then
    if player:GetActiveMovePercent() >= 0.01 then
      Phase2_CleanUpProjectionEncounters()
    end
    if player:GetActiveMovePercent() >= 0.99 then
      BossEncounter:ForwardState()
    end
  end
end
function BossStage_2_2:OnExit(level)
  if baldur:HasMarker("StageTransition") then
    baldur:RemoveMarker("StageTransition")
  end
  Phase2_CleanUpProjectionEncounters()
end
function BossStage_2_3:OnEnter(level)
  StageSetup(2, "PHASE 2-3: KRATOS CHASES BALDUR UP THE CHISEL")
  InitStoneMason("BRA_CSChiselSlam_Idle_Debug")
  game.Combat.UnlockCombatStatus()
  InputMaskChiselClimb()
  baldur:CallScript("SetNonhostile")
  if Baldur_HealthBar_On == true then
    Baldur_HealthBar_On = false
    baldur:CallScript("LuaHook_HideHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_Off()
  end
  GameObjects.ChiselClimb_placeholder:ShowCollision()
  GameObjects.ChiselClimb_placeholder:ShowTraversePath()
  GameObjects.Phase2_ChiselLift_Zone:ShowEntityVolume()
  if BossEncounter:IsDebugSkip() or isReload then
    isReload = false
    TeleportKratosSonBaldur("Ph2_ChiselSlam_Kratos", "Ph2_ChiselSlam_Son", "Ph2_ChiselSlam_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    son:TriggerMoveEvent("LE_SM_WaitForChiselClimb")
    SonDisableSynchAndCombat()
    baldur:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    stoneMason:TriggerMoveEvent("LE_CSChiselSlamIdle_Debug")
    transitionChiselLift = false
    uiCalls.UI_Event_Force_Combat_HUD_Off()
    Phase2_CleanUpProjectionEncounters()
  end
end
function BossStage_2_3:OnUpdate(level)
  if player:IsInsideEntityZone("Phase2_ChiselLift_Zone") and transitionChiselLift == false then
    SonDisableCombat()
    stoneMason:TriggerMoveEvent("LE_CSChiselSlamLift")
    transitionChiselLift = true
  end
  if player:IsPlayingMove("MOV_CSChiselSlam_Lift") and player:GetActiveMovePercent() >= 0.99 then
    BossEncounter:ForwardState()
  end
end
function BossStage_2_3:OnExit(level)
  GameObjects.Phase2_ChiselLift_Zone:HideEntityVolume()
  ClearInputMaskChiselClimb()
  GameObjects.ContextAction_Son_ShootFromPoint.LuaObjectScript.Disable()
  if son:HasMarker("DisableSummon") then
    son:RemoveMarker("DisableSummon")
    uiCalls.UI_Refresh_HUD()
  end
  player:CallScript("LuaHook_DisableRevive", false)
end
local tutTimer = 0
function BossStage_3_1:OnEnter(level)
  tutTimer = 0
  StageSetup(3, "PHASE 3-1: CHISEL MMA DEFENSE")
  player:MeterSetValue("Health", 5000)
  game.Combat.TurnOnAndLockCombatStatus()
  if son:HasMarker("DoNotFollowupPriority") == false then
    son:AddMarker("DoNotFollowupPriority")
  end
  baldur:CallScript("SetHostile")
  if baldur:PickupIsAcquired("Baldur_FireMode") then
    baldur:PickupRelinquish("Baldur_FireMode")
  end
  if BossEncounter:IsDebugSkip() then
    DL.WarpCreature(player, thisLevel, "Ph3_ChiselMMA_Kratos")
    player:TriggerMoveEvent("LE_Chisel_MMA_Def_Enter")
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    stoneMason:TriggerMoveEvent("LE_Chisel_MMA_Idle")
  end
end
function BossStage_3_1:OnUpdate(level)
  if -1 < tutTimer then
    tutTimer = tutTimer + level:GetUnitTime()
    if 12.5 < tutTimer then
      uiCalls.SendSidebarDesignerMessage({
        Text = 44731,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        AdvanceType = uiCalls.msgParam.INFINITE_TIMER
      })
      tutTimer = -1
    end
  end
  if tutTimer ~= -2 and (player:IsPlayingMove("MOV_ChiselMMA_Defense_TransToHangMMA") or player:IsPlayingMove("MOV_ChiselMMA_Defense_HeavyRightCounter") or player:IsPlayingMove("MOV_ChiselMMA_Defense_HeavyLeftCounter")) then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    tutTimer = -2
  end
  if player:HasMarker("Son_MMADefShot_Window") == true and Son_MMADefShot_Window == false then
    Son_MMADefShot_Window = true
    mpicon.level.Create(GameObjects.Phase3_MPIcon_Son_MMADef, "WORLD_INTERACT_SON")
  elseif player:HasMarker("Son_MMADefShot_Window") == false and Son_MMADefShot_Window == true then
    Son_MMADefShot_Window = false
    mpicon.level.Off(GameObjects.Phase3_MPIcon_Son_MMADef, "WORLD_INTERACT_SON")
  end
  if player:IsPlayingMove("MOV_ChiselMMA_Defense_TransToHangMMA") and player:GetActiveMovePercent() >= 0.99 then
    BossEncounter:ForwardState()
  end
end
function BossStage_3_1:OnExit(level)
  if player:PickupIsAcquired("TRC_Disable_Rumble") then
    player:PickupRelinquish("TRC_Disable_Rumble")
  end
end
function BossStage_3_2:OnEnter(level)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  StageSetup(3, "PHASE 3-2: HANGING MMA")
  local stn910 = game.FindLevel("Stn910_BossEntrance")
  if stn910 ~= nil then
    stn910:CallScript("HideVis")
  end
  if BossEncounter:IsDebugSkip() then
    DL.WarpCreature(player, thisLevel, "Ph3_HangMMA_Kratos")
    player:TriggerMoveEvent("LE_Chisel_Hang_MMA_Debug_Enter")
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    stoneMason:TriggerMoveEvent("LE_Chisel_Hang_MMA_Idle")
  end
end
function BossStage_3_2:OnUpdate(level)
  if player:HasMarker("Son_MMAHangShot_Window") == true and Son_MMAHangShot_Window == false then
    Son_MMAHangShot_Window = true
    mpicon.level.Create(GameObjects.Phase3_MPIcon_Son_MMAHang, "WORLD_INTERACT_SON")
  elseif player:HasMarker("Son_MMAHangShot_Window") == false and Son_MMAHangShot_Window == true then
    Son_MMAHangShot_Window = false
    mpicon.level.Off(GameObjects.Phase3_MPIcon_Son_MMAHang, "WORLD_INTERACT_SON")
  end
  if player:IsPlayingMove("MOV_ChiselMMA_Hang_TransToChokeMMA") and player:GetActiveMovePercent() >= 0.99 then
    BossEncounter:ForwardState()
  end
end
function BossStage_3_2:OnExit(level)
  if player:PickupIsAcquired("TRC_Disable_Rumble") then
    player:PickupRelinquish("TRC_Disable_Rumble")
  end
end
function BossStage_3_3:OnEnter(level)
  StageSetup(3, "PHASE 3-3: CHOKE MMA")
  if BossEncounter:IsDebugSkip() then
    DL.WarpCreature(player, thisLevel, "Ph3_ChokeMMA_Kratos")
    player:TriggerMoveEvent("LE_Choke_MMA_Debug_Enter")
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    stoneMason:TriggerMoveEvent("LE_Choke_MMA_Idle")
    kratosRageReady = false
    kratosRageActivated = false
  end
end
function BossStage_3_3:OnUpdate(level)
  if player:HasMarker("Son_MMAChoke_Window") == true and Son_MMAChoke_Window == false then
    Son_MMAChoke_Window = true
    mpicon.level.Create(GameObjects.Phase3_MPIcon_Son_MMAChoke, "WORLD_INTERACT_SON_MASH")
  elseif player:HasMarker("Son_MMAChoke_Window") == false and Son_MMAChoke_Window == true then
    Son_MMAChoke_Window = false
    mpicon.level.Off(GameObjects.Phase3_MPIcon_Son_MMAChoke, "WORLD_INTERACT_SON_MASH")
  end
  if player:IsPlayingMove("MOV_ChokeMMA_SonDanger_RageReady") and kratosRageReady == false then
    if player:MeterGetValue("Blood") < 100 then
      player:MeterSetValue("Blood", 100)
    end
    uiCalls.EnableMechanicRage()
    kratosRageReady = true
  end
  if player:IsPlayingMove("MOV_ChokeMMA_SonDanger_RageBurst") and kratosRageActivated == false then
    uiCalls.DisableMechanicRage()
    kratosRageActivated = true
  end
  if player:IsPlayingMove("MOV_ChokeMMA_SonDanger_RageBurst") and player:GetActiveMovePercent() >= 0.99 then
    BossEncounter:ForwardState()
  end
end
function BossStage_3_3:OnExit(level)
  if son:HasMarker("DoNotFollowupPriority") then
    son:RemoveMarker("DoNotFollowupPriority")
  end
  mpicon.level.Off(GameObjects.Phase3_MPIcon_Son_MMAChoke, "WORLD_INTERACT_SON_MASH")
end
function BossStage_4_1:OnEnter(level)
  StageSetup(4, "PHASE 4-1: DEFEAT BALDUR")
  InitStoneMason("BRA_NavCombatIdle_Phase_04")
  player:MeterSetValue("Health", 5000)
  if son:HasMarker("DoNotFollowupPriority") then
    son:RemoveMarker("DoNotFollowupPriority")
  end
  if son:HasMarker("TweakPOIResOnly") then
    son:RemoveMarker("TweakPOIResOnly")
  end
  SonClearAvailabilityRequests()
  if Baldur_HealthBar_On == false then
    Baldur_HealthBar_On = true
    baldur:CallScript("LuaHook_ShowHealth", baldur)
    uiCalls.UI_Event_Force_Combat_HUD_On()
  end
  banterScript.StartPhase3()
  if BossEncounter:IsDebugSkip() or isReload then
    isReload = false
    game.Combat.TurnOnAndLockCombatStatus()
    TeleportKratosSonBaldur("Ph4_Start_Kratos", "Ph4_Start_Son", "Ph4_Start_Baldur")
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    player:CallScript("LuaHook_StoneMason_Checkpoint_RageEnter")
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:CallScript("LuaHook_StoneMasonBoss_ActivateIceMode")
    baldur:TriggerMoveEvent("kLETauntInvite")
    baldur:CallScript("SetHostile")
    baldur:MeterSetValue("Health", BaldurHealthMax_Phase_4)
    DL.WarpCreature(stoneMason, thisLevel, "StoneMason_Locator")
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_04")
  end
end
function BossStage_4_1:OnUpdate(level)
  if baldur:GetHitPoints() <= BaldurHealthMin_Phase_4 and IsBaldurReadyToTransition() then
    BossEncounter:ForwardState()
  end
end
function BossStage_4_1:OnExit(level)
  banterScript.ForceStopCallouts()
end
function BossStage_4_2:OnEnter(level)
  StageSetup(4, "PHASE 4-2: BALDUR STARTS TRANSITION")
  if BossEncounter:IsDebugSkip() then
    player:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    if player:HasMarker("BeatdownPummel_Complete") then
      player:RemoveMarker("BeatdownPummel_Complete")
    end
    son:TriggerMoveEvent("LE_SM_ForceDebugEscape")
    baldur:TriggerMoveEvent("LE_EvadeB")
    baldur:CallScript("SetHostile")
    baldur:MeterSetValue("BeatdownPummel", 0)
    stoneMason:TriggerMoveEvent("LE_NavCombatIdle_Phase_04")
  end
  if baldur:HasMarker("StageTransition") == false then
    baldur:AddMarker("StageTransition")
  end
end
function BossStage_4_2:OnUpdate(level)
  local CSFinalUpper = player:GetAnimDriver("BaldurFinalUpperRot")
  CSFinalUpper.ValueVec = player:GetWorldPosition() - thisLevel:FindSingleGameObject("Ph4_CSBaldurUpper"):GetWorldPosition()
  DL.SetMotionWarpDrivers(thisLevel, player, "BaldurFinalUpperTrans", "BaldurFinalUpperRot", "Ph4_CSBaldurUpper")
  if player:IsPlayingMove("MOV_CSBaldurUppercutToBeatdown_Enter") and Baldur_HealthBar_On == true then
    ClearStatusEffect()
    SonDisableCombat()
    ClearSonSpecialAttacks()
    game.Combat.RemoveArrows(baldur)
    baldur:CallScript("LuaHook_HideHealth", baldur)
    baldur:CallScript("LuaHook_StoneMasonBoss_DeactivateElements")
    uiCalls.UI_Event_Force_Combat_HUD_Off()
    Baldur_HealthBar_On = false
  end
  if player:HasMarker("Son_Beatdown_Whiff_01") == true and Son_Beatdown_Whiff_01 == false then
    Son_Beatdown_Whiff_01 = true
    mpicon.level.Create(GameObjects.Phase4_MPIcon_Son_Beatdown_01, "WORLD_INTERACT_SON")
  elseif player:HasMarker("Son_Beatdown_Whiff_01") == false and Son_Beatdown_Whiff_01 == true then
    Son_Beatdown_Whiff_01 = false
    mpicon.level.Off(GameObjects.Phase4_MPIcon_Son_Beatdown_01, "WORLD_INTERACT_SON")
  end
  if player:HasMarker("Son_Beatdown_Whiff_02") == true and Son_Beatdown_Whiff_02 == false then
    Son_Beatdown_Whiff_02 = true
    mpicon.level.Create(GameObjects.Phase4_MPIcon_Son_Beatdown_02, "WORLD_INTERACT_SON")
  elseif player:HasMarker("Son_Beatdown_Whiff_02") == false and Son_Beatdown_Whiff_02 == true then
    Son_Beatdown_Whiff_02 = false
    mpicon.level.Off(GameObjects.Phase4_MPIcon_Son_Beatdown_02, "WORLD_INTERACT_SON")
  end
  if player:HasMarker("Son_Beatdown_Whiff_03") == true and Son_Beatdown_Whiff_03 == false then
    Son_Beatdown_Whiff_03 = true
    mpicon.level.Create(GameObjects.Phase4_MPIcon_Son_Beatdown_03, "WORLD_INTERACT_SON")
  elseif player:HasMarker("Son_Beatdown_Whiff_03") == false and Son_Beatdown_Whiff_03 == true then
    Son_Beatdown_Whiff_03 = false
    mpicon.level.Off(GameObjects.Phase4_MPIcon_Son_Beatdown_03, "WORLD_INTERACT_SON")
  end
  if baldur:MeterGetValue("BeatdownPummel") >= 100 and player:HasMarker("BeatdownPummel_Complete") == false then
    player:AddMarker("BeatdownPummel_Complete")
  end
  if player:IsPlayingMove("MOV_CSBaldurBeatdown_PummelComplete") and masonKillStart == false then
    masonKillStart = true
    print("Start Stone Mason Kill")
    local localLevel = game.FindLevel("Stn910_BossEntrance")
    if localLevel ~= nil then
      local newObject = localLevel:FindSingleGameObject("CombatCine_StoneMasonKill_Group")
      if newObject ~= nil then
        newObject:CallScript("StoneMasonKillSequence")
        BossEncounter:ForwardState()
      end
    end
  end
end
function BossStage_4_2:OnExit(level)
  if baldur:HasMarker("StageTransition") then
    baldur:RemoveMarker("StageTransition")
  end
  if player:HasMarker("BeatdownPummel_Complete") then
    player:RemoveMarker("BeatdownPummel_Complete")
  end
  if player:PickupIsAcquired("TRC_Disable_Rumble") then
    player:PickupRelinquish("TRC_Disable_Rumble")
  end
end
function BossStage_4_3:OnEnter(level)
  StageSetup(4, "PHASE 4-4: STONE MASON USES FREEZING BREATH")
  local stn910 = game.FindLevel("Stn910_BossEntrance")
  if stn910 ~= nil then
    stn910:CallScript("ShowVis")
  end
  baldur:CallScript("SetNonhostile")
  if BossEncounter:IsDebugSkip() then
    TeleportKratosSonBaldur("Ph4_IceBreath_Kratos", "Ph4_IceBreath_Son", "Ph4_IceBreath_Baldur")
    local spawnPos = DL.GetMarkerPosition(thisLevel, "StoneMason_Locator")
    local spawnFace = DL.GetMarkerRotation(thisLevel, "StoneMason_Locator")
    if stoneMason == nil then
      stoneMason = game.AI.Spawn(level, spawnPos, spawnFace, "CRT_StoneMason00", "BRA_NavCombatIdle_Phase_03")
      player:TriggerMoveEvent("LE_SM_StoneMasonKill")
    end
    baldur:CallScript("LuaHook_StoneMasonBoss_DeactivateElements")
  end
end
function BossStage_4_3:OnUpdate(level)
  if player:IsPlayingMove("MOV_CSStoneMasonKill") and player:GetActiveMovePercent() >= 0.7 then
    BossEncounter:ForwardState()
  end
end
function BossStage_4_3:OnExit(level)
end
function BossStage_5_0:OnEnter(level)
  StageSetup(5, "PHASE 5-0: CATAPULT BACK TO ENTRANCE")
  GameObjects.Stn980_Stage_4:ShowEntityVolume()
  local stn910 = game.FindLevel("Stn910_BossEntrance")
  if stn910 ~= nil then
    stn910:CallScript("SwapHandPose")
  end
  game.Level.SetVariable("CompletedCineNumber", 555)
end
function BossStage_5_0:OnUpdate(level)
  if player:IsPlayingMove("MOV_BaldurDeath") and player:GetActiveMovePercent() >= 0 then
    BossEncounter:ForwardState()
  end
end
function BossStage_5_0:OnExit(level)
end
function BossStage_5_1:OnEnter(level)
  StageSetup(5, "PHASE 5-1: BALDUR DEATH CINEMATIC")
  SonClearAvailabilityRequests()
  son:CallScript("LuaHook_EnableAutonomousSon")
  game.Combat.UnlockCombatStatus()
  baldur:CallScript("SetNonhostile")
  GameObjects.Stn980_Stage_0:HideEntityVolume()
  GameObjects.Stn980_Stage_1:HideEntityVolume()
  GameObjects.Stn980_Stage_2:HideEntityVolume()
  GameObjects.Stn980_Stage_3:HideEntityVolume()
  GameObjects.Stn980_Stage_4:HideEntityVolume()
  if stoneMason ~= nil then
    stoneMason:Destroy()
  end
  uiCalls.UI_Event_Force_Combat_HUD_Clear()
end
function BossStage_5_1:OnUpdate(level)
end
function BossStage_5_1:OnExit(level)
end
function InitStoneMason(spawnMove)
  local spawnPos = DL.GetMarkerPosition(thisLevel, "StoneMason_Locator")
  local spawnFace = DL.GetMarkerRotation(thisLevel, "StoneMason_Locator")
  if stoneMason == nil then
    stoneMason = game.AI.Spawn(thisLevel, spawnPos, spawnFace, "CRT_StoneMason00", spawnMove)
  end
end
function GetBaldurHealthVariables()
  if baldur ~= nil then
    BaldurHealthTotal = baldur:LookupConstant("BALDUR_HEALTH_TOTAL_STONEMASON")
    BaldurHealthMax_Phase_0 = baldur:LookupConstant("BALDUR_HEALTH_MAX_STONEMASON_PH_0")
    BaldurHealthMin_Phase_0 = baldur:LookupConstant("BALDUR_HEALTH_MIN_STONEMASON_PH_0")
    BaldurHealthMax_Phase_1A = baldur:LookupConstant("BALDUR_HEALTH_MAX_STONEMASON_PH_1A")
    BaldurHealthMin_Phase_1A = baldur:LookupConstant("BALDUR_HEALTH_MIN_STONEMASON_PH_1A")
    BaldurHealthMax_Phase_1B = baldur:LookupConstant("BALDUR_HEALTH_MAX_STONEMASON_PH_1B")
    BaldurHealthMin_Phase_1B = baldur:LookupConstant("BALDUR_HEALTH_MIN_STONEMASON_PH_1B")
    BaldurHealthMax_Phase_2 = baldur:LookupConstant("BALDUR_HEALTH_MAX_STONEMASON_PH_2")
    BaldurHealthMin_Phase_2 = baldur:LookupConstant("BALDUR_HEALTH_MIN_STONEMASON_PH_2")
    BaldurHealthMax_Phase_4 = baldur:LookupConstant("BALDUR_HEALTH_MAX_STONEMASON_PH_4")
    BaldurHealthMin_Phase_4 = baldur:LookupConstant("BALDUR_HEALTH_MIN_STONEMASON_PH_4")
    BaldurHealthTrigger_StoneMasonAttack_01 = BaldurHealthMax_Phase_1B - 50
    BaldurHealthTrigger_StoneMasonAttack_02 = BaldurHealthMax_Phase_1B - 100
    BaldurHealthTrigger_StoneMasonAttack_03 = BaldurHealthMax_Phase_1B - 150
    BaldurHealthTrigger_StoneMasonAttack_04 = BaldurHealthMax_Phase_1B - 200
    BaldurHealthTrigger_StoneMasonAttack_05 = BaldurHealthMax_Phase_1B - 250
    print("Total: " .. BaldurHealthTotal)
    print("P0: " .. BaldurHealthMax_Phase_0 .. " - " .. BaldurHealthMin_Phase_0)
    print("P1A: " .. BaldurHealthMax_Phase_1A .. " - " .. BaldurHealthMin_Phase_1A)
    print("P1B: " .. BaldurHealthMax_Phase_1B .. " - " .. BaldurHealthMin_Phase_1B)
    print("P2: " .. BaldurHealthMax_Phase_2 .. " - " .. BaldurHealthMin_Phase_2)
    print("P4: " .. BaldurHealthMax_Phase_4 .. " - " .. BaldurHealthMin_Phase_4)
    print("Att1: " .. BaldurHealthTrigger_StoneMasonAttack_01)
    print("Att2: " .. BaldurHealthTrigger_StoneMasonAttack_02)
    print("Att3: " .. BaldurHealthTrigger_StoneMasonAttack_03)
    print("Att4: " .. BaldurHealthTrigger_StoneMasonAttack_04)
    print("Att5: " .. BaldurHealthTrigger_StoneMasonAttack_05)
  else
    engine.Error("ERROR: Baldur is NIL")
  end
end
function IsBaldurReadyToTransition()
  local retVal = false
  if baldur:HasMarker("React") then
    retVal = true
  end
  return retVal
end
function SpawnFreyaAfterFinalFightIntro()
  local spawnPos = DL.GetMarkerPosition(thisLevel, "Freya_Locator")
  local spawnFace = DL.GetMarkerRotation(thisLevel, "Freya_Locator")
  if freya == nil then
    freya = game.AI.Spawn(thisLevel, spawnPos, spawnFace, "CRT_Freya00", "BRA_FinalFightIntroExit")
    if not freya:PickupIsAcquired("Freya_StoneMasonBoss") then
      freya:PickupAcquire("Freya_StoneMasonBoss")
    end
  end
  beginFromFinalFightIntro = true
end
function FreyaFinishFinalFightIntroTransition()
  GameObjects.Btr_FinalFight.LuaObjectScript.PlayHawkAndShove()
end
function StageSetup(currentStage, descString, isPreElement)
  DL.NewGamePlusLevelBoostFlat(baldur, 3)
  local PreElementalBaldur
  if isPreElement ~= nil then
    PreElementalBaldur = isPreElement
  end
  GetBaldurHealthVariables()
  baldur:RemoveMarker("SM_Stage_0")
  baldur:RemoveMarker("SM_Stage_1A")
  baldur:RemoveMarker("SM_Stage_1B")
  baldur:RemoveMarker("SM_Stage_2")
  baldur:RemoveMarker("SM_Stage_4")
  GameObjects.Stn980_Stage_0:HideEntityVolume()
  GameObjects.Stn980_Stage_1:HideEntityVolume()
  GameObjects.Stn980_Stage_2:HideEntityVolume()
  GameObjects.Stn980_Stage_3:HideEntityVolume()
  GameObjects.Stn980_Stage_4:HideEntityVolume()
  if currentStage == 0 then
    varBossStage = 0
    GameObjects.Stn980_Stage_0:ShowEntityVolume()
  elseif currentStage == 1 then
    varBossStage = 1
    GameObjects.Stn980_Stage_1:ShowEntityVolume()
  elseif currentStage == 2 then
    varBossStage = 2
    GameObjects.Stn980_Stage_2:ShowEntityVolume()
  elseif currentStage == 3 then
    varBossStage = 3
    timers.StartLevelTimer(3, function()
      GameObjects.Stn980_Stage_3:ShowEntityVolume()
    end)
  elseif currentStage == 4 then
    varBossStage = 4
    GameObjects.Stn980_Stage_3:ShowEntityVolume()
  elseif currentStage == 5 then
    varBossStage = 5
  end
  if currentStage == 0 then
    baldur:AddMarker("SM_Stage_0")
    baldur:PickupAcquire("Baldur_StoneMasonBoss")
    baldur:PickupSetStage("Baldur_StoneMasonBoss", 0)
  elseif currentStage == 1 and PreElementalBaldur == true then
    baldur:AddMarker("SM_Stage_1A")
    baldur:PickupAcquire("Baldur_StoneMasonBoss")
    baldur:PickupSetStage("Baldur_StoneMasonBoss", 4)
  elseif currentStage == 1 and PreElementalBaldur == false then
    baldur:AddMarker("SM_Stage_1B")
    baldur:PickupAcquire("Baldur_StoneMasonBoss")
    baldur:PickupSetStage("Baldur_StoneMasonBoss", 1)
  elseif currentStage == 2 then
    baldur:AddMarker("SM_Stage_2")
    baldur:PickupAcquire("Baldur_StoneMasonBoss")
    baldur:PickupSetStage("Baldur_StoneMasonBoss", 2)
  elseif currentStage == 4 then
    baldur:AddMarker("SM_Stage_4")
    baldur:PickupAcquire("Baldur_StoneMasonBoss")
    baldur:PickupSetStage("Baldur_StoneMasonBoss", 3)
  end
  if not baldur:PickupIsAcquired("Baldur_Attributes") then
    baldur:PickupAcquire("Baldur_Attributes")
    baldur:PickupSetStage("Baldur_Attributes", 1)
  else
    baldur:PickupSetStage("Baldur_Attributes", 1)
  end
end
function CheckAdvanceStageMove()
  if player:IsPlayingMove("MOV_TriggerNextMove") or baldur:IsPlayingMove("MOV_TriggerNextMove") then
    player:TriggerMoveEvent("kLETransitionExecuted")
    baldur:TriggerMoveEvent("kLETransitionExecuted")
    return true
  end
  return false
end
function TeleportKratosSonBaldur(playerLoc, sonLoc, baldurLoc)
  if playerLoc ~= nil then
    DL.WarpPlayer(thisLevel, playerLoc)
  end
  if sonLoc ~= nil then
    DL.WarpCreature(son, thisLevel, sonLoc)
  end
  if baldurLoc ~= nil then
    DL.WarpCreature(baldur, thisLevel, baldurLoc)
  end
end
function UpdateMotionWarpDrivers()
end
function Phase2_CreateIntroProjectionEncounter()
  if Phase2_IntroProjectionEncounter == nil then
    Phase2_IntroProjectionEncounter = EC.NewEncounter(thisLevel, "Phase2_IntroProjectionEncounter")
    Phase2_IntroProjectionEncounter:AddWave({
      {
        spawners = "Ph2_Enc_Intro_Spawner_0",
        maxActive = 1,
        totalSpawns = 1,
        spawnCooldown = 0.1
      },
      {
        spawners = "Ph2_Enc_Intro_Spawner_1",
        maxActive = 1,
        totalSpawns = 1,
        spawnCooldown = 0.2
      },
      {
        spawners = "Ph2_Enc_Intro_Spawner_2",
        maxActive = 1,
        totalSpawns = 1,
        spawnCooldown = 0.3
      },
      {
        spawners = "Ph2_Enc_Intro_Spawner_3",
        maxActive = 1,
        totalSpawns = 1,
        spawnCooldown = 0.4
      }
    })
  end
  Phase2_IntroProjectionEncounter:OnComplete(function()
    Phase2_MainProjectionEncounter:Start()
  end)
end
function Phase2_CreateMainProjectionEncounter()
  if Phase2_MainProjectionEncounter == nil then
    Phase2_MainProjectionEncounter = EC.NewEncounter(thisLevel, "Phase2_MainProjectionEncounter")
    Phase2_MainProjectionEncounter:AddWave({
      infiniteSpawning = false,
      spawnPattern = "Random",
      timeBetweenWaves = 30,
      {
        spawners = "Ph2_Enc_Spawner",
        spawnLocators = "Ph2_Enc_Loc_*",
        useSpawnLocatorsOnly = true,
        prioritizeSpawnersInRange = {8, 15},
        prioritizeOnScreenSpawners = true,
        minActive = 0,
        maxActive = 6,
        initialSpawnAmount = 1,
        totalSpawns = 6,
        initialSpawnCooldown = 3,
        spawnCooldownType = "Sequential",
        spawnCooldown = {
          0.15,
          0.15,
          0.15,
          0.15,
          0.15
        }
      }
    })
    Phase2_MainProjectionEncounter:AddWave({
      infiniteSpawning = false,
      spawnPattern = "Random",
      timeBetweenWaves = 30,
      {
        spawners = "Ph2_Enc_Spawner",
        spawnLocators = "Ph2_Enc_Loc_*",
        useSpawnLocatorsOnly = true,
        prioritizeSpawnersInRange = {8, 15},
        prioritizeOnScreenSpawners = true,
        minActive = 0,
        maxActive = 6,
        initialSpawnAmount = 1,
        totalSpawns = 6,
        initialSpawnCooldown = 3,
        spawnCooldownType = "Sequential",
        spawnCooldown = {
          0.15,
          0.15,
          0.15,
          0.15,
          0.15
        }
      }
    })
    Phase2_MainProjectionEncounter:AddWave({
      infiniteSpawning = false,
      recurring = true,
      recurringCooldown = 30,
      requiredWaveCompletion = 50,
      spawnPattern = "Random",
      {
        spawners = "Ph2_Enc_Spawner",
        spawnLocators = "Ph2_Enc_Loc_*",
        useSpawnLocatorsOnly = true,
        prioritizeSpawnersInRange = {8, 15},
        prioritizeOnScreenSpawners = true,
        minActive = 0,
        maxActive = 5,
        initialSpawnAmount = 1,
        totalSpawns = 5,
        initialSpawnCooldown = 3,
        spawnCooldownType = "Sequential",
        spawnCooldown = {
          0.15,
          0.15,
          0.15,
          0.15
        }
      }
    })
    Phase2_MainProjectionEncounter:OnStart(function()
      stoneMason:TriggerMoveEvent("LE_AttSummonClones")
    end, 1)
    Phase2_MainProjectionEncounter:OnStart(function()
      stoneMason:TriggerMoveEvent("LE_AttSummonClones")
    end, 2)
    Phase2_MainProjectionEncounter:OnStart(function()
      stoneMason:TriggerMoveEvent("LE_AttSummonClones")
    end, 3)
  end
end
function Phase2_CleanUpProjectionEncounters()
  if Phase2_IntroProjectionEncounter ~= nil then
    Phase2_IntroProjectionEncounter:DespawnEnemies()
    Phase2_IntroProjectionEncounter:SetComplete()
    Phase2_IntroProjectionEncounter = nil
  end
  if Phase2_MainProjectionEncounter ~= nil then
    Phase2_MainProjectionEncounter:StopRecurringWaves()
    Phase2_MainProjectionEncounter:DespawnEnemies()
    Phase2_MainProjectionEncounter:SetComplete()
    Phase2_MainProjectionEncounter = nil
  end
end
function Phase2_CleanUpProjectionEncounters_NoDespawn()
  if Phase2_IntroProjectionEncounter ~= nil then
    Phase2_IntroProjectionEncounter:SetComplete()
    Phase2_IntroProjectionEncounter = nil
  end
  if Phase2_MainProjectionEncounter ~= nil then
    Phase2_MainProjectionEncounter:StopRecurringWaves()
    Phase2_MainProjectionEncounter:SetComplete()
    Phase2_MainProjectionEncounter = nil
  end
end
function IceBreathSnowblindLogic()
  if player:IsPlayingMove("MOV_StoneMason_HitIceBreathSnowblind") and iceBreathSnowblind == false then
    timers.StartLevelTimer(iceBreathSnowblindTimer, RemoveIceBreathSnowblind)
    iceBreathSnowblind = true
    print("Snowblind On")
  end
end
function RemoveIceBreathSnowblind()
  if iceBreathSnowblind == true then
    player:TriggerMoveEvent("LE_SM_StoneMasonRemoveSnowblind")
    iceBreathSnowblind = false
    print("Snowblind OFF")
  end
end
function ForceWeaponOnBack(anyObj, callback)
  local heroPuppeteer = game.Puppeteer.NewForce(anyObj, "Force Weapon on Back", player)
  heroPuppeteer:WeaponEquip({weaponMode = "BareOnBack"})
  heroPuppeteer:OnComplete(function()
    heroPuppeteer:Clear()
    heroPuppeteer = nil
    if callback ~= nil and type(callback) == "function" then
      callback()
    end
  end)
end
function BackToBackWarpBaldur()
  DL.WarpCreature(baldur, thisLevel, "StoneMason_Locator")
end
function BackToBackRotateKratos()
  if player:HasMarker("Knockback") ~= true and player:HasMarker("NoTurning") ~= true then
    if game.Camera.GetOrbitRotationRelative() >= 15 then
      if player:HasMarker("LUA_StopTurn") == true then
        player:RemoveMarker("LUA_StopTurn")
      end
      if player:HasMarker("LUA_TurnL") == false then
        player:AddMarker("LUA_TurnL")
      end
      if player:HasMarker("LUA_TurnR") == true then
        player:RemoveMarker("LUA_TurnR")
      end
    elseif game.Camera.GetOrbitRotationRelative() <= -15 then
      if player:HasMarker("LUA_StopTurn") == true then
        player:RemoveMarker("LUA_StopTurn")
      end
      if player:HasMarker("LUA_TurnR") == false then
        player:AddMarker("LUA_TurnR")
      end
      if player:HasMarker("LUA_TurnL") == true then
        player:RemoveMarker("LUA_TurnL")
      end
    elseif game.Camera.GetOrbitRotationRelative() < 1 and game.Camera.GetOrbitRotationRelative() > -1 then
      if player:HasMarker("LUA_TurnR") == true then
        player:RemoveMarker("LUA_TurnR")
      end
      if player:HasMarker("LUA_TurnL") == true then
        player:RemoveMarker("LUA_TurnL")
      end
      if player:HasMarker("LUA_StopTurn") == false then
        player:AddMarker("LUA_StopTurn")
      end
    end
  end
end
function CameraStartBackToBackEarlySubmit()
  oneshotSnowBlindHoldHack = CCOS.OneShotCamera.New("CBT_StoneMasonSnowblind", 3, nil)
  oneshotSnowBlindHoldHack:Start()
  oneshotSnowBlindHoldHack:SetCallback(CameraDestroyBackToBackEarlySubmit)
end
function CameraDestroyBackToBackEarlySubmit()
  oneshotSnowBlindHoldHack = nil
end
function GetOrbitalRotation()
  local cameraOrbitString
  local yaw = game.Camera.GetOrbitRotation()
  if -45 < yaw and yaw < 45 then
    cameraOrbitString = "North"
  elseif -135 < yaw and yaw < -45 then
    cameraOrbitString = "East"
  elseif yaw < -135 and -180 < yaw or 135 < yaw and yaw < 180 then
    cameraOrbitString = "South"
  elseif 45 < yaw and yaw < 135 then
    cameraOrbitString = "West"
  else
    cameraOrbitString = "NO DIRECTION IN RANGE"
  end
  print("Current Camera Facing: " .. cameraOrbitString)
  return cameraOrbitString
end
function CameraStartMasonGroundPoundIntro()
  oneshotCameraMasonGroundPoundIntro = CCOS.OneShotCamera.New("PLYR_Vista_StoneMason_HandRemove", 3, nil)
  oneshotCameraMasonGroundPoundIntro:Start()
  oneshotCameraMasonGroundPoundIntro:SetCallback(CameraDestroyGroundPoundIntroOneShot)
end
function CameraDestroyGroundPoundIntroOneShot()
  oneshotCameraMasonGroundPoundIntro = nil
end
function CameraStartMasonCookieIntro()
  oneshotCameraCookieIntro = CCOS.OneShotCamera.New("PLYR_Vista_StoneMason_Cookie_010", 5, nil)
  oneshotCameraCookieIntro:Start()
  oneshotCameraCookieIntro:SetCallback(CameraDestroyCookieIntroOneShot)
end
function CameraDestroyCookieIntroOneShot()
  oneshotCameraCookieIntro = nil
end
function SonDisableCombat()
  local son = game.AI.FindSon()
  if son:HasMarker("BossDoNotShoot") == false then
    game.AI.FindSon():AddMarker("BossDoNotShoot")
  end
end
function SonDisableSynchAndCombat()
  local availabilityState = {AvailableForSync = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  local son = game.AI.FindSon()
  if son:HasMarker("BossDoNotShoot") == false then
    game.AI.FindSon():AddMarker("BossDoNotShoot")
  end
end
function SonClearAvailabilityRequests()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  local son = game.AI.FindSon()
  if son:HasMarker("BossDoNotShoot") then
    game.AI.FindSon():RemoveMarker("BossDoNotShoot")
  end
end
function ClearSonSpecialAttacks()
  local permLevel = game.Level.GetPermLevel()
  local summonScript1 = permLevel:FindSingleGameObject("*summonfen*")
  local summonScript2 = permLevel:FindSingleGameObject("*summondeer*")
  local summonScript3 = permLevel:FindSingleGameObject("*summonboar*")
  local summonScript4 = permLevel:FindSingleGameObject("*summonsouls*")
  local summonScript5 = permLevel:FindSingleGameObject("*summonbird*")
  if summonScript1 ~= nil then
    summonScript1:CallScript("DestroySummons")
  end
  if summonScript2 ~= nil then
    summonScript2:CallScript("DestroySummons")
  end
  if summonScript3 ~= nil then
    summonScript3:CallScript("DestroySummons")
  end
  if summonScript4 ~= nil then
    summonScript4:CallScript("DestroySummons")
  end
  if summonScript5 ~= nil then
    summonScript5:CallScript("DestroySummons")
  end
end
function InputMaskChiselClimb()
  if pad.DisableGameButton and pad.EnableGameButton and engine.IsDebug() ~= true then
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
  end
end
function ClearInputMaskChiselClimb()
  if pad.EnableGameButton and engine.IsDebug() ~= true then
    pad:EnableGameButton(tweaks.ePad.kPadCross)
    pad:EnableGameButton(tweaks.ePad.kPadSquare)
    pad:EnableGameButton(tweaks.ePad.kPadTriangle)
    pad:EnableGameButton(tweaks.ePad.kPadL1)
    pad:EnableGameButton(tweaks.ePad.kPadL2)
    pad:EnableGameButton(tweaks.ePad.kPadR1)
    pad:EnableGameButton(tweaks.ePad.kPadR2)
    pad:EnableGameButton(tweaks.ePad.kPadUp)
    pad:EnableGameButton(tweaks.ePad.kPadLeft)
    pad:EnableGameButton(tweaks.ePad.kPadRight)
    pad:EnableGameButton(tweaks.ePad.kPadDown)
  end
end
function ClearStatusEffect()
  if player:MeterGetValue("Blind") > 0 then
    player:MeterSetValue("Blind", 0)
  end
  if player:PickupIsAcquired("Debuff_Hero_Blind") then
    player:PickupRelinquish("Debuff_Hero_Blind")
  end
  if 0 < player:MeterGetValue("Burn") then
    player:MeterSetValue("Burn", 0)
  end
  if player:PickupIsAcquired("Debuff_Hero_Burn") then
    player:PickupRelinquish("Debuff_Hero_Burn")
  end
  if 0 < player:MeterGetValue("Frost") then
    player:MeterSetValue("Frost", 0)
  end
  if player:PickupIsAcquired("Debuff_Hero_Frost") then
    player:PickupRelinquish("Debuff_Hero_Frost")
  end
  if 0 < player:MeterGetValue("Daze") then
    player:MeterSetValue("Daze", 0)
  end
  if player:PickupIsAcquired("Debuff_Hero_Daze") then
    player:PickupRelinquish("Debuff_Hero_Daze")
  end
  if player:HasMeter("Momentum") then
    player:MeterSetValue("Momentum", 0)
  end
  if player:HasMeter("MomentumBlades") then
    player:MeterSetValue("MomentumBlades", 0)
  end
end
function StartVineAttackBanterPhase0()
  GameObjects.Btr_FinalFight.LuaObjectScript.StartVineAttackPhase0()
end
function Stn910_SMBoss_Phase0_Bookmark()
  GameObjects.Stn980_Stage_0:ShowEntityVolume()
  GameObjects.Stn980_Stage_1:HideEntityVolume()
  GameObjects.Stn980_Stage_2:HideEntityVolume()
  GameObjects.Stn980_Stage_3:HideEntityVolume()
  GameObjects.Stn980_Stage_4:HideEntityVolume()
  if player.Pad.L1Down and player.Pad.L2Down then
    BossEncounter:SetActiveState("BossStage_0_1")
    TeleportKratosSonBaldur("Ph0_Start_Kratos", "Ph0_Start_Son", "Ph0_Start_Baldur")
  end
end
function OnEvaluateLoadGroup_Cinematic()
  if varBossStage == 0 then
    return "BeginningCine"
  elseif varBossStage == 1 then
    return "EndingCine"
  elseif varBossStage == 2 then
    return "EndingCine"
  elseif varBossStage == 3 then
    return "EndingCine"
  elseif varBossStage == 4 then
    return "EndingCine"
  elseif varBossStage == 5 then
    return "EndingCine"
  else
    return nil
  end
end
