local class = require("core.class")
local thunk = require("core.thunk")
local WEAK = {__mode = "k"}
local activeRequests = setmetatable({}, WEAK)
local OnAIUpdate = function(ai)
  for r in pairs(activeRequests) do
    r.result = ai:FindTarget(r.tweakName)
  end
end
thunk.Install("OnAIUpdate", OnAIUpdate)
local TargetRequester = class.Class("TargetRequester")
function TargetRequester:init(tweakName)
  assert(tweakName, "No tweak name given")
  self.tweakName = tweakName
end
function TargetRequester:SetTweak(tweakName)
  self.tweakName = tweakName
end
function TargetRequester:Start()
  activeRequests[self] = true
end
function TargetRequester:Stop()
  activeRequests[self] = nil
  self.result = nil
end
function TargetRequester:GetResult()
  return self.result
end
return {TargetRequester = TargetRequester}
