local class = require("core.class")
local thunk = require("core.thunk")
local WEAK = {__mode = "k"}
local activeRequests = setmetatable({}, WEAK)
local vfsDebug = engine.VFSBool.New("Debug Theater of Operations")
local OnAIUpdate = function(ai)
  local updated = false
  for r in pairs(activeRequests) do
    assert(not updated, "Performing more than one TheaterOfOperationsUpdate in a single frame!")
    r.params.DebugDraw = vfsDebug.value
    game.AIUtil.TheaterOfOperationsUpdate(ai, r.params)
    r.result = nil
    updated = true
  end
end
thunk.Install("OnAIUpdate", OnAIUpdate)
local TheaterOfOperationsRequester = class.Class("TheaterOfOperationsRequester")
function TheaterOfOperationsRequester:init(ai, tweakName)
  assert(tweakName, "No tweak name given")
  print(ai:GetName())
  self.params = {TweakName = tweakName}
  self.ai = ai
end
function TheaterOfOperationsRequester:SetTarget(target)
  self.params.Target = target
  self.params.UseGoal = false
end
function TheaterOfOperationsRequester:SetGoal(goal)
  self.params.Goal = goal
  self.params.UseGoal = true
end
function TheaterOfOperationsRequester:SetTweak(tweakName)
  self.params.TweakName = tweakName
end
function TheaterOfOperationsRequester:Start()
  activeRequests[self] = true
end
function TheaterOfOperationsRequester:Stop()
  activeRequests[self] = nil
  self.result = nil
end
function TheaterOfOperationsRequester:GetResult()
  if not self.result then
    self.result = game.AIUtil.TheaterOfOperationsCalculateResult(self.ai, self.params)
  end
  return self.result
end
return {TheaterOfOperationsRequester = TheaterOfOperationsRequester}
